/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring;

import java.text.MessageFormat;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.model.ui.editors.LibraryElementProvider;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.CommandUndoChange;
import org.eclipse.gef.commands.Command;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public abstract class AbstractCommandChange<T extends EObject>
extends CompositeChange {
    private final URI elementURI;
    private final Class<T> elementClass;
    private final TypeEntry typeEntry;
    private IEditorPart editor;

    protected AbstractCommandChange(URI elementURI, Class<T> elementClass) {
        this(elementURI.lastSegment(), elementURI, elementClass);
    }

    protected AbstractCommandChange(String name, URI elementURI, Class<T> elementClass) {
        super(name);
        this.elementURI = Objects.requireNonNull(elementURI);
        this.elementClass = Objects.requireNonNull(elementClass);
        this.typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForURI(elementURI);
    }

    public final void initializeValidationData(IProgressMonitor pm) {
        this.initializeEditor();
        LibraryElement libraryElement = this.acquireLibraryElement(false);
        T element = this.getElement(libraryElement);
        if (element != null) {
            this.initializeValidationData(element, pm);
        }
    }

    public abstract void initializeValidationData(T var1, IProgressMonitor var2);

    public final RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        LibraryElement libraryElement = this.acquireLibraryElement(false);
        T element = this.getElement(libraryElement);
        if (element == null) {
            status.addFatalError(MessageFormat.format(Messages.AbstractCommandChange_NoSuchElement, this.elementURI));
        } else {
            status.merge(this.isValid(element, pm));
        }
        return status;
    }

    public abstract RefactoringStatus isValid(T var1, IProgressMonitor var2) throws CoreException, OperationCanceledException;

    public final Change perform(IProgressMonitor pm) throws CoreException {
        if (this.performInUIThread() && Display.getCurrent() == null) {
            Change[] change = new Change[1];
            CoreException[] coreException = new CoreException[1];
            Display.getDefault().syncExec(() -> {
                try {
                    changeArray[0] = this.doPerform(pm);
                }
                catch (CoreException e) {
                    coreExceptionArray[0] = e;
                }
            });
            if (coreException[0] != null) {
                throw coreException[0];
            }
            return change[0];
        }
        return this.doPerform(pm);
    }

    private Change doPerform(IProgressMonitor pm) throws CoreException {
        LibraryElement libraryElement = this.acquireLibraryElement(true);
        T element = this.getElement(libraryElement);
        if (element == null) {
            throw new CoreException(Status.error((String)MessageFormat.format(Messages.AbstractCommandChange_NoSuchElement, this.elementURI)));
        }
        Command command = this.performCommand(element);
        this.commit(libraryElement, pm);
        return this.createUndoChange(command, libraryElement);
    }

    protected Command performCommand(T element) throws CoreException {
        Command command = Objects.requireNonNull(this.createCommand(element));
        if (!command.canExecute()) {
            throw new CoreException(Status.error((String)MessageFormat.format(Messages.AbstractCommandChange_CannotExecuteCommand, command.getClass().getName(), ((Object)((Object)this)).getClass().getName(), this.elementURI)));
        }
        command.execute();
        return command;
    }

    protected abstract Command createCommand(T var1) throws CoreException;

    protected LibraryElement acquireLibraryElement(boolean editable) {
        if (this.editor != null) {
            return (LibraryElement)Adapters.adapt((Object)this.editor, LibraryElement.class);
        }
        if (this.typeEntry != null) {
            return editable ? this.typeEntry.copyType() : this.typeEntry.getType();
        }
        return null;
    }

    private void commit(LibraryElement libraryElement, IProgressMonitor pm) throws CoreException {
        if (this.editor != null) {
            LibraryElementProvider.INSTANCE.saveLibraryElement(this.editor.getEditorInput(), pm);
        } else if (this.typeEntry != null) {
            this.typeEntry.save(libraryElement, pm);
        }
    }

    protected Change createUndoChange(Command command, LibraryElement libraryElement) {
        return new CommandUndoChange<T>(this.getName(), this.elementURI, this.elementClass, command, libraryElement);
    }

    public final void add(Change change) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot add any changes to this " + ((Object)((Object)this)).getClass().getName());
    }

    public final IFile getModifiedElement() {
        if (this.typeEntry != null) {
            return this.typeEntry.getFile();
        }
        if (this.elementURI.isPlatformResource()) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.elementURI.toPlatformString(true)));
        }
        return null;
    }

    public final Object[] getAffectedObjects() {
        IFile modifiedElement = this.getModifiedElement();
        if (modifiedElement != null) {
            return new Object[]{modifiedElement};
        }
        return super.getAffectedObjects();
    }

    public final URI getElementURI() {
        return this.elementURI;
    }

    public final Class<T> getElementClass() {
        return this.elementClass;
    }

    public final IEditorPart getEditor() {
        return this.editor;
    }

    private T getElement(LibraryElement libraryElement) {
        Object element;
        if (libraryElement != null && libraryElement.eResource() != null && this.elementClass.isInstance(element = this.elementURI.hasFragment() ? libraryElement.eResource().getEObject(this.elementURI.fragment()) : libraryElement)) {
            return (T)((EObject)this.elementClass.cast(element));
        }
        return null;
    }

    protected boolean performInUIThread() {
        return this.editor != null;
    }

    private void initializeEditor() {
        FileEditorInput editorInput = new FileEditorInput(this.getModifiedElement());
        Display.getDefault().syncExec(() -> this.lambda$1((IEditorInput)editorInput));
    }

    private /* synthetic */ void lambda$1(IEditorInput iEditorInput) {
        IEditorPart iEditorPart = this.editor = (IEditorPart)Stream.of(PlatformUI.getWorkbench().getWorkbenchWindows()).flatMap(window -> Stream.of(window.getPages())).map(page -> page.findEditor(iEditorInput)).filter(Objects::nonNull).findAny().orElse(null);
    }
}

