/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.ui.PlatformUI;

public final class RefactoringUtil {
    public static void saveAllAndBuild() throws InvocationTargetException, InterruptedException {
        PlatformUI.getWorkbench().saveAllEditors(false);
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(RefactoringUtil::waitForBuild);
    }

    private static void waitForBuild(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            ResourcesPlugin.getWorkspace().build(10, (IProgressMonitor)progress.split(8));
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)progress.split(2));
        }
        catch (CoreException | OperationCanceledException e) {
            throw new InvocationTargetException(e);
        }
    }

    public static boolean containsTypeEntryFile(IResource resource) {
        try {
            return RefactoringUtil.containsTypeEntry(resource);
        }
        catch (CoreException e) {
            return false;
        }
    }

    private static boolean containsTypeEntry(IResource resource) throws CoreException {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            if (TypeLibraryManager.INSTANCE.getTypeEntryForFile(file) != null) {
                return true;
            }
        } else if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (RefactoringUtil.containsTypeEntry(member)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return false;
    }

    private RefactoringUtil() {
        throw new UnsupportedOperationException();
    }
}

