/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.connection;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.IdentifierVerifier;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterfaceFBType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.search.types.BlockTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.typelibrary.InterfaceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.CommandCompositeChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ModelEditChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.connection.CreateStructChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.connection.ReplaceVarsWithStructModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.connection.SystemConnectStructModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.connection.SystemRepairBrokenConnectionModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.connection.SystemUpdateFBModelEdit;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class ConnectionsToStructRefactoring
extends Refactoring {
    private final URI sourceURI;
    private final URI destinationURI;
    private final Map<String, String> replaceableConMap;
    private URI structURI;
    private String sourceVarName;
    private String destinationVarName;
    private boolean conflictResolution;
    private final Collection<VarDeclaration> vars;
    private final TypeLibrary lib;
    private List<ModelEdit<?>> modelEdits;

    public ConnectionsToStructRefactoring(FBType sourceType, FBType destinationType, Map<String, String> replacableConMap) {
        this.sourceURI = EcoreUtil.getURI((EObject)((EObject)Objects.requireNonNull(sourceType)));
        this.destinationURI = EcoreUtil.getURI((EObject)((EObject)Objects.requireNonNull(destinationType)));
        this.replaceableConMap = Objects.requireNonNull(replacableConMap);
        this.vars = sourceType.getInterfaceList().getAllOutputs().filter(port -> replacableConMap.containsKey(port.getName())).filter(VarDeclaration.class::isInstance).map(VarDeclaration.class::cast).toList();
        this.lib = sourceType.getTypeLibrary();
    }

    public final String getName() {
        return Messages.ConnectionsToStructRefactoring_RefactoringTitle;
    }

    public RefactoringStatus setUserConfig(URI structURI, String sourceVarName, String destinationVarName, boolean conflictResolution) {
        this.structURI = structURI;
        this.sourceVarName = sourceVarName;
        this.destinationVarName = destinationVarName;
        this.conflictResolution = conflictResolution;
        return this.checkFinalConditions();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) {
        RefactoringStatus status = new RefactoringStatus();
        try {
            this.checkInitialFB(status, this.sourceURI, true);
            this.checkInitialFB(status, this.destinationURI, false);
        }
        finally {
            pm.done();
        }
        return status;
    }

    private void checkInitialFB(RefactoringStatus status, URI uri, boolean isSource) {
        String target = isSource ? Messages.ConnectionsToStructRefactoring_Source : Messages.ConnectionsToStructRefactoring_Destination;
        LibraryElement libraryElement = TypeLibraryManager.INSTANCE.getTypeEntryForURI(uri).getType();
        if (libraryElement instanceof FBType) {
            ArrayList<String> varNames;
            EList interfaceList;
            FBType fbType = (FBType)libraryElement;
            if (isSource) {
                interfaceList = fbType.getInterfaceList().getOutputVars();
                varNames = new ArrayList<String>(this.replaceableConMap.keySet());
            } else {
                interfaceList = fbType.getInterfaceList().getInputVars();
                varNames = new ArrayList<String>(this.replaceableConMap.values());
            }
            if (fbType instanceof ServiceInterfaceFBType) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format(Messages.ConnectionsToStructRefactoring_IsServiceFB, target)));
            }
            if (varNames.stream().allMatch(arg_0 -> ConnectionsToStructRefactoring.lambda$3((List)interfaceList, arg_0))) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format(Messages.ConnectionsToStructRefactoring_PortsNoMatch, target)));
            }
            List referenceWiths = interfaceList.stream().filter(ielement -> ielement.getName().equals(varNames.getFirst())).map(VarDeclaration.class::cast).map(VarDeclaration::getWiths).map(withlist -> withlist.stream().map(EObject::eContainer).map(Event.class::cast).toList()).findFirst().orElse(new ArrayList());
            if (interfaceList.stream().filter(varDec -> varNames.contains(varDec.getName())).map(VarDeclaration::getWiths).map(withs -> withs.stream().map(EObject::eContainer).map(Event.class::cast).toList()).anyMatch(withlist -> !withlist.containsAll(referenceWiths) || withlist.size() != referenceWiths.size())) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format(Messages.ConnectionsToStructRefactoring_EventConflict, target)));
            }
        } else {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format(Messages.ConnectionsToStructRefactoring_NoFB, target)));
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.checkFinalConditions();
    }

    private RefactoringStatus checkFinalConditions() {
        RefactoringStatus status = new RefactoringStatus();
        this.checkStruct(status);
        this.checkName(status, this.sourceVarName, true);
        this.checkName(status, this.destinationVarName, false);
        if (this.destinationURI.toString().equals(this.sourceURI.toString()) && this.sourceVarName.equals(this.destinationVarName)) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.ConnectionsToStructRefactoring_SameFBSameName));
        }
        if (this.conflictResolution && (this.lib.getFBTypeEntry("STRUCT_DEMUX") == null || this.lib.getFBTypeEntry("STRUCT_MUX") == null)) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.ConnectionsToStructRefactoring_MissingStructManipulator));
        }
        return status;
    }

    private void checkStruct(RefactoringStatus status) {
        if (this.structURI != null) {
            LibraryElement libraryElement;
            TypeEntry structTypeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForURI(this.structURI);
            if (structTypeEntry != null && (libraryElement = structTypeEntry.getType()) instanceof DataType) {
                DataType type = (DataType)libraryElement;
                if (type instanceof StructuredType) {
                    StructuredType structType = (StructuredType)type;
                    if (!structType.getMemberVariables().stream().allMatch(structvar -> this.vars.stream().anyMatch(vardec -> vardec.getType().equals(structvar.getType()) && vardec.getName().equals(structvar.getName())))) {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.ConnectionsToStructRefactoring_IncompatibleStructType));
                    }
                } else {
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.ConnectionsToStructRefactoring_SelectionIsNoStruct));
                }
            } else if (this.lib.getDataTypeLibrary().getTypeIfExists(this.structURI.trimFileExtension().lastSegment()) != null) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.ConnectionsToStructRefactoring_StructExists));
            }
        } else {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.ConnectionsToStructRefactoring_InvalidType));
        }
    }

    private void checkName(RefactoringStatus status, String name, boolean isSource) {
        InterfaceTypeEntry ifTypeEntry;
        TypeEntry typeEntry;
        String target;
        Collection<String> nameCol;
        URI fbURI;
        if (isSource) {
            fbURI = this.sourceURI;
            nameCol = this.replaceableConMap.keySet();
            target = Messages.ConnectionsToStructRefactoring_Output;
        } else {
            fbURI = this.destinationURI;
            nameCol = this.replaceableConMap.values();
            target = Messages.ConnectionsToStructRefactoring_Input;
        }
        if (IdentifierVerifier.verifyIdentifier((String)name).isPresent()) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format(Messages.ConnectionsToStructRefactoring_InvalidName, target)));
        }
        if ((typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForURI(fbURI)) instanceof InterfaceTypeEntry && (ifTypeEntry = (InterfaceTypeEntry)typeEntry).getInterface().getAllInterfaceElements().anyMatch(port -> port.getName().equals(name)) && !nameCol.contains(name)) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format(Messages.ConnectionsToStructRefactoring_NameExists, target)));
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CommandCompositeChange compChange = new CommandCompositeChange(Messages.ConnectionsToStructRefactoring_ChangeName);
        this.modelEdits = new ArrayList();
        pm.beginTask(Messages.ConnectionsToStructRefactoring_ProgressText, 1);
        if (TypeLibraryManager.INSTANCE.getTypeEntryForURI(this.structURI) == null) {
            compChange.add(new CreateStructChange(this.structURI, this.vars));
        }
        this.modelEdits.add(new ReplaceVarsWithStructModelEdit(this.sourceURI, this.replaceableConMap.keySet(), this.structURI, this.sourceVarName, false, 0));
        this.modelEdits.add(new ReplaceVarsWithStructModelEdit(this.destinationURI, this.replaceableConMap.values(), this.structURI, this.destinationVarName, true, 0));
        LibraryElement libraryElement = TypeLibraryManager.INSTANCE.getTypeEntryForURI(this.sourceURI).getType();
        if (libraryElement instanceof FBType) {
            FBType sourceType = (FBType)libraryElement;
            LibraryElement libraryElement2 = TypeLibraryManager.INSTANCE.getTypeEntryForURI(this.destinationURI).getType();
            if (libraryElement2 instanceof FBType) {
                FBType destinationType = (FBType)libraryElement2;
                this.update(sourceType, destinationType);
                this.connect(sourceType, destinationType);
            }
        }
        pm.done();
        compChange.add((Change)ModelEditChange.fromModelEdits(Messages.ConnectionsToStructRefactoring_ChangeName, this.modelEdits));
        return compChange;
    }

    private void update(FBType sourceType, FBType destinationType) {
        HashMap<AutomationSystem, List<URI>> updateMap = new HashMap<AutomationSystem, List<URI>>();
        ConnectionsToStructRefactoring.createUpdateChanges(sourceType, updateMap);
        if (!this.sourceURI.toString().equals(this.destinationURI.toString())) {
            ConnectionsToStructRefactoring.createUpdateChanges(destinationType, updateMap);
        }
        updateMap.entrySet().forEach(entry -> {
            boolean bl = this.modelEdits.add(new SystemUpdateFBModelEdit(EcoreUtil.getURI((EObject)((EObject)entry.getKey())), (List)entry.getValue()));
        });
    }

    private static void createUpdateChanges(FBType sourceType, Map<AutomationSystem, List<URI>> updateMap) {
        new BlockTypeInstanceSearch(sourceType.getTypeEntry()).performSearch().stream().map(FBNetworkElement.class::cast).forEach(instance -> ConnectionsToStructRefactoring.addToMap(updateMap, instance));
    }

    private void connect(FBType sourceType, FBType destinationType) {
        HashMap connectMap = new HashMap();
        HashMap<FBNetworkElement, FBNetworkElement> correctConnectionMap = new HashMap<FBNetworkElement, FBNetworkElement>();
        List sourceSearch = new BlockTypeInstanceSearch(sourceType.getTypeEntry()).performSearch();
        List destinationSearch = new BlockTypeInstanceSearch(destinationType.getTypeEntry()).performSearch();
        destinationSearch.stream().map(BlockFBNetworkElement.class::cast).forEach(instance -> {
            List<Connection> cons = instance.getInterface().getAllInputs().map(IInterfaceElement::getInputConnections).flatMap(Collection::stream).filter(con -> this.replaceableConMap.containsKey(con.getSource().getName()) && this.replaceableConMap.get(con.getSource().getName()).equals(con.getDestination().getName()) && con.getSourceElement().getType().getName().equals(sourceType.getName())).toList();
            if (cons.stream().map(Connection::getSourceElement).distinct().count() == 1L && cons.size() == this.replaceableConMap.size()) {
                correctConnectionMap.put((FBNetworkElement)instance, (FBNetworkElement)cons.get(0).getSourceElement());
                ConnectionsToStructRefactoring.addToMap(connectMap, (FBNetworkElement)instance);
            }
        });
        connectMap.entrySet().forEach(entry -> {
            boolean bl = this.modelEdits.add(new SystemConnectStructModelEdit(EcoreUtil.getURI((EObject)((EObject)entry.getKey())), (List)entry.getValue(), this.replaceableConMap, this.sourceVarName, this.destinationVarName));
        });
        if (this.conflictResolution) {
            this.conflictResolution(sourceSearch, destinationSearch, correctConnectionMap);
        }
    }

    private void conflictResolution(List<? extends EObject> sourceSearch, List<? extends EObject> destinationSearch, Map<FBNetworkElement, FBNetworkElement> correctConnectionMap) {
        HashMap repairSourceMap = new HashMap();
        HashMap repairDestinationMap = new HashMap();
        destinationSearch.stream().map(BlockFBNetworkElement.class::cast).filter(instance -> !correctConnectionMap.containsKey(instance)).forEach(instance -> {
            if (instance.getInterface().getAllInputs().filter(input -> this.replaceableConMap.containsValue(input.getName())).map(IInterfaceElement::getInputConnections).flatMap(Collection::stream).findAny().isPresent()) {
                ConnectionsToStructRefactoring.addToMap(repairDestinationMap, (FBNetworkElement)instance);
            }
        });
        sourceSearch.stream().map(BlockFBNetworkElement.class::cast).forEach(instance -> {
            if (instance.getInterface().getAllOutputs().filter(output -> this.replaceableConMap.containsKey(output.getName())).map(IInterfaceElement::getOutputConnections).flatMap(Collection::stream).anyMatch(con -> !correctConnectionMap.containsKey(con.getDestinationElement()))) {
                ConnectionsToStructRefactoring.addToMap(repairSourceMap, (FBNetworkElement)instance);
            }
        });
        repairSourceMap.entrySet().forEach(entry -> {
            boolean bl = this.modelEdits.add(new SystemRepairBrokenConnectionModelEdit(EcoreUtil.getURI((EObject)((EObject)entry.getKey())), this.structURI, this.replaceableConMap, (List)entry.getValue(), true));
        });
        repairDestinationMap.entrySet().forEach(entry -> {
            boolean bl = this.modelEdits.add(new SystemRepairBrokenConnectionModelEdit(EcoreUtil.getURI((EObject)((EObject)entry.getKey())), this.structURI, this.replaceableConMap, (List)entry.getValue(), false));
        });
    }

    private static void addToMap(Map<AutomationSystem, List<URI>> map, FBNetworkElement element) {
        Optional.ofNullable(map.get(element.getFbNetwork().getAutomationSystem())).orElseGet(() -> {
            ArrayList list = new ArrayList();
            map.put(element.getFbNetwork().getAutomationSystem(), list);
            return list;
        }).add(EcoreUtil.getURI((EObject)element));
    }

    public TypeLibrary getTypeLibrary() {
        return this.lib;
    }

    private static /* synthetic */ boolean lambda$3(List list, String name) {
        return list.stream().map(INamedElement::getName).anyMatch(String.class::equals);
    }
}

