/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.copy;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.copy.FordiacCopyProcessor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;

public class CopyResourceChange
extends ResourceChange {
    private final IResource origin;
    private final IContainer destination;

    public CopyResourceChange(IResource origin, IContainer destination) {
        Assert.isTrue((origin instanceof IFile || origin instanceof IFolder ? 1 : 0) != 0);
        Assert.isTrue((destination instanceof IProject || destination instanceof IFolder ? 1 : 0) != 0);
        this.origin = origin;
        this.destination = destination;
    }

    public String getName() {
        return Messages.CopyResourceChange_Name.formatted(this.origin, this.destination);
    }

    public final Change perform(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask(this.getName(), 2);
            boolean performReorg = this.deleteIfAlreadyExists((IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)1), this.origin.getName());
            if (!performReorg) {
                return null;
            }
            IPath copyPath = this.destination.getFullPath().append(this.origin.getName());
            this.origin.copy(copyPath, CopyResourceChange.getReorgFlags(), (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)1));
            this.markAsExecuted(this.origin);
            DeleteResourceChange deleteResourceChange = new DeleteResourceChange(copyPath, false);
            return deleteResourceChange;
        }
        finally {
            pm.done();
        }
    }

    protected IResource getModifiedResource() {
        return this.origin;
    }

    private boolean deleteIfAlreadyExists(IProgressMonitor pm, String newName) throws CoreException {
        pm.beginTask("", 1);
        IResource current = this.destination.findMember(newName);
        if (current == null) {
            return true;
        }
        if (!current.exists()) {
            return true;
        }
        if (FordiacCopyProcessor.areEqualInWorkspaceOrOnDisk(this.origin, current)) {
            return false;
        }
        IResource iResource = current;
        Objects.requireNonNull(iResource);
        IResource iResource2 = iResource;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IFile.class, IFolder.class}, (Object)iResource2, 0)) {
            case 0: {
                IFile file = (IFile)iResource2;
                file.delete(false, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)1));
                break;
            }
            case 1: {
                IFolder folder = (IFolder)iResource2;
                folder.delete(false, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)1));
                break;
            }
            default: {
                Assert.isTrue((boolean)false);
            }
        }
        return true;
    }

    private static int getReorgFlags() {
        return 34;
    }

    private void markAsExecuted(IResource resource) {
        ReorgExecutionLog log = (ReorgExecutionLog)this.getAdapter(ReorgExecutionLog.class);
        if (log != null) {
            log.markAsProcessed((Object)resource);
        }
    }
}

