/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editors;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.editors.FBNElemEditorCloser;
import org.eclipse.fordiac.ide.application.editors.FBNetworkEditor;
import org.eclipse.fordiac.ide.application.editparts.UntypedSubAppEditPartFactory;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.TypedConfigureableObject;
import org.eclipse.fordiac.ide.model.ui.editors.EditorCloserAdapter;
import org.eclipse.fordiac.ide.model.ui.editors.LibraryElementProvider;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class SubAppNetworkEditor
extends FBNetworkEditor {
    private final Adapter adapter = new EditorCloserAdapter((IEditorPart)this){

        public void notifyChanged(Notification notification) {
            int featureId = notification.getFeatureID(TypedConfigureableObject.class);
            if (3 == featureId && SubAppNetworkEditor.this.getSubApp().isTyped() || this.isSubAppToggledToExpanded(notification)) {
                this.closeEditor();
            }
        }

        private boolean isSubAppToggledToExpanded(Notification msg) {
            Attribute att;
            Object object;
            return msg.getOldValue() == null && (object = msg.getNewValue()) instanceof Attribute && (att = (Attribute)object).getAttributeDeclaration() == InternalAttributeDeclarations.UNFOLDED && "true".equals(att.getValue());
        }
    };
    private Adapter fbNetworkAdapter;

    @Override
    public void dispose() {
        this.removeAdapters();
        super.dispose();
        this.getEditDomain().setPaletteViewer(null);
    }

    public void setInput(IEditorInput input) {
        SubApp subApp = (SubApp)LibraryElementProvider.INSTANCE.getElement(input, SubApp.class);
        if (subApp == null) {
            throw new IllegalArgumentException("SubApp editors only accept sub-applications as valid inputs!");
        }
        this.removeAdapters();
        this.setModel(subApp.getSubAppNetwork());
        this.addAdapters();
        super.setInput(input);
    }

    protected void addAdapters() {
        if (this.getSubApp() != null) {
            this.getSubApp().eAdapters().add((Object)this.adapter);
            EObject container = this.getSubApp().eContainer();
            if (container != null) {
                this.fbNetworkAdapter = new FBNElemEditorCloser((IEditorPart)this, (FBNetworkElement)this.getSubApp());
                container.eAdapters().add((Object)this.fbNetworkAdapter);
            }
        }
    }

    protected void removeAdapters() {
        if (this.getSubApp() != null) {
            this.getSubApp().eAdapters().remove((Object)this.adapter);
            EObject container = this.getSubApp().eContainer();
            if (container != null) {
                container.eAdapters().remove((Object)this.fbNetworkAdapter);
            }
        }
    }

    @Override
    protected EditPartFactory getEditPartFactory() {
        return new UntypedSubAppEditPartFactory((GraphicalEditor)this);
    }

    private SubApp getSubApp() {
        return this.getModel() != null ? (SubApp)this.getModel().eContainer() : null;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (FBNetworkElement.class == adapter) {
            return adapter.cast(this.getSubApp());
        }
        return super.getAdapter(adapter);
    }
}

