/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.tools;

import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.application.editparts.ConnectionEditPart;
import org.eclipse.fordiac.ide.application.tools.ColLocatedConnectionFinder;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.tools.AdvancedPanningSelectionTool;
import org.eclipse.fordiac.ide.gef.tools.InlineConnectionCreationTool;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;

public class FBNetworkPanningSelectionTool
extends AdvancedPanningSelectionTool {
    private static final int CONNECTION_CREATION_MOD_KEY = SWT.MOD1;
    private static final int LEFT_MOUSE = 1;
    private static final double TYPE_DISTANCE = 10.0;
    private Point lastLeftClick = new Point(0, 0);
    private InlineConnectionCreationTool connectionCreationTool;

    public void mouseDown(MouseEvent me, EditPartViewer viewer) {
        if (!this.checkConnCreationState(me.stateMask)) {
            super.mouseDown(me, viewer);
        }
    }

    public void mouseUp(MouseEvent me, EditPartViewer viewer) {
        if (this.checkConnCreationState(me.stateMask)) {
            this.connectionCreationTool.mouseUp(me, viewer);
        } else {
            if (1 == me.button) {
                this.lastLeftClick = this.getLocation();
            }
            super.mouseUp(me, viewer);
        }
    }

    public void keyDown(KeyEvent evt, EditPartViewer viewer) {
        EditPart editPart;
        if (Character.isLetterOrDigit(evt.character) && 10.0 > this.getLocation().getDistance(this.lastLeftClick) && (editPart = viewer.findObjectAt(this.getLocation())) != null) {
            SelectionRequest request = new SelectionRequest();
            request.setLocation(this.lastLeftClick);
            request.setType((Object)"open");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(String.valueOf(evt.character), String.valueOf(evt.character));
            request.setExtendedData(map);
            editPart.performRequest((Request)request);
            return;
        }
        if (evt.stateMask == 0) {
            this.checkConnCreationState(evt.keyCode);
        }
        super.keyDown(evt, viewer);
    }

    public void mouseMove(MouseEvent me, EditPartViewer viewer) {
        super.mouseMove(me, viewer);
        if (this.checkConnCreationState(me.stateMask)) {
            this.connectionCreationTool.mouseMove(me, viewer);
        }
    }

    public void mouseDrag(MouseEvent me, EditPartViewer viewer) {
        super.mouseDrag(me, viewer);
        if (this.checkConnCreationState(me.stateMask)) {
            this.connectionCreationTool.mouseDrag(me, viewer);
        }
    }

    public void keyUp(KeyEvent evt, EditPartViewer viewer) {
        if (evt.keyCode == CONNECTION_CREATION_MOD_KEY && this.connectionCreationTool != null) {
            this.deactivateConnectionCreation();
        }
        super.keyUp(evt, viewer);
    }

    protected void showTargetFeedback() {
        EditPart editPart = this.getTargetEditPart();
        if (editPart instanceof ConnectionEditPart) {
            ConnectionEditPart connEP = (ConnectionEditPart)editPart;
            this.showConnectionTargetFeedback(connEP);
        }
        super.showTargetFeedback();
    }

    protected void eraseTargetFeedback() {
        EditPart editPart = this.getTargetEditPart();
        if (editPart instanceof ConnectionEditPart) {
            ConnectionEditPart connEP = (ConnectionEditPart)editPart;
            this.eraseConnectionTargetFeedback(connEP);
        }
        super.eraseTargetFeedback();
    }

    private void showConnectionTargetFeedback(ConnectionEditPart targetEditPart) {
        EditPartViewer viewer = this.getCurrentViewer();
        List<ConnectionEditPart> connections = ColLocatedConnectionFinder.getCoLocatedConnections(targetEditPart, viewer, this.getLocation());
        connections.forEach(con -> con.showTargetFeedback((Request)this.getTargetRequest()));
    }

    private void eraseConnectionTargetFeedback(ConnectionEditPart targetEditPart) {
        EditPartViewer viewer = this.getCurrentViewer();
        List<ConnectionEditPart> connections = ColLocatedConnectionFinder.getLeftCoLocatedConnections(targetEditPart, viewer, this.getLocation());
        connections.forEach(con -> con.eraseTargetFeedback((Request)this.getTargetRequest()));
    }

    private void activateConnectionCreation(EditPartViewer viewer) {
        List editParts = viewer.getSelectedEditParts();
        if (editParts.size() == 1 && editParts.get(0) instanceof InterfaceEditPart) {
            this.connectionCreationTool = InlineConnectionCreationTool.createInlineConnCreationTool((EditPart)((EditPart)editParts.get(0)), (EditDomain)this.getDomain(), (EditPartViewer)viewer, (Point)this.getLocation());
        }
    }

    private void deactivateConnectionCreation() {
        this.connectionCreationTool.deactivate();
        this.connectionCreationTool = null;
    }

    private boolean checkConnCreationState(int stateMask) {
        if (this.connectionCreationTool != null) {
            if ((stateMask & CONNECTION_CREATION_MOD_KEY) == 0 || !FBNetworkPanningSelectionTool.isConnectionCreationTarget(this.getTargetEditPart())) {
                this.deactivateConnectionCreation();
            }
        } else if (stateMask == CONNECTION_CREATION_MOD_KEY && FBNetworkPanningSelectionTool.isConnectionCreationTarget(this.getTargetEditPart())) {
            this.activateConnectionCreation(this.getCurrentViewer());
        }
        return this.connectionCreationTool != null;
    }

    private static boolean isConnectionCreationTarget(EditPart targetEditPart) {
        return targetEditPart != null && targetEditPart.getModel() instanceof IInterfaceElement;
    }
}

