/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.wizards.QuickFixWizardDialog;
import org.eclipse.fordiac.ide.gef.annotation.FordiacAnnotationUtil;
import org.eclipse.fordiac.ide.model.errormarker.ErrorMarkerBuilder;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotation;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalMarkerAnnotation;
import org.eclipse.fordiac.ide.model.ui.annotation.ResourceMarkerGraphicalAnnotationModel;
import org.eclipse.fordiac.ide.model.ui.validation.GraphicalValidationAnnotation;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class FordiacQuickFixHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IMarker[] selectedMarkers = selection.getFirstElement() instanceof VarDeclaration || selection.getFirstElement() instanceof FB ? FordiacQuickFixHandler.getSelectedVdMarkersFromNatTable(selection) : FordiacQuickFixHandler.getMarkersFromEditorSelection(selection);
        IMarkerResolution[] resolutions = IDE.getMarkerHelpRegistry().getResolutions(selectedMarkers[0]);
        HashMap<IMarkerResolution, Collection<IMarker>> resolutionsMap = new HashMap<IMarkerResolution, Collection<IMarker>>();
        IMarkerResolution[] iMarkerResolutionArray = resolutions;
        int n = resolutions.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerResolution res = iMarkerResolutionArray[n2];
            if (res instanceof WorkbenchMarkerResolution) {
                WorkbenchMarkerResolution workbenchResolution = (WorkbenchMarkerResolution)res;
                IMarker[] other = workbenchResolution.findOtherMarkers(selectedMarkers);
                LinkedHashSet<IMarker> markersSet = new LinkedHashSet<IMarker>();
                markersSet.addAll(Arrays.asList(selectedMarkers));
                markersSet.addAll(Arrays.asList(other));
                if (markersSet.size() == other.length) {
                    resolutionsMap.put(res, markersSet);
                }
            } else if (selectedMarkers.length == 1) {
                resolutionsMap.put(res, Arrays.asList(selectedMarkers));
            }
            ++n2;
        }
        if (resolutionsMap.isEmpty()) {
            if (selectedMarkers.length == 1) {
                MessageDialog.openInformation((Shell)shell, (String)Messages.QuickFixDialog_Title, (String)MessageFormat.format(Messages.QuickFixDialog_NoResolutionsFound, selectedMarkers[0].getAttribute("message", "")));
            } else {
                MessageDialog.openInformation((Shell)shell, (String)Messages.QuickFixDialog_Title, (String)Messages.QuickFixDialog_NoResolutionsFoundForMultiSelection);
            }
        } else {
            QuickFixWizardDialog.openDialog(shell, selectedMarkers, resolutions, resolutionsMap);
        }
        FordiacQuickFixHandler.deleteTemporaryMarker(selectedMarkers);
        return null;
    }

    private static IMarker[] getSelectedVdMarkersFromNatTable(IStructuredSelection selection) {
        Object object = selection.getFirstElement();
        if (object instanceof EObject) {
            EObject obj = (EObject)object;
            return FordiacQuickFixHandler.retrieveMarkerFromObject(obj);
        }
        return new IMarker[0];
    }

    public static IMarker[] retrieveMarkerFromObject(Object obj) {
        GraphicalAnnotationModel annotationModel;
        IEditorPart editor = EditorUtils.getCurrentActiveEditor();
        if (editor != null && (annotationModel = (GraphicalAnnotationModel)editor.getAdapter(GraphicalAnnotationModel.class)) != null) {
            return (IMarker[])annotationModel.getAnnotations(obj).stream().filter(GraphicalMarkerAnnotation.class::isInstance).map(GraphicalMarkerAnnotation.class::cast).map(GraphicalMarkerAnnotation::getMarker).filter(Objects::nonNull).toArray(IMarker[]::new);
        }
        return new IMarker[0];
    }

    public static IMarker[] getMarkersFromEditorSelection(IStructuredSelection selection) {
        return (IMarker[])selection.stream().filter(EditPart.class::isInstance).map(EditPart.class::cast).map(FordiacQuickFixHandler::getMarker).toArray(IMarker[]::new);
    }

    public static boolean hasMarker(EditPart editPart) {
        GraphicalAnnotationModel annotationModel = FordiacAnnotationUtil.getAnnotationModel((EditPart)editPart);
        if (annotationModel != null) {
            return annotationModel.hasAnnotation(editPart.getModel(), annotation -> annotation instanceof GraphicalMarkerAnnotation || annotation instanceof GraphicalValidationAnnotation);
        }
        return false;
    }

    public static IMarker getMarker(EditPart editPart) {
        GraphicalAnnotationModel graphicalAnnotationModel = FordiacAnnotationUtil.getAnnotationModel((EditPart)editPart);
        if (graphicalAnnotationModel instanceof ResourceMarkerGraphicalAnnotationModel) {
            GraphicalAnnotation graphicalAnnotation;
            ResourceMarkerGraphicalAnnotationModel annotationModel = (ResourceMarkerGraphicalAnnotationModel)graphicalAnnotationModel;
            Set annotation = annotationModel.getAnnotations(editPart.getModel());
            Optional<GraphicalMarkerAnnotation> markerAnnotation = annotation.stream().filter(GraphicalMarkerAnnotation.class::isInstance).map(GraphicalMarkerAnnotation.class::cast).findFirst();
            if (markerAnnotation.isPresent()) {
                return markerAnnotation.get().getMarker();
            }
            if (!annotation.isEmpty() && (graphicalAnnotation = (GraphicalAnnotation)annotation.iterator().next()) instanceof GraphicalValidationAnnotation) {
                GraphicalValidationAnnotation validationAnnotation = (GraphicalValidationAnnotation)graphicalAnnotation;
                FordiacQuickFixHandler.createTemporaryMarker(validationAnnotation, annotationModel.getResource());
                Optional<GraphicalMarkerAnnotation> newAnnotation = annotationModel.getAnnotations(editPart.getModel()).stream().filter(GraphicalMarkerAnnotation.class::isInstance).map(GraphicalMarkerAnnotation.class::cast).findFirst();
                if (newAnnotation.isPresent()) {
                    return newAnnotation.get().getMarker();
                }
            }
        }
        return null;
    }

    private static void createTemporaryMarker(final GraphicalValidationAnnotation validationAnnotation, final IResource resource) {
        try {
            new WorkspaceModifyOperation((ISchedulingRule)resource){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    ErrorMarkerBuilder.createErrorMarkerBuilder((String)validationAnnotation.getText()).addAdditionalAttributes(validationAnnotation.getAttributes()).setType("org.eclipse.fordiac.ide.model.temporary").createMarker(resource);
                }
            }.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private static void deleteTemporaryMarker(IMarker[] selectedMarkers) {
        final List<IMarker> temporaryMarkers = Arrays.stream(selectedMarkers).filter(marker -> {
            try {
                return marker.getType().equals("org.eclipse.fordiac.ide.model.temporary");
            }
            catch (CoreException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
                return false;
            }
        }).toList();
        if (temporaryMarkers.isEmpty()) {
            return;
        }
        try {
            new WorkspaceModifyOperation((ISchedulingRule)temporaryMarkers.getFirst().getResource()){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    temporaryMarkers.forEach(marker -> {
                        try {
                            if (marker.getType().equals("org.eclipse.fordiac.ide.model.temporary")) {
                                marker.delete();
                            }
                        }
                        catch (CoreException e) {
                            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
                        }
                    });
                }
            }.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

