/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.properties;

import org.eclipse.fordiac.ide.application.properties.InstancePropertySection;
import org.eclipse.fordiac.ide.application.properties.SubappPropertySectionFilter;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.commands.change.ChangeSubAppBoundsCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeSubAppSizeLockCommand;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class SubAppPropertySection
extends InstancePropertySection {
    private Text heightText;
    private Text widthText;
    private Button lockCheckbox;
    private static final int TEXT_INPUT_MAX_LENGTH = 5;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createFBSizeGroup(this.rightComposite);
    }

    @Override
    protected void createSubsectionLayout(Composite parent) {
        this.createSingleRowLayout(parent);
        this.createDoubleColumnLayout(this.upperComposite);
        this.createFBInfoGroup(this.leftComposite);
        this.createTableSection(this.lowerComposite);
    }

    private void createLockSizeCheckbox(Composite parent) {
        this.lockCheckbox = this.getWidgetFactory().createButton(parent, null, 32);
        this.lockCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.getType() != null) {
                this.removeContentAdapter();
                this.executeCommand((Command)new ChangeSubAppSizeLockCommand(this.getType(), this.lockCheckbox.getSelection()));
                this.addContentAdapter();
            }
        }));
    }

    private void createFBSizeGroup(Composite parent) {
        Composite fbSizeContainer = this.getWidgetFactory().createComposite(parent);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(fbSizeContainer);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)fbSizeContainer);
        this.getWidgetFactory().createCLabel(fbSizeContainer, FordiacMessages.Height + ":");
        this.heightText = this.createGroupText(fbSizeContainer, true);
        this.heightText.setTextLimit(5);
        this.heightText.addModifyListener(e -> {
            if (this.getType() != null) {
                double newHeight;
                try {
                    newHeight = CoordinateConverter.INSTANCE.screenToIEC61499(Integer.parseInt(this.heightText.getText()));
                }
                catch (NumberFormatException exception) {
                    return;
                }
                this.removeContentAdapter();
                this.executeCommand((Command)new ChangeSubAppBoundsCommand(this.getType(), this.getType().getPosition(), this.getType().getWidth(), newHeight));
                this.addContentAdapter();
            }
        });
        this.heightText.addVerifyListener(e -> {
            boolean bl = e.doit = e.text.chars().allMatch(Character::isDigit);
        });
        this.getWidgetFactory().createCLabel(fbSizeContainer, FordiacMessages.Width + ":");
        this.widthText = this.createGroupText(fbSizeContainer, true);
        this.widthText.setTextLimit(5);
        this.widthText.addModifyListener(e -> {
            if (this.getType() != null) {
                double newWidth;
                try {
                    newWidth = CoordinateConverter.INSTANCE.screenToIEC61499(Integer.parseInt(this.widthText.getText()));
                }
                catch (NumberFormatException exception) {
                    return;
                }
                this.removeContentAdapter();
                this.executeCommand((Command)new ChangeSubAppBoundsCommand(this.getType(), this.getType().getPosition(), newWidth, this.getType().getHeight()));
                this.addContentAdapter();
            }
        });
        this.widthText.addVerifyListener(e -> {
            boolean bl = e.doit = e.text.chars().allMatch(Character::isDigit);
        });
        this.getWidgetFactory().createCLabel(fbSizeContainer, FordiacMessages.Subapp_Size_DisableAutoResize + ":");
        this.createLockSizeCheckbox(fbSizeContainer);
    }

    @Override
    protected void performRefresh() {
        super.performRefresh();
        this.heightText.setText(Integer.toString(CoordinateConverter.INSTANCE.iec61499ToScreen(this.getType().getHeight())));
        this.widthText.setText(Integer.toString(CoordinateConverter.INSTANCE.iec61499ToScreen(this.getType().getWidth())));
        this.lockCheckbox.setSelection(this.getType().isLocked());
    }

    protected SubApp getType() {
        Object object = this.type;
        if (object instanceof SubApp) {
            SubApp subApp = (SubApp)object;
            return subApp;
        }
        return null;
    }

    @Override
    protected Object getInputType(Object input) {
        return SubappPropertySectionFilter.getFBNetworkElementFromSelectedElement(input);
    }
}

