/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.quickfix;

import org.eclipse.fordiac.ide.Messages;
import org.eclipse.fordiac.ide.contractSpec.ContractSpecFactory;
import org.eclipse.fordiac.ide.contractSpec.Interval;
import org.eclipse.fordiac.ide.contractSpec.TimeExpr;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

public class ContractSpecQuickfixProvider
extends DefaultQuickfixProvider {
    @Fix(value="emptyInterval")
    public static void swapIntervalValues(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, Messages.EmptyIntervalQuickfixLabel, Messages.EmptyIntervalQuickfixDescription, "", (element, context) -> {
            if (element instanceof Interval) {
                Interval inter = (Interval)element;
                double tmp = inter.getLbValue();
                inter.setLbValue(inter.getUbValue());
                inter.setUbValue(tmp);
            }
        });
    }

    @Fix(value="degenerateInterval")
    public static void simplifyInterval(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, Messages.DegenerateIntervalQuickfixLabel, Messages.DegenerateIntervalQuickfixDescription, "", (element, context) -> {
            if (element instanceof Interval) {
                Interval inter = (Interval)element;
                TimeExpr te = ContractSpecFactory.eINSTANCE.createTimeExpr();
                te.setValue(inter.getLbValue());
                te.setUnit(inter.getUnit());
                inter.setTime(te);
                inter.setLBound(null);
                inter.setLbValue(0.0);
                inter.setUbValue(0.0);
                inter.setUBound(null);
                inter.setUnit(null);
            }
        });
    }
}

