/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentLaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentLaunchValue;
import org.eclipse.fordiac.ide.deployment.debug.ui.Messages;
import org.eclipse.fordiac.ide.gef.nat.InitialValueGenericEditorConfiguration;
import org.eclipse.fordiac.ide.gef.nat.InitialValueStructuredElementAccessor;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationColumnAccessor;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationDataLayer;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationTableColumn;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.TypeDeclarationParser;
import org.eclipse.fordiac.ide.model.edit.helper.CommentHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.provider.LibraryElementItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.widget.nattable.AbstractColumnAccessor;
import org.eclipse.fordiac.ide.ui.widget.nattable.NatTableColumnEditableRule;
import org.eclipse.fordiac.ide.ui.widget.nattable.NatTableColumnProvider;
import org.eclipse.fordiac.ide.ui.widget.nattable.NatTableWidgetFactory;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.selection.RowPostSelectionProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class DeploymentLaunchInitialValuesTab
extends AbstractLaunchConfigurationTab {
    public static final String ID = "org.eclipse.fordiac.ide.deployment.debug.ui.initialValuesTab";
    private final List<DeploymentLaunchValue> values = new ArrayList<DeploymentLaunchValue>();
    private AutomationSystem system;
    private NatTable valuesTable;
    private RowPostSelectionProvider<DeploymentLaunchValue> valuesSelectionProvider;
    private Button addButton;
    private Button removeButton;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(comp);
        this.setControl((Control)comp);
        Control valuesControl = this.createValuesTable(comp);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(valuesControl);
        Control buttonsControl = this.createTableButtons(comp);
        GridDataFactory.fillDefaults().grab(false, true).applyTo(buttonsControl);
    }

    protected Control createValuesTable(Composite parent) {
        ListDataProvider valuesDataProvider = new ListDataProvider(Collections.unmodifiableList(this.values), (IColumnAccessor)new DeploymentLaunchValueColumnAccessor(VarDeclarationTableColumn.DEFAULT_COLUMNS));
        VarDeclarationDataLayer dataLayer = new VarDeclarationDataLayer((IDataProvider)valuesDataProvider, VarDeclarationTableColumn.DEFAULT_COLUMNS);
        dataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new DeploymentLaunchValueConfigLabelAccumulator((IRowDataProvider<DeploymentLaunchValue>)valuesDataProvider, VarDeclarationTableColumn.DEFAULT_COLUMNS));
        NatTableColumnProvider columnProvider = new NatTableColumnProvider(VarDeclarationTableColumn.DEFAULT_COLUMNS);
        this.valuesTable = NatTableWidgetFactory.createNatTable((Composite)parent, (DataLayer)dataLayer, (IDataProvider)columnProvider, (IEditableRule)new NatTableColumnEditableRule(IEditableRule.ALWAYS_EDITABLE, VarDeclarationTableColumn.DEFAULT_COLUMNS, Set.of(VarDeclarationTableColumn.INITIAL_VALUE)));
        this.valuesTable.addConfiguration((IConfiguration)new InitialValueGenericEditorConfiguration((IRowDataProvider)valuesDataProvider, (InitialValueStructuredElementAccessor)new DeploymentLaunchValueElementAccessor()));
        this.valuesTable.configure();
        this.valuesSelectionProvider = new RowPostSelectionProvider(this.valuesTable, NatTableWidgetFactory.getSelectionLayer((NatTable)this.valuesTable), (IRowDataProvider)valuesDataProvider, false);
        this.valuesSelectionProvider.addSelectionChangedListener(this::handleTableSelectionChanged);
        return this.valuesTable;
    }

    protected void handleTableSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = event.getStructuredSelection();
        this.removeButton.setEnabled(selection.stream().anyMatch(this.values::contains));
    }

    private Control createTableButtons(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.addButton = new Button(comp, 8);
        this.addButton.setText(Messages.DeploymentLaunchInitialValuesTab_AddButton);
        this.addButton.setEnabled(false);
        this.addButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleAddButtonSelected()));
        this.removeButton = new Button(comp, 8);
        this.removeButton.setText(Messages.DeploymentLaunchInitialValuesTab_RemoveButton);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleRemoveButtonSelected()));
        GridLayoutFactory.swtDefaults().generateLayout(comp);
        return comp;
    }

    private void handleAddButtonSelected() {
        VarDeclarationTreeSelectionDialog dialog = new VarDeclarationTreeSelectionDialog(this.getShell());
        dialog.setTitle(Messages.DeploymentLaunchInitialValuesTab_AddDialogTitle);
        dialog.setMessage(Messages.DeploymentLaunchInitialValuesTab_AddDialogMessage);
        dialog.setEmptyListMessage(Messages.DeploymentLaunchInitialValuesTab_AddDialogEmptyListMessage);
        dialog.setValidator(selection -> Stream.of(selection).noneMatch(VarDeclaration.class::isInstance) ? Status.error((String)Messages.DeploymentLaunchInitialValuesTab_AddDialogEmptySelectionMessage) : Status.OK_STATUS);
        dialog.setStatusLineAboveButtons(true);
        dialog.setAllowMultiple(true);
        dialog.setInput(this.system);
        if (dialog.open() == 0) {
            Stream.of(dialog.getResult()).filter(VarDeclaration.class::isInstance).map(VarDeclaration.class::cast).map(variable -> new DeploymentLaunchValue(variable.getQualifiedName(), Optional.of(variable), "")).forEachOrdered(value -> {
                int index = Collections.binarySearch(this.values, value, Comparator.comparing(DeploymentLaunchValue::getName));
                if (index < 0) {
                    this.values.add(-index - 1, (DeploymentLaunchValue)value);
                }
            });
            this.valuesTable.refresh();
            this.updateLaunchConfigurationDialog();
        }
    }

    private void handleRemoveButtonSelected() {
        this.values.removeAll(((IStructuredSelection)this.valuesSelectionProvider.getSelection()).toList());
        this.valuesTable.refresh();
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        DeploymentLaunchConfigurationAttributes.setWatches((ILaunchConfigurationWorkingCopy)configuration, null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.system = DeploymentLaunchConfigurationAttributes.getSystem((ILaunchConfiguration)configuration);
            this.values.clear();
            this.values.addAll(DeploymentLaunchConfigurationAttributes.getValues((ILaunchConfiguration)configuration));
            this.valuesTable.refresh();
            this.addButton.setEnabled(this.system != null);
        }
        catch (CoreException e) {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)((Object)e));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        DeploymentLaunchConfigurationAttributes.setValues((ILaunchConfigurationWorkingCopy)configuration, this.values);
    }

    public String getName() {
        return Messages.DeploymentLaunchInitialValuesTab_Name;
    }

    public Image getImage() {
        return DebugUITools.getImage((String)"IMG_VIEW_VARIABLES");
    }

    public String getId() {
        return ID;
    }

    private class DeploymentLaunchValueColumnAccessor
    extends AbstractColumnAccessor<DeploymentLaunchValue, VarDeclarationTableColumn> {
        public DeploymentLaunchValueColumnAccessor(List<VarDeclarationTableColumn> columns) {
            super(columns);
        }

        public Object getDataValue(DeploymentLaunchValue rowObject, VarDeclarationTableColumn column) {
            return switch (column) {
                case VarDeclarationTableColumn.NAME -> rowObject.getName();
                case VarDeclarationTableColumn.TYPE -> rowObject.getRefElement().map(VarDeclaration::getFullTypeName).orElse("");
                case VarDeclarationTableColumn.COMMENT -> rowObject.getRefElement().map(CommentHelper::getInstanceComment).orElse("");
                case VarDeclarationTableColumn.INITIAL_VALUE -> {
                    if (rowObject.getValue().isEmpty()) {
                        yield rowObject.getRefElement().map(VarDeclarationColumnAccessor::getInitialValue).orElse("");
                    }
                    yield rowObject.getValue();
                }
                default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(column));
            };
        }

        public void setDataValue(DeploymentLaunchValue rowObject, VarDeclarationTableColumn column, Object newValue) {
            switch (column) {
                case INITIAL_VALUE: {
                    rowObject.setValue(Objects.toString(newValue, ""));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + String.valueOf(column));
                }
            }
            DeploymentLaunchInitialValuesTab.this.valuesTable.refresh(false);
            DeploymentLaunchInitialValuesTab.this.updateLaunchConfigurationDialog();
        }
    }

    private static class DeploymentLaunchValueConfigLabelAccumulator
    implements IConfigLabelAccumulator {
        private final IRowDataProvider<DeploymentLaunchValue> dataProvider;
        private final List<VarDeclarationTableColumn> columns;

        public DeploymentLaunchValueConfigLabelAccumulator(IRowDataProvider<DeploymentLaunchValue> dataProvider, List<VarDeclarationTableColumn> columns) {
            this.columns = columns;
            this.dataProvider = dataProvider;
        }

        public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
            DeploymentLaunchValue rowItem = (DeploymentLaunchValue)this.dataProvider.getRowObject(rowPosition);
            switch (this.columns.get(columnPosition)) {
                case NAME: {
                    configLabels.addLabelOnTop("LEFT_ALIGNMENT");
                    break;
                }
                case TYPE: {
                    configLabels.addLabel("TYPE_DECLARATION_CELL");
                    break;
                }
                case COMMENT: {
                    configLabels.addLabelOnTop("NONE_NULL");
                    configLabels.addLabelOnTop("LEFT_ALIGNMENT");
                    configLabels.addLabelOnTop("DEFAULT_CELL");
                    break;
                }
                case INITIAL_VALUE: {
                    if (rowItem.getRefElement().filter(refElement -> refElement.getType() instanceof StructuredType || refElement.isArray()).isPresent()) {
                        configLabels.addLabel("INITIAL_VALUE_STRUCTURED_CELL");
                    } else {
                        configLabels.addLabel("INITIAL_VALUE_CELL");
                    }
                    if (!rowItem.getValue().isEmpty()) break;
                    configLabels.addLabelOnTop("DEFAULT_CELL");
                    break;
                }
            }
        }
    }

    private class DeploymentLaunchValueElementAccessor
    implements InitialValueStructuredElementAccessor<DeploymentLaunchValue> {
        private DeploymentLaunchValueElementAccessor() {
        }

        public LibraryElement getContext(DeploymentLaunchValue element) {
            return element.getRefElement().map(EcoreUtil::getRootContainer).filter(LibraryElement.class::isInstance).map(LibraryElement.class::cast).orElse((LibraryElement)DeploymentLaunchInitialValuesTab.this.system);
        }

        public LibraryElement getType(DeploymentLaunchValue element) {
            return element.getRefElement().map(varDeclaration -> varDeclaration.isArray() ? TypeDeclarationParser.parseTypeDeclaration((DataType)varDeclaration.getType(), (String)varDeclaration.getArraySizeString()) : varDeclaration.getType()).orElse(null);
        }

        public ITypedElement getReferenceElement(DeploymentLaunchValue element) {
            return element.getRefElement().orElse(null);
        }
    }

    public static class VarDeclarationPatternFilter
    extends PatternFilter {
        protected boolean isLeafMatch(Viewer viewer, Object element) {
            if (element instanceof INamedElement) {
                INamedElement namedElement = (INamedElement)element;
                return this.wordMatches(namedElement.getQualifiedName());
            }
            return super.isLeafMatch(viewer, element);
        }
    }

    private static class VarDeclarationTreeProvider
    extends AdapterFactoryContentProvider {
        public VarDeclarationTreeProvider() {
            super((AdapterFactory)new LibraryElementItemProviderAdapterFactory());
        }

        public Object[] getElements(Object object) {
            Object object2 = object;
            Objects.requireNonNull(object2);
            Object object3 = object2;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AutomationSystem.class}, (Object)object3, 0)) {
                case 0 -> {
                    AutomationSystem system = (AutomationSystem)object3;
                    yield system.getApplication().toArray();
                }
                default -> super.getElements(object);
            };
        }

        public Object[] getChildren(Object parentElement) {
            Object[] objectArray;
            Object object = parentElement;
            Objects.requireNonNull(object);
            Object object2 = object;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FBNetwork.class, SubApp.class, BlockFBNetworkElement.class, FBNetworkElement.class, InterfaceList.class}, (Object)object2, 0)) {
                case 0: {
                    FBNetwork network = (FBNetwork)object2;
                    objectArray = network.getBlockFBNetworkElements().toArray();
                    break;
                }
                case 1: {
                    SubApp subApp = (SubApp)object2;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = subApp.getInterface();
                    objectArray = objectArray2;
                    objectArray2[1] = subApp.loadSubAppNetwork();
                    break;
                }
                case 2: {
                    BlockFBNetworkElement fbne = (BlockFBNetworkElement)object2;
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = fbne.getInterface();
                    break;
                }
                case 3: {
                    FBNetworkElement fbne = (FBNetworkElement)object2;
                    objectArray = new Object[]{};
                    break;
                }
                case 4: {
                    InterfaceList interfaceList = (InterfaceList)object2;
                    objectArray = Stream.of(interfaceList.getInputVars(), interfaceList.getInOutVars()).flatMap(Collection::stream).toArray();
                    break;
                }
                default: {
                    objectArray = super.getChildren(parentElement);
                }
            }
            return objectArray;
        }

        public boolean hasChildren(Object element) {
            Object object = element;
            Objects.requireNonNull(object);
            Object object2 = object;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AutomationSystem.class, FBNetwork.class, BlockFBNetworkElement.class, FBNetworkElement.class, InterfaceList.class}, (Object)object2, 0)) {
                case 0 -> {
                    AutomationSystem system = (AutomationSystem)object2;
                    if (system.getApplication().isEmpty()) {
                        yield false;
                    }
                    yield true;
                }
                case 1 -> {
                    FBNetwork network = (FBNetwork)object2;
                    yield network.getBlockFBNetworkElements().findAny().isPresent();
                }
                case 2 -> {
                    BlockFBNetworkElement fbne = (BlockFBNetworkElement)object2;
                    yield true;
                }
                case 3 -> {
                    FBNetworkElement fbne = (FBNetworkElement)object2;
                    yield false;
                }
                case 4 -> {
                    InterfaceList interfaceList = (InterfaceList)object2;
                    if (interfaceList.getInputVars().isEmpty() && interfaceList.getInOutVars().isEmpty()) {
                        yield false;
                    }
                    yield true;
                }
                default -> super.hasChildren(element);
            };
        }
    }

    private static class VarDeclarationTreeSelectionDialog
    extends ElementTreeSelectionDialog {
        public VarDeclarationTreeSelectionDialog(Shell parent) {
            super(parent, (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)new LibraryElementItemProviderAdapterFactory()), (ITreeContentProvider)new VarDeclarationTreeProvider());
        }

        protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
            FilteredTree tree = new FilteredTree(parent, style, (PatternFilter)new VarDeclarationPatternFilter(), true, true);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tree);
            VarDeclarationTreeSelectionDialog.applyDialogFont((Control)tree);
            return tree.getViewer();
        }
    }
}

