/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui.handler;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.deployment.data.ConnectionDeploymentData;
import org.eclipse.fordiac.ide.deployment.debug.ui.Messages;
import org.eclipse.fordiac.ide.deployment.debug.ui.handler.AbstractDeploymentCommand;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.util.DeploymentHelper;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.gef.ConnectionEditPart;

public class OnlineCreateConnectionHandler
extends AbstractDeploymentCommand {
    private Connection conn = null;
    private Resource res = null;

    @Override
    protected boolean prepareParametersToExecute(Object element) {
        if (element instanceof ConnectionEditPart) {
            this.conn = (Connection)((ConnectionEditPart)element).getModel();
            Connection resCon = OnlineCreateConnectionHandler.getResourceConnection(this.conn);
            if (resCon != null) {
                this.res = (Resource)resCon.getFBNetwork().eContainer();
                if (this.res != null) {
                    this.setDevice(this.res.getDevice());
                    return this.getDevice() != null;
                }
            }
        }
        return false;
    }

    @Override
    protected void executeCommand(IDeviceManagementInteractor executor) throws DeploymentException {
        executor.createConnection(this.res, new ConnectionDeploymentData(OnlineCreateConnectionHandler.getPrefixFor((FBNetworkElement)this.conn.getSourceElement()), DeploymentHelper.getSourceSuffix((Connection)this.conn), this.conn.getSource(), OnlineCreateConnectionHandler.getPrefixFor((FBNetworkElement)this.conn.getDestinationElement()), this.conn.getDestination()));
    }

    private static Connection getResourceConnection(Connection conn) {
        if (conn.getFBNetwork().eContainer() instanceof Resource) {
            return conn;
        }
        BlockFBNetworkElement oppositeSource = conn.getSourceElement().getOpposite();
        if (oppositeSource != null) {
            EList conns = oppositeSource.getInterface().getInterfaceElement(conn.getSource()).getOutputConnections();
            for (Connection connection : conns) {
                if (!connection.getDestination().getName().equals(conn.getDestination().getName())) continue;
                return connection;
            }
        }
        return null;
    }

    @Override
    protected String getErrorMessageHeader() {
        return Messages.OnlineCreateConnectionHandler_CreateConnectionError;
    }

    @Override
    protected String getCurrentElementName() {
        return this.conn.getSource().getQualifiedName() + " -> " + this.conn.getDestination().getQualifiedName();
    }
}

