/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.interactors;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.deployment.interactors.TypeNameCreator;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.Demultiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.impl.ConfigurableFBManagement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.util.LibraryElementHashException;

public class ForteTypeNameCreator
implements TypeNameCreator {
    public static final TypeNameCreator TYPE_NAME_CREATOR = new ForteTypeNameCreator();

    @Override
    public String getTypeName(TypeEntry entry) {
        return ForteTypeNameCreator.convertFullTypeNameToFORTE(entry.getFullTypeName());
    }

    @Override
    public String getTypeName(FBNetworkElement fb) {
        if (fb != null && fb.getTypeEntry() != null) {
            if (fb instanceof ConfigurableFB) {
                ConfigurableFB confFB = (ConfigurableFB)fb;
                return ForteTypeNameCreator.getConfigureFBType(confFB);
            }
            return ForteTypeNameCreator.getForteTypeName(fb);
        }
        return "";
    }

    @Override
    public String getTypeNameWithHash(TypeEntry entry) throws LibraryElementHashException {
        String hash = entry.getTypeHash();
        if (hash.isEmpty()) {
            return this.getTypeName(entry);
        }
        return this.getTypeName(entry) + "#" + hash;
    }

    private static String getForteTypeName(FBNetworkElement fb) {
        return ForteTypeNameCreator.convertFullTypeNameToFORTE(fb.getFullTypeName());
    }

    private static String getConfigureFBType(ConfigurableFB confFB) {
        DataType dt = confFB.getDataType();
        Object typeName = ForteTypeNameCreator.getForteTypeName((FBNetworkElement)confFB);
        if (dt != null) {
            Demultiplexer demux;
            typeName = (String)typeName + "_1" + ForteTypeNameCreator.convertFullTypeNameToFORTE(PackageNameHelper.getFullTypeName((LibraryElement)dt));
            if (confFB instanceof Demultiplexer && ForteTypeNameCreator.isConfigured(demux = (Demultiplexer)confFB)) {
                typeName = (String)typeName + "____" + ConfigurableFBManagement.buildVisibleChildrenString((EList)demux.getMemberVars());
            }
        }
        return typeName;
    }

    private static boolean isConfigured(Demultiplexer demux) {
        EObject eObj = demux.eContainer().eContainer();
        if (eObj instanceof Resource) {
            return ((Demultiplexer)demux.getOpposite()).isIsConfigured();
        }
        return demux.isIsConfigured();
    }

    private static String convertFullTypeNameToFORTE(String fullTypeName) {
        return fullTypeName;
    }
}

