/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng.composite;

import com.google.common.collect.Iterables;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.export.forte_ng.ForteFBTemplate;
import org.eclipse.fordiac.ide.export.forte_ng.util.ForteNgExportUtil;
import org.eclipse.fordiac.ide.export.language.ILanguageSupport;
import org.eclipse.fordiac.ide.export.language.ILanguageSupportFactory;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class CompositeFBImplTemplate
extends ForteFBTemplate<CompositeFBType> {
    private final List<FB> fbs;
    private final Map<VarDeclaration, ILanguageSupport> fbNetworkInitialVariableLanguageSupport;

    public CompositeFBImplTemplate(CompositeFBType type, String name, Path prefix, Map<?, ?> options) {
        super(type, name, prefix, "CCompositeFB", options);
        this.fbs = IterableExtensions.toList((Iterable)IterableExtensions.reject((Iterable)Iterables.filter((Iterable)type.getFBNetwork().getNetworkElements(), FB.class), AdapterFB.class));
        Functions.Function1 _function = it -> it.getInterface().getInputVars();
        Functions.Function1 _function_1 = it -> {
            boolean _isNullOrEmpty;
            Value _value = it.getValue();
            String _value_1 = null;
            if (_value != null) {
                _value_1 = _value.getValue();
            }
            return !(_isNullOrEmpty = StringExtensions.isNullOrEmpty(_value_1));
        };
        Functions.Function1 _function_2 = it -> ILanguageSupportFactory.createLanguageSupport((String)"forte_ng", (EObject)it, (Map)options);
        this.fbNetworkInitialVariableLanguageSupport = IterableExtensions.toInvertedMap((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.flatMap(this.fbs, (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
    }

    public CharSequence generate() {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateHeader = this.generateHeader();
        _builder.append((Object)_generateHeader);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateImplIncludes = this.generateImplIncludes();
        _builder.append((Object)_generateImplIncludes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("namespace ");
        String _generateTypeNamespace = ForteNgExportUtil.generateTypeNamespace(this.getType());
        _builder.append(_generateTypeNamespace);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("namespace {");
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateTypeHash = this.generateTypeHash();
        _builder.append((Object)_generateTypeHash, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateFBInterfaceDefinition = this.generateFBInterfaceDefinition();
        _builder.append((Object)_generateFBInterfaceDefinition, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateFBInterfaceSpecDefinition = this.generateFBInterfaceSpecDefinition();
        _builder.append((Object)_generateFBInterfaceSpecDefinition, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateFBNetwork = this.generateFBNetwork();
        _builder.append((Object)_generateFBNetwork, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        CharSequence _generateFBDefinition = this.generateFBDefinition();
        _builder.append((Object)_generateFBDefinition, "  ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("  ");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName, "  ");
        _builder.append("::");
        CharSequence _fBClassName_1 = this.getFBClassName();
        _builder.append((Object)_fBClassName_1, "  ");
        _builder.append("(const StringId paInstanceNameId, CFBContainer &paContainer) :");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        String _baseClass = this.baseClass();
        _builder.append(_baseClass, "      ");
        _builder.append("(paContainer, cFBInterfaceSpec, paInstanceNameId, cFBNData)");
        CharSequence _generateInternalFBInitializer = this.generateInternalFBInitializer(this.fbs);
        _builder.append((Object)_generateInternalFBInitializer, "      ");
        Functions.Function1 _function = it -> it.getInputConnections().isEmpty();
        CharSequence _generateVariableInitializer = this.generateVariableInitializer(IterableExtensions.filter((Iterable)((CompositeFBType)this.getType()).getInterfaceList().getOutputVars(), (Functions.Function1)_function));
        _builder.append((Object)_generateVariableInitializer, "      ");
        EList _sockets = ((CompositeFBType)this.getType()).getInterfaceList().getSockets();
        EList _plugs = ((CompositeFBType)this.getType()).getInterfaceList().getPlugs();
        CharSequence _generateAdapterInitializer = this.generateAdapterInitializer(IterableExtensions.toList((Iterable)Iterables.concat((Iterable)_sockets, (Iterable)_plugs)));
        _builder.append((Object)_generateAdapterInitializer, "      ");
        CharSequence _generateConnectionInitializer = this.generateConnectionInitializer();
        _builder.append((Object)_generateConnectionInitializer, "      ");
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        EList _inputVars = ((CompositeFBType)this.getType()).getInterfaceList().getInputVars();
        EList _inOutVars = ((CompositeFBType)this.getType()).getInterfaceList().getInOutVars();
        Iterable _plus = Iterables.concat((Iterable)_inputVars, (Iterable)_inOutVars);
        EList _outputVars = ((CompositeFBType)this.getType()).getInterfaceList().getOutputVars();
        CharSequence _generateSetInitialValuesDefinition = this.generateSetInitialValuesDefinition(Iterables.concat((Iterable)_plus, (Iterable)_outputVars));
        _builder.append((Object)_generateSetInitialValuesDefinition, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateSetFBNetworkInitialValuesDefinition = this.generateSetFBNetworkInitialValuesDefinition();
        _builder.append((Object)_generateSetFBNetworkInitialValuesDefinition, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateInterfaceDefinitions = this.generateInterfaceDefinitions();
        _builder.append((Object)_generateInterfaceDefinitions, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    @Override
    protected CharSequence generateInterfaceDefinitions() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateInterfaceDefinitions = super.generateInterfaceDefinitions();
        _builder.append((Object)_generateInterfaceDefinitions);
        _builder.newLineIfNotEmpty();
        CharSequence _generateConnectionAccessorsDefinition = this.generateConnectionAccessorsDefinition((List<INamedElement>)((CompositeFBType)this.getType()).getInterfaceList().getInputVars(), "getIf2InConUnchecked", "CDataConnection *", true);
        _builder.append((Object)_generateConnectionAccessorsDefinition);
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = ((CompositeFBType)this.getType()).getInterfaceList().getInOutVars().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            CharSequence _generateConnectionAccessorsDefinition_1 = this.generateConnectionAccessorsDefinition((List<INamedElement>)((CompositeFBType)this.getType()).getInterfaceList().getOutMappedInOutVars(), "getDIOOutConInternalUnchecked", "CInOutDataConnection *", true);
            _builder.append((Object)_generateConnectionAccessorsDefinition_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence generateFBNetwork() {
        boolean _isEmpty_2;
        boolean _not_2;
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = ((CompositeFBType)this.getType()).getFBNetwork().getEventConnections().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            CharSequence _generateConnectionEndpointDeclarations = this.generateConnectionEndpointDeclarations((Iterable<? extends Connection>)((CompositeFBType)this.getType()).getFBNetwork().getEventConnections());
            _builder.append((Object)_generateConnectionEndpointDeclarations);
            _builder.newLineIfNotEmpty();
            CharSequence _generateConnections = this.generateConnections((EList<? extends Connection>)((CompositeFBType)this.getType()).getFBNetwork().getEventConnections(), "cEventConnections");
            _builder.append((Object)_generateConnections);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        boolean bl2 = _not_1 = !(_isEmpty_1 = ((CompositeFBType)this.getType()).getFBNetwork().getDataConnections().isEmpty());
        if (_not_1) {
            CharSequence _generateConnectionEndpointDeclarations_1 = this.generateConnectionEndpointDeclarations((Iterable<? extends Connection>)((CompositeFBType)this.getType()).getFBNetwork().getDataConnections());
            _builder.append((Object)_generateConnectionEndpointDeclarations_1);
            _builder.newLineIfNotEmpty();
            CharSequence _generateConnections_1 = this.generateConnections((EList<? extends Connection>)((CompositeFBType)this.getType()).getFBNetwork().getDataConnections(), "cDataConnections");
            _builder.append((Object)_generateConnections_1);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        boolean bl3 = _not_2 = !(_isEmpty_2 = ((CompositeFBType)this.getType()).getFBNetwork().getAdapterConnections().isEmpty());
        if (_not_2) {
            CharSequence _generateConnectionEndpointDeclarations_2 = this.generateConnectionEndpointDeclarations((Iterable<? extends Connection>)((CompositeFBType)this.getType()).getFBNetwork().getAdapterConnections());
            _builder.append((Object)_generateConnectionEndpointDeclarations_2);
            _builder.newLineIfNotEmpty();
            CharSequence _generateConnections_2 = this.generateConnections((EList<? extends Connection>)((CompositeFBType)this.getType()).getFBNetwork().getAdapterConnections(), "cAdapterConnections");
            _builder.append((Object)_generateConnections_2);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        CharSequence _generateFBNDataStruct = this.generateFBNDataStruct();
        _builder.append((Object)_generateFBNDataStruct);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence generateFBNDataStruct() {
        boolean _not_2;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("const SCFB_FBNData cFBNData = {");
        _builder.newLine();
        _builder.append("  ");
        _builder.append(".mEventConnections = ");
        boolean _isEmpty = ((CompositeFBType)this.getType()).getFBNetwork().getEventConnections().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("cEventConnections");
        } else {
            _builder.append("{}");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append(".mDataConnections = ");
        boolean _isEmpty_1 = ((CompositeFBType)this.getType()).getFBNetwork().getDataConnections().isEmpty();
        boolean bl2 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            _builder.append("cDataConnections");
        } else {
            _builder.append("{}");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append(".mAdapterConnections = ");
        boolean _isEmpty_2 = ((CompositeFBType)this.getType()).getFBNetwork().getAdapterConnections().isEmpty();
        boolean bl3 = _not_2 = !_isEmpty_2;
        if (_not_2) {
            _builder.append("cAdapterConnections");
        } else {
            _builder.append("{}");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateConnections(EList<? extends Connection> connections, String listName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("const auto ");
        _builder.append(listName);
        _builder.append(" = std::to_array<SCFB_FBConnectionData>({");
        _builder.newLineIfNotEmpty();
        for (Connection conn : connections) {
            _builder.append("  ");
            CharSequence _generateConnectionEntry = this.generateConnectionEntry(conn);
            _builder.append((Object)_generateConnectionEntry, "  ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("});");
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateConnectionEntry(Connection con) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("{");
        CharSequence _generateConnectionElementId = this.generateConnectionElementId((FBNetworkElement)con.getSourceElement());
        _builder.append((Object)_generateConnectionElementId);
        _builder.append(", ");
        CharSequence _generateConnectionEndpointReference = this.generateConnectionEndpointReference(this.getConnectionSourcePath(con));
        _builder.append((Object)_generateConnectionEndpointReference);
        _builder.append(", ");
        CharSequence _generateConnectionElementId_1 = this.generateConnectionElementId((FBNetworkElement)con.getDestinationElement());
        _builder.append((Object)_generateConnectionElementId_1);
        _builder.append(", ");
        CharSequence _generateConnectionEndpointReference_1 = this.generateConnectionEndpointReference(this.getConnectionDestinationPath(con));
        _builder.append((Object)_generateConnectionEndpointReference_1);
        _builder.append("},");
        return _builder;
    }

    private CharSequence generateConnectionElementId(FBNetworkElement elem) {
        CharSequence _xifexpression = null;
        boolean _contains = ((CompositeFBType)this.getType()).getFBNetwork().getNetworkElements().contains((Object)elem);
        _xifexpression = _contains ? ForteNgExportUtil.getFORTEStringId(elem.getName()) : "{}";
        return _xifexpression;
    }

    private CharSequence generateConnectionEndpointDeclarations(Iterable<? extends Connection> connections) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> this.getConnectionEndpointPaths((Connection)it);
        Functions.Function1 _function_1 = it -> {
            int _size = IterableExtensions.size((Iterable)it);
            return _size > 1;
        };
        Functions.Function1 _function_2 = it -> this.generateConnectionEndpointName((Iterable<String>)it).toString();
        List _sortBy = IterableExtensions.sortBy((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.flatMap(connections, (Functions.Function1)_function), (Functions.Function1)_function_1)), (Functions.Function1)_function_2);
        for (Iterable endpoint : _sortBy) {
            CharSequence _generateConnectionEndpointDeclaration = this.generateConnectionEndpointDeclaration(endpoint);
            _builder.append((Object)_generateConnectionEndpointDeclaration);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private Iterable<Iterable<String>> getConnectionEndpointPaths(Connection conn) {
        Iterable<String> _connectionSourcePath = this.getConnectionSourcePath(conn);
        List<String> _connectionDestinationPath = this.getConnectionDestinationPath(conn);
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Iterable[]{_connectionSourcePath, _connectionDestinationPath}));
    }

    private CharSequence generateConnectionEndpointDeclaration(Iterable<String> path) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("const auto ");
        CharSequence _generateConnectionEndpointName = this.generateConnectionEndpointName(path);
        _builder.append((Object)_generateConnectionEndpointName);
        _builder.append(" = std::array{");
        CharSequence _generateConnectionEndpointValue = this.generateConnectionEndpointValue(path);
        _builder.append((Object)_generateConnectionEndpointValue);
        _builder.append("};");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence generateConnectionEndpointReference(Iterable<String> path) {
        CharSequence _xifexpression = null;
        int _size = IterableExtensions.size(path);
        boolean _greaterThan = _size > 1;
        _xifexpression = _greaterThan ? this.generateConnectionEndpointName(path) : ForteNgExportUtil.getFORTEStringId((String)IterableExtensions.head(path));
        return _xifexpression;
    }

    private CharSequence generateConnectionEndpointName(Iterable<String> path) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (String segment : path) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append("ep_");
            } else {
                _builder.appendImmediate((Object)"__", "");
            }
            _builder.append(segment);
        }
        return _builder;
    }

    private CharSequence generateConnectionEndpointValue(Iterable<String> path) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (String segment : path) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _fORTEStringId = ForteNgExportUtil.getFORTEStringId(segment);
            _builder.append((Object)_fORTEStringId);
        }
        return _builder;
    }

    private Iterable<String> getConnectionSourcePath(Connection conn) {
        Iterable _xifexpression = null;
        boolean _isNegated = conn.isNegated();
        if (_isNegated) {
            List _blockRelativePath = conn.getSource().getBlockRelativePath();
            _xifexpression = Iterables.concat((Iterable)_blockRelativePath, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"NOT"})));
        } else {
            _xifexpression = conn.getSource().getBlockRelativePath();
        }
        return _xifexpression;
    }

    private List<String> getConnectionDestinationPath(Connection conn) {
        return conn.getDestination().getBlockRelativePath();
    }

    @Override
    protected CharSequence generateConnectionInitializer() {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateConnectionInitializer = super.generateConnectionInitializer();
        _builder.append((Object)_generateConnectionInitializer);
        CharSequence _generateDataConnectionInitializer = this.generateDataConnectionInitializer((List<VarDeclaration>)((CompositeFBType)this.getType()).getInterfaceList().getInputVars(), true);
        _builder.append((Object)_generateDataConnectionInitializer);
        CharSequence _generateDataConnectionInitializer_1 = this.generateDataConnectionInitializer((List<VarDeclaration>)((CompositeFBType)this.getType()).getInterfaceList().getOutMappedInOutVars(), true);
        _builder.append((Object)_generateDataConnectionInitializer_1);
        return _builder;
    }

    @Override
    protected CharSequence generateDataConnectionInitializer(List<VarDeclaration> variables, boolean internal) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (VarDeclaration variable : variables) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append(",\n");
            } else {
                _builder.appendImmediate((Object)",\n", "");
            }
            CharSequence _generateNameAsConnection = this.generateNameAsConnection(variable, internal);
            _builder.append((Object)_generateNameAsConnection);
            _builder.append("(*this, ");
            int _indexOf = variables.indexOf(variable);
            _builder.append((Object)_indexOf);
            _builder.append(", ");
            CharSequence _generateVariableDefaultValue = this.generateVariableDefaultValue(variable);
            _builder.append((Object)_generateVariableDefaultValue);
            _builder.append(")");
        }
        return _builder;
    }

    @Override
    protected CharSequence generateWriteOutputDataVariable(VarDeclaration variable) {
        CharSequence _xifexpression = null;
        if (!variable.isInOutVar() && !variable.getInputConnections().isEmpty() && ((Connection)variable.getInputConnections().getFirst()).isNegated()) {
            StringConcatenation _builder = new StringConcatenation();
            CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)variable);
            _builder.append((Object)_generateName);
            _builder.append(" = func_NOT(");
            CharSequence _generateConnectionValue = ForteNgExportUtil.generateConnectionValue((Connection)variable.getInputConnections().getFirst());
            _builder.append((Object)_generateConnectionValue);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            CharSequence _generateWriteOutputDataVariable = super.generateWriteOutputDataVariable(variable);
            _builder.append((Object)_generateWriteOutputDataVariable);
            _builder.newLineIfNotEmpty();
            _xifexpression = _builder;
        } else {
            _xifexpression = super.generateWriteOutputDataVariable(variable);
        }
        return _xifexpression;
    }

    public CharSequence generateSetFBNetworkInitialValuesDefinition() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> it.getInterface().getInputVars();
        Functions.Function1 _function_1 = it -> {
            boolean _isNullOrEmpty;
            Value _value = it.getValue();
            String _value_1 = null;
            if (_value != null) {
                _value_1 = _value.getValue();
            }
            return !(_isNullOrEmpty = StringExtensions.isNullOrEmpty(_value_1));
        };
        boolean _exists = IterableExtensions.exists((Iterable)IterableExtensions.flatMap(this.fbs, (Functions.Function1)_function), (Functions.Function1)_function_1);
        if (_exists) {
            _builder.append("void ");
            CharSequence _fBClassName = this.getFBClassName();
            _builder.append((Object)_fBClassName);
            _builder.append("::setFBNetworkInitialValues() {");
            _builder.newLineIfNotEmpty();
            for (FB fb : this.fbs) {
                Functions.Function1 _function_2 = it -> {
                    boolean _isNullOrEmpty;
                    Value _value = it.getValue();
                    String _value_1 = null;
                    if (_value != null) {
                        _value_1 = _value.getValue();
                    }
                    return !(_isNullOrEmpty = StringExtensions.isNullOrEmpty(_value_1));
                };
                Iterable _filter = IterableExtensions.filter((Iterable)fb.getInterface().getInputVars(), (Functions.Function1)_function_2);
                for (VarDeclaration variable : _filter) {
                    boolean _isGenericType = ForteNgExportUtil.isGenericType((LibraryElement)fb.getType());
                    if (_isGenericType) {
                        _builder.append("  ");
                        _builder.append("if (auto v = ");
                        CharSequence _generateName = ForteNgExportUtil.generateName((BlockFBNetworkElement)fb);
                        _builder.append((Object)_generateName, "  ");
                        _builder.append("->getDataInput(");
                        CharSequence _fORTEStringId = ForteNgExportUtil.getFORTEStringId(variable.getName());
                        _builder.append((Object)_fORTEStringId, "  ");
                        _builder.append(")) { v->setValue(");
                        CharSequence _generateFBNetworkInitialValue = this.generateFBNetworkInitialValue(variable);
                        _builder.append((Object)_generateFBNetworkInitialValue, "  ");
                        _builder.append("); }");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    _builder.append("  ");
                    CharSequence _generateName_1 = ForteNgExportUtil.generateName((BlockFBNetworkElement)fb);
                    _builder.append((Object)_generateName_1, "  ");
                    _builder.append("->");
                    CharSequence _generateName_2 = ForteNgExportUtil.generateName((IInterfaceElement)variable);
                    _builder.append((Object)_generateName_2, "  ");
                    _builder.append(" = ");
                    CharSequence _generateFBNetworkInitialValue_1 = this.generateFBNetworkInitialValue(variable);
                    _builder.append((Object)_generateFBNetworkInitialValue_1, "  ");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generateFBNetworkInitialValue(VarDeclaration decl) {
        try {
            ILanguageSupport _get = this.fbNetworkInitialVariableLanguageSupport.get(decl);
            CharSequence _generate = null;
            if (_get != null) {
                _generate = _get.generate(CollectionLiterals.emptyMap());
            }
            return _generate;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public List<String> getErrors() {
        List<String> _errors = super.getErrors();
        Functions.Function1 _function = it -> it.getErrors();
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull(this.fbNetworkInitialVariableLanguageSupport.values()), (Functions.Function1)_function));
        return IterableExtensions.toList((Iterable)Iterables.concat(_errors, (Iterable)_set));
    }

    @Override
    public List<String> getWarnings() {
        List<String> _warnings = super.getWarnings();
        Functions.Function1 _function = it -> it.getWarnings();
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull(this.fbNetworkInitialVariableLanguageSupport.values()), (Functions.Function1)_function));
        return IterableExtensions.toList((Iterable)Iterables.concat(_warnings, (Iterable)_set));
    }

    @Override
    public List<String> getInfos() {
        List<String> _infos = super.getInfos();
        Functions.Function1 _function = it -> it.getInfos();
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull(this.fbNetworkInitialVariableLanguageSupport.values()), (Functions.Function1)_function));
        return IterableExtensions.toList((Iterable)Iterables.concat(_infos, (Iterable)_set));
    }

    @Override
    public Set<INamedElement> getDependencies(Map<?, ?> options) {
        Set<INamedElement> _dependencies = super.getDependencies(options);
        Functions.Function1 _function = it -> it.getDependencies(options);
        Iterable _flatMap = IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull(this.fbNetworkInitialVariableLanguageSupport.values()), (Functions.Function1)_function);
        Iterable _plus = Iterables.concat(_dependencies, (Iterable)_flatMap);
        Collection<Object> _xifexpression = null;
        Functions.Function1 _function_1 = it -> it.getWith();
        Functions.Function1 _function_2 = it -> this.getWithVariable((With)it);
        Functions.Function1 _function_3 = it -> !it.isInOutVar() && !it.getInputConnections().isEmpty() && ((Connection)it.getInputConnections().getFirst()).isNegated();
        boolean _exists = IterableExtensions.exists((Iterable)IterableExtensions.map((Iterable)IterableExtensions.flatMap((Iterable)((CompositeFBType)this.getType()).getInterfaceList().getEventOutputs(), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
        if (_exists) {
            LibraryElement _createDependencyPlaceholder = ForteNgExportUtil.createDependencyPlaceholder("iec61131_functions/func_NOT");
            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new LibraryElement[]{_createDependencyPlaceholder}));
        } else {
            _xifexpression = CollectionLiterals.emptySet();
        }
        return IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)_plus, (Iterable)_xifexpression));
    }
}

