/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.figures;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Geometry;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.model.data.AnyType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.swt.graphics.Color;

public class HideableConnection
extends PolylineConnection {
    private static final int CONNECTION_SELECTION_TOLERANCE = 6;
    public static final int BEND_POINT_BEVEL_SIZE = 5;
    public static final int NORMAL_DOUBLE_LINE_WIDTH = 3;
    private static final int DOUBLE_LINE_AMPLIFICATION = 2;
    private boolean hidden = false;
    private Connection model;
    private Color lighterColor;

    public void setModel(Connection newModel) {
        this.model = newModel;
    }

    public Connection getModel() {
        return this.model;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Color getLighterColor() {
        return this.lighterColor;
    }

    public void setHidden(boolean hidden) {
        boolean oldHidden = this.hidden;
        this.hidden = hidden;
        if (oldHidden != hidden) {
            this.handleVisibilityChange(hidden);
            this.invalidate();
            this.repaint();
        }
    }

    protected void handleVisibilityChange(boolean hidden) {
    }

    public void setForegroundColor(Color fg) {
        super.setForegroundColor(fg);
        if (this.isAdapterOrStructConnection()) {
            this.lighterColor = FigureUtilities.lighter((Color)fg);
        }
    }

    protected void outlineShape(Graphics g) {
        if (this.isAdapterOrStructConnection()) {
            this.drawDoublePolyline(g);
        } else {
            g.drawPolyline(this.getPoints());
        }
    }

    public boolean isAdapterOrStructConnection() {
        if (this.model instanceof DataConnection) {
            IInterfaceElement refElement = this.getRefPin();
            return refElement != null && refElement.getType() instanceof StructuredType;
        }
        return this.model instanceof AdapterConnection;
    }

    private IInterfaceElement getRefPin() {
        DataType dataType;
        IInterfaceElement refElement = this.model.getSource();
        if (refElement == null) {
            refElement = this.model.getDestination();
        }
        if (refElement != null && (dataType = refElement.getType()) instanceof AnyType && dataType == IecTypes.GenericTypes.ANY && refElement == this.model.getSource()) {
            refElement = this.getModel().getDestination();
        }
        return refElement;
    }

    private void drawDoublePolyline(Graphics g) {
        g.drawPolyline(this.getPoints());
        g.setLineWidth(this.getLineWidth() / 3);
        if (g.getAbsoluteScale() >= 1.0) {
            g.setForegroundColor(this.lighterColor);
            g.drawPolyline(this.getPoints());
        }
    }

    public Rectangle getBounds() {
        int CLIPPING_BUFFER = 2;
        return super.getBounds().getExpanded(2, 2);
    }

    public void setLineWidth(int w) {
        int width = w;
        if (this.isAdapterOrStructConnection()) {
            width = Math.max(w * 2, 3);
        }
        super.setLineWidth(width);
    }

    protected boolean shapeContainsPoint(int x, int y) {
        return Geometry.polylineContainsPoint((PointList)this.getPoints(), (int)x, (int)y, (int)(this.getLineWidth() + 6));
    }

    public void setPoints(PointList points) {
        super.setPoints(HideableConnection.getBeveledPoints(points));
    }

    private static PointList getBeveledPoints(PointList srcPoints) {
        PointList beveledPoints = new PointList();
        beveledPoints.addPoint(srcPoints.getFirstPoint());
        int i = 1;
        while (i < srcPoints.size() - 1) {
            Point before = srcPoints.getPoint(i - 1);
            Point after = srcPoints.getPoint(i + 1);
            int verDistance = Math.abs(before.x - after.x);
            int horDistance = Math.abs(before.y - after.y);
            int bevelSize = 5;
            if (verDistance < 10) {
                bevelSize = verDistance / 2;
            }
            if (horDistance < 10) {
                bevelSize = horDistance / 2;
            }
            beveledPoints.addPoint(HideableConnection.calculatedBeveledPoint(srcPoints.getPoint(i), before, bevelSize));
            beveledPoints.addPoint(HideableConnection.calculatedBeveledPoint(srcPoints.getPoint(i), after, bevelSize));
            ++i;
        }
        beveledPoints.addPoint(srcPoints.getLastPoint());
        return beveledPoints;
    }

    private static Point calculatedBeveledPoint(Point refPoint, Point otherPoint, int bevelSize) {
        if (refPoint.x - otherPoint.x == 0) {
            return new Point(refPoint.x, refPoint.y + (refPoint.y - otherPoint.y > 0 ? -bevelSize : bevelSize));
        }
        return new Point(refPoint.x + (refPoint.x - otherPoint.x > 0 ? -bevelSize : bevelSize), refPoint.y);
    }
}

