/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.gef.nat.InterfaceElementColumnAccessor;
import org.eclipse.fordiac.ide.gef.nat.TypedElementConfigLabelAccumulator;
import org.eclipse.fordiac.ide.gef.nat.TypedElementTableColumn;
import org.eclipse.fordiac.ide.gef.properties.AbstractEditInterfaceSection;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.AdapterTypeEntry;
import org.eclipse.fordiac.ide.model.ui.editors.DataTypeTreeSelectionDialog;
import org.eclipse.fordiac.ide.model.ui.nat.AdapterTypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.nat.TypeNode;
import org.eclipse.fordiac.ide.model.ui.nat.TypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.AdapterTypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.ITypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.TypeSelectionButton;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.nattable.ChangeableListDataProvider;
import org.eclipse.fordiac.ide.ui.widget.nattable.I4diacNatTableUtil;
import org.eclipse.fordiac.ide.ui.widget.nattable.NatTableColumnProvider;
import org.eclipse.fordiac.ide.ui.widget.nattable.NatTableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public abstract class AbstractEditInterfaceAdapterSection
extends AbstractEditInterfaceSection<AdapterDeclaration> {
    protected AdapterType getLastUsedAdapterType(InterfaceList interfaceList, IInterfaceElement interfaceElement, boolean isInput) {
        if (interfaceElement != null) {
            return (AdapterType)interfaceElement.getType();
        }
        EList<AdapterDeclaration> adapterList = AbstractEditInterfaceAdapterSection.getAdapterList(interfaceList, isInput);
        if (!adapterList.isEmpty()) {
            return ((AdapterDeclaration)adapterList.get(adapterList.size() - 1)).getType();
        }
        return ((AdapterTypeEntry)this.getTypeLibrary().getAdapterTypes().iterator().next()).getType();
    }

    @Override
    protected int getInsertingIndex(IInterfaceElement interfaceElement, boolean isInput) {
        if (interfaceElement != null) {
            return this.getInsertingIndex(interfaceElement, AbstractEditInterfaceAdapterSection.getAdapterList(interfaceElement.getInterfaceList(), isInput));
        }
        return -1;
    }

    private static EList<AdapterDeclaration> getAdapterList(InterfaceList interfaceList, boolean isInput) {
        return isInput ? interfaceList.getSockets() : interfaceList.getPlugs();
    }

    public void addEntry(Object entry, boolean isInput, int index, CompoundCommand cmd) {
        if (entry instanceof AdapterDeclaration) {
            AdapterDeclaration adapterDeclaration = (AdapterDeclaration)entry;
            cmd.add((Command)this.newInsertCommand((IInterfaceElement)adapterDeclaration, isInput, index));
        }
    }

    public void removeEntry(Object entry, CompoundCommand cmd) {
        if (entry instanceof AdapterDeclaration) {
            AdapterDeclaration adapterDeclaration = (AdapterDeclaration)entry;
            cmd.add((Command)this.newDeleteCommand((IInterfaceElement)adapterDeclaration));
        }
    }

    @Override
    public void setupOutputTable(Group outputsGroup) {
        this.outputProvider = new ChangeableListDataProvider((IColumnAccessor)new InterfaceElementColumnAccessor<AdapterDeclaration>((CommandExecutor)this){

            @Override
            public Command createCommand(AdapterDeclaration rowObject, TypedElementTableColumn column, Object newValue) {
                return switch (column) {
                    case TypedElementTableColumn.NAME -> AbstractEditInterfaceAdapterSection.this.onNameChange((IInterfaceElement)rowObject, Objects.toString(newValue, ""));
                    default -> super.createCommand(rowObject, column, newValue);
                };
            }
        });
        DataLayer outputDataLayer = new DataLayer((IDataProvider)this.outputProvider);
        outputDataLayer.setConfigLabelAccumulator(new TypedElementConfigLabelAccumulator(this.outputProvider, this::getAnnotationModel));
        this.outputTable = NatTableWidgetFactory.createRowNatTable((Composite)outputsGroup, (DataLayer)outputDataLayer, (IDataProvider)new NatTableColumnProvider(TypedElementTableColumn.DEFAULT_COLUMNS), (IEditableRule)this.getSectionEditableRule(), (ICellEditor)this.createTypeSelectionButton(), (I4diacNatTableUtil)this, (boolean)false);
    }

    @Override
    public void setupInputTable(Group inputsGroup) {
        this.inputProvider = new ChangeableListDataProvider((IColumnAccessor)new InterfaceElementColumnAccessor<AdapterDeclaration>((CommandExecutor)this){

            @Override
            public Command createCommand(AdapterDeclaration rowObject, TypedElementTableColumn column, Object newValue) {
                return switch (column) {
                    case TypedElementTableColumn.NAME -> AbstractEditInterfaceAdapterSection.this.onNameChange((IInterfaceElement)rowObject, Objects.toString(newValue, ""));
                    default -> super.createCommand(rowObject, column, newValue);
                };
            }
        });
        DataLayer inputDataLayer = new DataLayer((IDataProvider)this.inputProvider);
        inputDataLayer.setConfigLabelAccumulator(new TypedElementConfigLabelAccumulator(this.inputProvider, this::getAnnotationModel));
        this.inputTable = NatTableWidgetFactory.createRowNatTable((Composite)inputsGroup, (DataLayer)inputDataLayer, (IDataProvider)new NatTableColumnProvider(TypedElementTableColumn.DEFAULT_COLUMNS), (IEditableRule)this.getSectionEditableRule(), (ICellEditor)this.createTypeSelectionButton(), (I4diacNatTableUtil)this, (boolean)true);
    }

    @Override
    public void setTableInput(InterfaceList il) {
        this.inputProvider.setInput((List)il.getSockets());
        this.outputProvider.setInput((List)il.getPlugs());
    }

    private TypeSelectionButton createTypeSelectionButton() {
        return new TypeSelectionButton(this::getTypeLibrary, (ITypeSelectionContentProvider)AdapterTypeSelectionContentProvider.INSTANCE, (TypeSelectionTreeContentProvider)AdapterTypeSelectionTreeContentProvider.INSTANCE, (DelegatingStyledCellLabelProvider.IStyledLabelProvider)AdapterTreeNodeLabelProvider.INSTANCE);
    }

    public static class AdapterTreeNodeLabelProvider
    extends DataTypeTreeSelectionDialog.TreeNodeLabelProvider {
        public static final AdapterTreeNodeLabelProvider INSTANCE = new AdapterTreeNodeLabelProvider();

        public Image getImage(Object element) {
            LibraryElement type;
            TypeNode node;
            if (element instanceof TypeNode && (node = (TypeNode)element).getType() != null && (type = node.getType()) instanceof AdapterType) {
                return FordiacImage.ICON_ADAPTER_TYPE.getImage();
            }
            return super.getImage(element);
        }
    }
}

