/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.tools;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.gef.tools.CanvasHelper;
import org.eclipse.fordiac.ide.model.ui.editors.AdvancedScrollingGraphicalViewer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.MarqueeDragTracker;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;

public class AdvancedMarqueeDragTracker
extends MarqueeDragTracker {
    private static final Request MARQUEE_REQUEST = new Request((Object)"selection");
    private static final Insets MARQUEE_DRAG_BORDER = new Insets(1, 1, 1, 1);
    private EditPartViewer startingViewer;

    protected boolean handleButtonDown(int button) {
        if (3 == button && this.getCurrentViewer() != null) {
            this.getCurrentViewer().setSelection((ISelection)this.getDefaultSelectionForRightMouseDown());
        }
        return super.handleButtonDown(button);
    }

    protected StructuredSelection getDefaultSelectionForRightMouseDown() {
        return StructuredSelection.EMPTY;
    }

    protected EditPartViewer getCurrentViewer() {
        if (this.startingViewer != null) {
            return this.startingViewer;
        }
        return super.getCurrentViewer();
    }

    public void mouseDown(MouseEvent me, EditPartViewer viewer) {
        if (viewer instanceof AdvancedScrollingGraphicalViewer) {
            AdvancedScrollingGraphicalViewer advScrollingGraphicalViewer = (AdvancedScrollingGraphicalViewer)viewer;
            CanvasHelper.bindToContentPane(me, advScrollingGraphicalViewer, MARQUEE_DRAG_BORDER);
        }
        this.startingViewer = viewer;
        super.mouseDown(me, viewer);
    }

    public void mouseUp(MouseEvent me, EditPartViewer viewer) {
        super.mouseUp(me, this.startingViewer);
        this.startingViewer = null;
    }

    public void mouseDrag(MouseEvent me, EditPartViewer viewer) {
        if (this.isActive() && viewer instanceof AdvancedScrollingGraphicalViewer) {
            AdvancedScrollingGraphicalViewer advScrollingGraphicalViewer = (AdvancedScrollingGraphicalViewer)viewer;
            Point oldViewPort = advScrollingGraphicalViewer.getViewLocation();
            ((AdvancedScrollingGraphicalViewer)viewer).checkScrollPositionDuringDrag(me);
            Dimension delta = oldViewPort.getDifference(advScrollingGraphicalViewer.getViewLocation());
            this.setStartLocation(this.getStartLocation().getTranslated(delta));
            CanvasHelper.bindToContentPane(me, advScrollingGraphicalViewer, MARQUEE_DRAG_BORDER);
        }
        super.mouseDrag(me, viewer);
    }

    protected boolean handleDoubleClick(int button) {
        if (1 == button) {
            this.performOpen();
        }
        return true;
    }

    protected void performOpen() {
        EditPart editPart = this.getCurrentViewer().findObjectAt(this.getLocation());
        if (editPart != null) {
            SelectionRequest request = new SelectionRequest();
            request.setLocation(this.getLocation());
            request.setType((Object)"open");
            editPart.performRequest((Request)request);
        }
    }

    protected boolean isMarqueeSelectable(GraphicalEditPart editPart) {
        return editPart.getTargetEditPart(MARQUEE_REQUEST) == editPart && editPart.isSelectable();
    }
}

