/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.tools;

import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ViewportAutoexposeHelper;

public class FordiacViewportAutoexposeHelper
extends ViewportAutoexposeHelper {
    private static final Insets DEFAULT_EXPOSE_THRESHOLD = new Insets(100);
    private long lastStepTime = 0L;
    private final Insets threshold;

    public FordiacViewportAutoexposeHelper(GraphicalEditPart owner) {
        this(owner, DEFAULT_EXPOSE_THRESHOLD);
    }

    public FordiacViewportAutoexposeHelper(GraphicalEditPart owner, Insets threshold) {
        super(owner, threshold);
        this.threshold = threshold;
    }

    public boolean step(Point where) {
        long difference;
        Viewport port = this.findViewport(this.owner);
        Rectangle rect = Rectangle.SINGLETON;
        port.getClientArea(rect);
        port.translateToParent((Translatable)rect);
        port.translateToAbsolute((Translatable)rect);
        if (!rect.contains(where)) {
            return false;
        }
        rect.shrink(this.threshold);
        if (rect.contains(where)) {
            return false;
        }
        if (this.lastStepTime == 0L) {
            this.lastStepTime = System.currentTimeMillis();
        }
        if ((difference = System.currentTimeMillis() - this.lastStepTime) < 0L) {
            return true;
        }
        this.lastStepTime = System.currentTimeMillis();
        int region = rect.getPosition(where);
        Point loc = port.getViewLocation();
        if ((region & 4) != 0) {
            loc.y += (int)difference * (where.y() - rect.bottom()) / this.threshold.bottom;
        } else if ((region & 1) != 0) {
            loc.y += (int)difference * (where.y() - rect.top()) / this.threshold.top;
        }
        if ((region & 0x10) != 0) {
            loc.x += (int)difference * (where.x() - rect.right()) / this.threshold.right;
        } else if ((region & 8) != 0) {
            loc.x += (int)difference * (where.x() - rect.left()) / this.threshold.left;
        }
        port.setViewLocation(loc);
        return true;
    }
}

