/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListenerManager;
import org.eclipse.fordiac.ide.model.ui.editors.AdvancedScrollingGraphicalViewer;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public final class ElementSelector {
    public static void selectViewObjects(Collection<? extends Object> viewObjects) {
        Display.getDefault().execute(() -> {
            IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            GraphicalViewer viewer = (GraphicalViewer)part.getAdapter(GraphicalViewer.class);
            if (viewer != null) {
                viewer.flush();
                List<EditPart> editParts = ElementSelector.getSelectableEditParts(viewer, viewObjects);
                if (!editParts.isEmpty()) {
                    viewer.setSelection((ISelection)new StructuredSelection(editParts));
                    if (viewer instanceof AdvancedScrollingGraphicalViewer) {
                        AdvancedScrollingGraphicalViewer asViewer = (AdvancedScrollingGraphicalViewer)viewer;
                        asViewer.revealEditPart(editParts.get(0));
                    } else {
                        viewer.reveal(editParts.get(0));
                    }
                }
            }
        });
    }

    private static List<EditPart> getSelectableEditParts(GraphicalViewer viewer, Collection<?> viewObjects) {
        ArrayList<EditPart> selectableChildren = new ArrayList<EditPart>();
        for (Object view : viewObjects) {
            EditPart ep;
            EditPart editPart = viewer.getEditPartForModel(view);
            if (!(editPart instanceof EditPart) || !(ep = editPart).getModel().equals(view)) continue;
            selectableChildren.add(ep);
        }
        return selectableChildren;
    }

    public static void jumpToPinFromDoubleClickEvent(DoubleClickEvent event) {
        if (!((StructuredSelection)event.getSelection()).isEmpty()) {
            IInterfaceElement selElement = null;
            Object selection = ((StructuredSelection)event.getSelection()).getFirstElement();
            if (selection instanceof IInterfaceElement) {
                IInterfaceElement ie;
                selElement = ie = (IInterfaceElement)selection;
            }
            if (selection instanceof Connection) {
                Connection conn = (Connection)selection;
                TableViewer tableViewer = (TableViewer)event.getSource();
                selElement = tableViewer.getInput().equals(((Connection)selection).getSource()) ? conn.getDestination() : conn.getSource();
            }
            if (selElement != null && selElement.getBlockFBNetworkElement() != null) {
                IEditorPart editor = OpenListenerManager.openEditor((EObject)selElement.getBlockFBNetworkElement().eContainer().eContainer());
                HandlerHelper.selectElement((Object)selElement, (GraphicalViewer)HandlerHelper.getViewer((IEditorPart)editor));
            }
        }
    }

    private ElementSelector() {
        throw new UnsupportedOperationException("do not instantiate this class");
    }
}

