/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.library;

import java.text.MessageFormat;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFolder;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.library.DependencyNode;
import org.eclipse.fordiac.ide.library.LibraryManager;
import org.eclipse.fordiac.ide.library.Messages;
import org.eclipse.fordiac.ide.library.ResolveNode;
import org.eclipse.fordiac.ide.library.model.library.Manifest;
import org.eclipse.fordiac.ide.library.model.util.VersionComparator;
import org.eclipse.fordiac.ide.model.errormarker.ErrorMarkerBuilder;
import org.osgi.framework.VersionRange;

public class LibraryMarkerFactory {
    public static final String MARKER_ATTRIBUTE = "LIB";

    public static ErrorMarkerBuilder createDependencyMarker(Manifest manifest, ResolveNode rnode, DependencyNode dnode) {
        return ErrorMarkerBuilder.createErrorMarkerBuilder((String)MessageFormat.format(rnode.getError(), rnode.getSymbolicName(), VersionComparator.formatVersionRange((VersionRange)dnode.getRange()), String.join((CharSequence)", ", dnode.getCauses().keySet()))).setType("org.eclipse.fordiac.ide.model.library").setTarget((EObject)manifest.getDependencies()).addAdditionalAttributes(Map.of(MARKER_ATTRIBUTE, rnode.getSymbolicName()));
    }

    public static ErrorMarkerBuilder createDependencyMarker(Manifest manifest, DependencyNode dnode) {
        String causedBy = dnode.getCauses().entrySet().stream().map(entry -> (String)entry.getKey() + ": " + VersionComparator.formatVersionRange((VersionRange)((VersionRange)entry.getValue()))).collect(Collectors.joining(", "));
        return ErrorMarkerBuilder.createErrorMarkerBuilder((String)MessageFormat.format(Messages.ErrorMarkerVersionRangeEmpty, dnode.getSymbolicName(), causedBy)).setType("org.eclipse.fordiac.ide.model.library").setTarget((EObject)manifest.getDependencies()).addAdditionalAttributes(Map.of(MARKER_ATTRIBUTE, dnode.getSymbolicName()));
    }

    public static ErrorMarkerBuilder createBrokenLinkMarker(IFolder libFolder) {
        return ErrorMarkerBuilder.createErrorMarkerBuilder((String)Messages.LibraryManager_BrokenLink).setType("org.eclipse.fordiac.ide.model.library").setLocation(MessageFormat.format("Library: {0} - Version: {1}", libFolder.getName(), LibraryManager.parseLibraryVersion(libFolder)));
    }

    private LibraryMarkerFactory() {
        throw new UnsupportedOperationException();
    }
}

