/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.library;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.library.LibraryManager;
import org.eclipse.fordiac.ide.library.Messages;

public class LibraryPermission {
    private static final Set<PosixFilePermission> PERMISSIONS = Set.of(PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE);

    public static void setPathReadOnly(Path path) {
        LibraryPermission.setPathEditable(path, false);
    }

    public static void setPathEditable(Path path) {
        LibraryPermission.setPathEditable(path, true);
    }

    public static void setLibReadOnly(final Path libraryPath) {
        WorkspaceJob job = new WorkspaceJob(Messages.LibraryManager_SetStandardLibrariesReadOnly){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    Files.walkFileTree(libraryPath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            LibraryPermission.setPathReadOnly(file);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == LibraryManager.FAMILY_FORDIAC_LIBRARY;
            }
        };
        job.setRule(null);
        job.setPriority(50);
        job.schedule();
    }

    private static void setPathEditable(Path path, boolean editable) {
        PosixFileAttributeView posixView;
        DosFileAttributeView dosView = Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0]);
        if (dosView != null) {
            try {
                dosView.setReadOnly(!editable);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((posixView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0])) != null) {
            try {
                Set<PosixFilePermission> permissions = posixView.readAttributes().permissions();
                if (editable) {
                    permissions.addAll(PERMISSIONS);
                } else {
                    permissions.removeAll(PERMISSIONS);
                }
                posixView.setPermissions(permissions);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private LibraryPermission() {
        throw new UnsupportedOperationException();
    }
}

