/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.ConnectionLayoutTagger;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentBoundsCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeGroupBoundsCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeSubAppBoundsCommand;
import org.eclipse.fordiac.ide.model.commands.change.SetPositionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Comment;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public abstract class AbstractChangeContainerBoundsCommand
extends Command
implements ConnectionLayoutTagger,
ScopedCommand {
    private final Position newPos;
    private final double oldWidth;
    private final double oldHeight;
    private final double newWidth;
    private final double newHeight;
    private final PositionableElement target;
    private CompoundCommand updatePositions;

    public static AbstractChangeContainerBoundsCommand getCommandFor(FBNetworkElement container, Position newPos, double newWidth, double newHeight) {
        FBNetworkElement fBNetworkElement = container;
        Objects.requireNonNull(fBNetworkElement);
        FBNetworkElement fBNetworkElement2 = fBNetworkElement;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Group.class, SubApp.class, Comment.class}, (Object)fBNetworkElement2, 0)) {
            case 0 -> {
                Group group = (Group)fBNetworkElement2;
                yield new ChangeGroupBoundsCommand(group, newPos, newWidth, newHeight);
            }
            case 1 -> {
                SubApp subApp = (SubApp)fBNetworkElement2;
                yield new ChangeSubAppBoundsCommand(subApp, newPos, newWidth, newHeight);
            }
            case 2 -> {
                Comment comment = (Comment)fBNetworkElement2;
                yield new ChangeCommentBoundsCommand(comment, newPos, newWidth, newHeight);
            }
            default -> null;
        };
    }

    protected AbstractChangeContainerBoundsCommand(PositionableElement target, Position newPos, double newWidth, double newHeight, double oldWidth, double oldHeight) {
        this.target = Objects.requireNonNull(target);
        this.newPos = newPos;
        this.newWidth = newWidth;
        this.newHeight = newHeight;
        this.oldWidth = oldWidth;
        this.oldHeight = oldHeight;
    }

    public void execute() {
        this.updatePositions = this.createSetPosCommand();
        this.updateSize(this.newWidth, this.newHeight);
        if (this.updatePositions != null) {
            this.updatePositions.execute();
        }
    }

    public void undo() {
        if (this.updatePositions != null) {
            this.updatePositions.undo();
        }
        this.updateSize(this.oldWidth, this.oldHeight);
    }

    public void redo() {
        if (this.updatePositions != null) {
            this.updatePositions.redo();
        }
        this.updateSize(this.newWidth, this.newHeight);
    }

    public PositionableElement getTarget() {
        return this.target;
    }

    private CompoundCommand createSetPosCommand() {
        Position oldPos = this.target.getPosition();
        double dx = this.newPos.getX() - oldPos.getX();
        double dy = this.newPos.getY() - oldPos.getY();
        if (dx != 0.0 || dy != 0.0) {
            CompoundCommand cmd = new CompoundCommand();
            cmd.add((Command)new SetPositionCommand(this.target, this.newPos));
            this.getChildren().stream().filter(el -> !el.isInGroup() || this.target.equals(el.getGroup())).forEach(el -> cmd.add((Command)new SetPositionCommand((PositionableElement)el, -dx, -dy)));
            return cmd;
        }
        return null;
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.target);
    }

    protected abstract void updateSize(double var1, double var3);

    protected abstract List<FBNetworkElement> getChildren();
}

