/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.st;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.EvaluatorPrepareException;
import org.eclipse.fordiac.ide.model.eval.st.STCallableEvaluator;
import org.eclipse.fordiac.ide.model.eval.st.StructuredTextEvaluator;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.STMethod;
import org.eclipse.fordiac.ide.structuredtextalgorithm.util.StructuredTextParseUtil;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclarationBlock;

public class STMethodEvaluator
extends STCallableEvaluator {
    private final STMethod method;
    private org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod parseResult;

    public STMethodEvaluator(STMethod method, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        super(method.getName(), context, variables, parent);
        this.method = method;
    }

    public STMethodEvaluator(org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod method, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        super(method.getName(), context, variables, parent);
        this.method = null;
        this.parseResult = method;
    }

    public void prepare() throws EvaluatorException {
        if (this.parseResult == null) {
            ArrayList errors = new ArrayList();
            ArrayList warnings = new ArrayList();
            ArrayList infos = new ArrayList();
            if (this.method != null) {
                this.parseResult = StructuredTextParseUtil.parse((STMethod)this.method, errors, warnings, infos);
            }
            errors.forEach(arg_0 -> ((STMethodEvaluator)this).error(arg_0));
            warnings.forEach(arg_0 -> ((STMethodEvaluator)this).warn(arg_0));
            infos.forEach(arg_0 -> ((STMethodEvaluator)this).info(arg_0));
            if (this.parseResult == null) {
                throw new EvaluatorPrepareException(errors.stream().collect(Collectors.joining(", ")), (Evaluator)this);
            }
        }
        this.prepareCallableVariables((List<? extends STVarDeclarationBlock>)this.parseResult.getBody().getVarDeclarations(), this.parseResult.getName(), this.parseResult.getReturnType());
    }

    public void cleanup() {
        this.parseResult = null;
    }

    public Value evaluate() throws EvaluatorException, InterruptedException {
        this.prepare();
        this.evaluateStructuredTextMethod(this.parseResult);
        this.trap(this.parseResult);
        if (this.getReturnVariable() != null) {
            return this.getReturnVariable().getValue();
        }
        return null;
    }

    protected void evaluateStructuredTextMethod(org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod method) throws EvaluatorException, InterruptedException {
        this.evaluateCallableVariables((List<? extends STVarDeclarationBlock>)method.getBody().getVarDeclarations());
        try {
            this.evaluateStatementList((List<STStatement>)method.getBody().getStatements());
        }
        catch (StructuredTextEvaluator.StructuredTextException structuredTextException) {
            // empty catch block
        }
    }

    public org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod getSourceElement() {
        return this.parseResult;
    }

    public Set<String> getDependencies() {
        this.prepare();
        if (this.parseResult != null) {
            return StructuredTextParseUtil.collectUsedTypes((EObject)this.parseResult);
        }
        return Collections.emptySet();
    }
}

