/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.helpers;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.helpers.ArraySizeHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.ContainerVarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarConfigInstance;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;

public final class InterfaceListCopier {
    public static InterfaceList copy(InterfaceList src, boolean copyValues, boolean copyComments) {
        InterfaceList copy = LibraryElementFactory.eINSTANCE.createInterfaceList();
        InterfaceListCopier.copyVarList(copy.getInputVars(), src.getInputVars(), copyValues, copyComments);
        InterfaceListCopier.copyVarList(copy.getOutputVars(), src.getOutputVars(), copyValues, copyComments);
        InterfaceListCopier.copyVarList(copy.getInOutVars(), src.getInOutVars(), copyValues, copyComments);
        InterfaceListCopier.copyEventList(copy.getEventInputs(), copy.getInputVars(), copy.getInOutVars(), src.getEventInputs(), src.getInputVars(), src.getInOutVars(), copyComments);
        InterfaceListCopier.copyEventList(copy.getEventOutputs(), copy.getOutputVars(), copy.getOutMappedInOutVars(), src.getEventOutputs(), src.getOutputVars(), src.getOutMappedInOutVars(), copyComments);
        InterfaceListCopier.copyAdapterList(copy.getPlugs(), src.getPlugs(), copyComments);
        InterfaceListCopier.copyAdapterList(copy.getSockets(), src.getSockets(), copyComments);
        InterfaceListCopier.copyErrorMarkerList(copy.getErrorMarker(), src.getErrorMarker(), copyValues, copyComments);
        return copy;
    }

    private static void copyErrorMarkerList(EList<ErrorMarkerInterface> copy, EList<ErrorMarkerInterface> src, boolean copyValues, boolean copyComments) {
        src.forEach(c -> {
            boolean bl3 = copy.add((Object)InterfaceListCopier.copyMarker(c, copyValues, copyComments));
        });
    }

    private static ErrorMarkerInterface copyMarker(ErrorMarkerInterface src, boolean copyValues, boolean copyComments) {
        ErrorMarkerInterface copy = LibraryElementFactory.eINSTANCE.createErrorMarkerInterface();
        InterfaceListCopier.copyInterfaceElement(src, copy, copyComments);
        if (copyValues && src.getValue() != null) {
            Value varInitialization = LibraryElementFactory.eINSTANCE.createValue();
            varInitialization.setValue(src.getValue().getValue());
            copy.setValue(varInitialization);
        }
        return copy;
    }

    public static void copyVarList(Collection<VarDeclaration> destVars, Collection<VarDeclaration> srcVars, boolean copyComments) {
        srcVars.forEach(variable -> {
            boolean bl2 = destVars.add(InterfaceListCopier.copyVar(variable, false, copyComments));
        });
    }

    private static void copyVarList(EList<VarDeclaration> destVars, EList<VarDeclaration> srcVars, boolean copyValues, boolean copyComments) {
        srcVars.forEach(variable -> {
            boolean bl3 = destVars.add((Object)InterfaceListCopier.copyVar(variable, copyValues, copyComments));
        });
    }

    public static VarDeclaration copyVar(VarDeclaration variable, boolean copyValues, boolean copyComments) {
        VarDeclaration copy = InterfaceListCopier.createVarDecl(variable, copyValues, copyComments);
        ArraySizeHelper.setArraySize(copy, ArraySizeHelper.getArraySize(variable));
        InterfaceListCopier.copyInterfaceElement(variable, copy, copyComments);
        Value varInitialization = LibraryElementFactory.eINSTANCE.createValue();
        if (copyValues && variable.getValue() != null) {
            varInitialization.setValue(variable.getValue().getValue());
        }
        copy.setValue(varInitialization);
        return copy;
    }

    private static VarDeclaration createVarDecl(VarDeclaration variable, boolean copyValues, boolean copyComments) {
        if (variable instanceof ContainerVarDeclaration) {
            ContainerVarDeclaration contVarDecl = (ContainerVarDeclaration)variable;
            ContainerVarDeclaration copyContVar = LibraryElementFactory.eINSTANCE.createContainerVarDeclaration();
            contVarDecl.getCachedMembers().forEach(contVar -> {
                boolean bl3 = copyContVar.getCachedMembers().add((Object)InterfaceListCopier.copyVar(contVar, copyValues, copyComments));
            });
            return copyContVar;
        }
        return LibraryElementFactory.eINSTANCE.createVarDeclaration();
    }

    private static void copyInterfaceElement(IInterfaceElement src, IInterfaceElement dst, boolean copyComments) {
        if (copyComments) {
            dst.setComment(src.getComment());
        }
        dst.setIsInput(src.isIsInput());
        dst.setName(src.getName());
        dst.setType(src.getType());
    }

    private static void copyEventList(EList<Event> destEvents, EList<VarDeclaration> copyVars, EList<VarDeclaration> copyInOutVars, EList<Event> srcEvents, EList<VarDeclaration> srcVars, EList<VarDeclaration> srcVarInOuts, boolean copyComments) {
        srcEvents.forEach(srcEvent -> {
            Event copy = InterfaceListCopier.copyEvent(srcEvent, copyComments);
            InterfaceListCopier.copyWiths(copy, srcEvent, copyVars, copyInOutVars, srcVars, srcVarInOuts);
            destEvents.add((Object)copy);
        });
    }

    public static Event copyEvent(Event srcEvent, boolean copyComments) {
        Event copy = LibraryElementFactory.eINSTANCE.createEvent();
        InterfaceListCopier.copyInterfaceElement(srcEvent, copy, copyComments);
        if (copyComments) {
            copy.setComment(srcEvent.getComment());
        }
        return copy;
    }

    private static void copyWiths(Event copy, Event srcEvent, EList<VarDeclaration> copyVars, EList<VarDeclaration> copyInOutVars, EList<VarDeclaration> srcVars, EList<VarDeclaration> srcVarInOuts) {
        for (With with : srcEvent.getWith()) {
            With withCopy = LibraryElementFactory.eINSTANCE.createWith();
            withCopy.setVariables(InterfaceListCopier.getCopiedVar(copyVars, copyInOutVars, srcVars, srcVarInOuts, with));
            copy.getWith().add((Object)withCopy);
        }
    }

    private static VarDeclaration getCopiedVar(EList<VarDeclaration> copyVars, EList<VarDeclaration> copyInOutVars, EList<VarDeclaration> srcVars, EList<VarDeclaration> srcVarInOuts, With with) {
        VarDeclaration withVar = with.getVariables();
        if (withVar.isInOutVar()) {
            return (VarDeclaration)copyInOutVars.get(srcVarInOuts.indexOf((Object)withVar));
        }
        return (VarDeclaration)copyVars.get(srcVars.indexOf((Object)withVar));
    }

    private static void copyAdapterList(EList<AdapterDeclaration> destAdapters, EList<AdapterDeclaration> srcAdapters, boolean copyComments) {
        srcAdapters.forEach(adapter -> {
            boolean bl2 = destAdapters.add((Object)InterfaceListCopier.copyAdapter(adapter, copyComments));
        });
    }

    public static AdapterDeclaration copyAdapter(AdapterDeclaration adapter, boolean copyComments) {
        AdapterDeclaration copy = LibraryElementFactory.eINSTANCE.createAdapterDeclaration();
        InterfaceListCopier.copyInterfaceElement(adapter, copy, copyComments);
        copy.setAdapterFB((AdapterFB)EcoreUtil.copy((EObject)adapter.getAdapterFB()));
        copy.getAdapterFB().setAdapterDecl(copy);
        copy.setInterfaceOnlyAdapterFB(copy.getAdapterFB());
        return copy;
    }

    public static VarConfigInstance copyVarConfigInstance(VarDeclaration src, String relativeName) {
        VarConfigInstance vci = LibraryElementFactory.eINSTANCE.createVarConfigInstance();
        vci.setName(relativeName);
        vci.setIsInput(src.isIsInput());
        vci.setVisible(src.isVisible());
        vci.setType(src.getType());
        if (src.getValue() != null) {
            vci.setValue((Value)EcoreUtil.copy((EObject)src.getValue()));
        }
        vci.setArraySize(src.getArraySize());
        vci.setComment(src.getComment());
        return vci;
    }

    private InterfaceListCopier() {
        throw new IllegalStateException("InterfaceListCopier is a utility class that can not be instantiated");
    }
}

