/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary;

import java.lang.runtime.SwitchBootstraps;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.notify.impl.SingletonAdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.fordiac.ide.model.ConcurrentNotifierImpl;
import org.eclipse.fordiac.ide.model.IdentifierVerifier;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.buildpath.Attribute;
import org.eclipse.fordiac.ide.model.buildpath.Buildpath;
import org.eclipse.fordiac.ide.model.buildpath.BuildpathAttributes;
import org.eclipse.fordiac.ide.model.buildpath.SourceFolder;
import org.eclipse.fordiac.ide.model.buildpath.util.BuildpathUtil;
import org.eclipse.fordiac.ide.model.errormarker.ErrorMarkerBuilder;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.typelibrary.AdapterTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.AttributeTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.DeviceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.GlobalConstantsEntry;
import org.eclipse.fordiac.ide.model.typelibrary.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SegmentTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SubAppTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SystemEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.model.typelibrary.impl.TypeEntryFactory;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public final class TypeLibrary
extends ConcurrentNotifierImpl {
    public static final String TYPE_ENTRY_NAME_REFERENCES_FEATURE = "TYPE_ENTRY_NAME_REFERENCES_FEATURE";
    public static final int TYPE_ENTRY_NAME_REFERENCES_FEATURE_ID = 1;
    private IProject project;
    private Buildpath buildpath;
    private final DataTypeLibrary dataTypeLib = new DataTypeLibrary();
    private final Map<String, AdapterTypeEntry> adapterTypes = new ConcurrentHashMap<String, AdapterTypeEntry>();
    private final Map<String, AttributeTypeEntry> attributeTypes = new ConcurrentHashMap<String, AttributeTypeEntry>();
    private final Map<String, DeviceTypeEntry> deviceTypes = new ConcurrentHashMap<String, DeviceTypeEntry>();
    private final Map<String, FBTypeEntry> fbTypes = new ConcurrentHashMap<String, FBTypeEntry>();
    private final Map<String, ResourceTypeEntry> resourceTypes = new ConcurrentHashMap<String, ResourceTypeEntry>();
    private final Map<String, SegmentTypeEntry> segmentTypes = new ConcurrentHashMap<String, SegmentTypeEntry>();
    private final Map<String, SubAppTypeEntry> subAppTypes = new ConcurrentHashMap<String, SubAppTypeEntry>();
    private final Map<String, SystemEntry> systems = new ConcurrentHashMap<String, SystemEntry>();
    private final Map<String, GlobalConstantsEntry> globalConstants = new ConcurrentHashMap<String, GlobalConstantsEntry>();
    private final Map<String, TypeEntry> programTypes = new ConcurrentHashMap<String, TypeEntry>();
    private final Map<IFile, TypeEntry> fileMap = new ConcurrentHashMap<IFile, TypeEntry>();
    private final Map<String, AtomicInteger> packages = new ConcurrentHashMap<String, AtomicInteger>();
    private final Queue<TypeEntry> duplicates = new ConcurrentLinkedQueue<TypeEntry>();
    private final NavigableSet<IProject> referencedProjects = new ConcurrentSkipListSet<IProject>(Comparator.comparing(IResource::getName));
    private final TypeLibraryAdapter typeLibraryAdapter = new TypeLibraryAdapter();

    public Stream<AdapterTypeEntry> getAdapterTypes() {
        return this.adapterTypes.values().stream().filter(Predicate.not(TypeEntry::hasError));
    }

    public Stream<AdapterTypeEntry> getAdapterTypesSorted() {
        return this.adapterTypes.values().stream().filter(Predicate.not(TypeEntry::hasError)).sorted((o1, o2) -> Collator.getInstance().compare(o1.getFullTypeName(), o2.getFullTypeName()));
    }

    public Stream<AttributeTypeEntry> getAttributeTypes() {
        return this.attributeTypes.values().stream().filter(Predicate.not(TypeEntry::hasError));
    }

    public Stream<DeviceTypeEntry> getDeviceTypes() {
        return this.deviceTypes.values().stream().filter(Predicate.not(TypeEntry::hasError));
    }

    public Stream<FBTypeEntry> getFbTypes() {
        return this.fbTypes.values().stream().filter(Predicate.not(TypeEntry::hasError));
    }

    public Stream<ResourceTypeEntry> getResourceTypes() {
        return this.resourceTypes.values().stream().filter(Predicate.not(TypeEntry::hasError));
    }

    public Stream<SegmentTypeEntry> getSegmentTypes() {
        return this.segmentTypes.values().stream().filter(Predicate.not(TypeEntry::hasError));
    }

    public Stream<SubAppTypeEntry> getSubAppTypes() {
        return this.subAppTypes.values().stream().filter(Predicate.not(TypeEntry::hasError));
    }

    public Stream<SystemEntry> getSystems() {
        return this.systems.values().stream().filter(Predicate.not(TypeEntry::hasError));
    }

    public Stream<GlobalConstantsEntry> getGlobalConstants() {
        return this.globalConstants.values().stream().filter(Predicate.not(TypeEntry::hasError));
    }

    public Stream<TypeEntry> getProgramTypes() {
        return this.programTypes.values().stream().filter(Predicate.not(TypeEntry::hasError));
    }

    public Set<String> getPackages() {
        return Collections.unmodifiableSet(this.packages.keySet());
    }

    public Stream<TypeEntry> getAllTypes() {
        return this.fileMap.values().stream().filter(Predicate.not(TypeEntry::hasError));
    }

    public Stream<FBTypeEntry> getCompositeFBTypes() {
        return this.fbTypes.values().stream().filter(Predicate.not(TypeEntry::hasError)).filter(entry -> LibraryElementPackage.Literals.COMPOSITE_FB_TYPE.equals(entry.getTypeEClass()));
    }

    public AdapterTypeEntry getAdapterTypeEntry(String typeName) {
        return this.adapterTypes.get(typeName.toLowerCase());
    }

    public AttributeTypeEntry getAttributeTypeEntry(String typeName) {
        return this.attributeTypes.get(typeName.toLowerCase());
    }

    public DeviceTypeEntry getDeviceTypeEntry(String typeName) {
        return this.deviceTypes.get(typeName.toLowerCase());
    }

    public FBTypeEntry getFBTypeEntry(String typeName) {
        return this.fbTypes.get(typeName.toLowerCase());
    }

    public ResourceTypeEntry getResourceTypeEntry(String typeName) {
        return this.resourceTypes.get(typeName.toLowerCase());
    }

    public SegmentTypeEntry getSegmentTypeEntry(String typeName) {
        return this.segmentTypes.get(typeName.toLowerCase());
    }

    public SubAppTypeEntry getSubAppTypeEntry(String typeName) {
        return this.subAppTypes.get(typeName.toLowerCase());
    }

    public SystemEntry getSystemEntry(String name) {
        return this.systems.get(name.toLowerCase());
    }

    public GlobalConstantsEntry getGlobalConstantsEntry(String name) {
        return this.globalConstants.get(name.toLowerCase());
    }

    public TypeEntry getFBOrSubAppType(String typeName) {
        FBTypeEntry fb = this.getFBTypeEntry(typeName);
        return fb != null ? fb : this.getSubAppTypeEntry(typeName);
    }

    public TypeEntry getTypeEntry(IFile typeFile) {
        return this.fileMap.get(typeFile);
    }

    public DataTypeLibrary getDataTypeLibrary() {
        return this.dataTypeLib;
    }

    public IProject getProject() {
        return this.project;
    }

    public Buildpath getBuildpath() {
        return this.buildpath;
    }

    public NavigableSet<IProject> getReferencedProjects() {
        return Collections.unmodifiableNavigableSet(this.referencedProjects);
    }

    TypeLibrary(IProject project) {
        this.project = project;
        this.buildpath = BuildpathUtil.loadBuildpath(project);
        if (project != null && project.isAccessible()) {
            this.checkAdditions();
        }
    }

    public TypeEntry createTypeEntry(IFile file) {
        if (file == null || BuildpathUtil.findSourceFolder(this.buildpath, (IResource)file).isEmpty()) {
            return null;
        }
        return this.fileMap.computeIfAbsent(file, f -> {
            TypeEntry entry = TypeEntryFactory.INSTANCE.createTypeEntry(file);
            if (entry != null) {
                Optional<String> message = IdentifierVerifier.verifyIdentifier(entry.getTypeName());
                if (message.isEmpty()) {
                    entry.setTypeLibrary(this);
                    this.addTypeEntryNameReference(entry);
                    return entry;
                }
                this.createTypeLibraryMarker((IResource)file, message.get());
            }
            return null;
        });
    }

    public TypeEntry createErrorTypeEntry(String typeName, EClass typeClass) {
        TypeEntry entry = TypeEntryFactory.INSTANCE.createTypeEntry(typeClass);
        if (entry == null) {
            throw new IllegalArgumentException("Unknown type class " + typeClass.getName());
        }
        LibraryElement libraryElement = entry.getType();
        PackageNameHelper.setFullTypeName(libraryElement, typeName);
        entry.setType(libraryElement);
        entry.setTypeLibrary(this);
        TypeEntry oldEntry = this.putBlockTypeEntryIfAbsent(entry);
        return oldEntry != null ? oldEntry : entry;
    }

    private TypeEntry removeErrorTypeEntry(TypeEntry entry) {
        TypeEntry oldEntry = this.getBlockTypeEntry(entry);
        while (oldEntry != null && oldEntry.getFile() == null) {
            if (this.removeBlockTypeEntry(oldEntry)) {
                return oldEntry;
            }
            oldEntry = this.getBlockTypeEntry(entry);
        }
        return null;
    }

    public void addTypeEntry(TypeEntry entry) {
        if (entry.getTypeLibrary() != null) {
            entry.getTypeLibrary().removeTypeEntry(entry);
        }
        entry.setTypeLibrary(this);
        if (entry.getFile() != null) {
            this.fileMap.put(entry.getFile(), entry);
        }
        this.addTypeEntryNameReference(entry);
    }

    public void addTypeEntryNameReference(TypeEntry entry) {
        if (entry instanceof DataTypeEntry) {
            DataTypeEntry dtEntry = (DataTypeEntry)entry;
            if (!this.dataTypeLib.addTypeEntry(dtEntry)) {
                this.handleDuplicateTypeName(entry);
            }
        } else {
            TypeEntry oldEntry = this.removeErrorTypeEntry(entry);
            if (!this.addBlockTypeEntry(entry)) {
                this.handleDuplicateTypeName(entry);
            }
            if (oldEntry != null) {
                oldEntry.setTypeLibrary(null);
            }
        }
        if (TypeLibrary.isProgramTypeEntry(entry) && !this.addProgramTypeEntry(entry)) {
            this.handleDuplicateTypeName(entry);
        }
        this.addPackageNameReference(PackageNameHelper.extractPackageName(entry.getFullTypeName()));
        if (this.eNotificationRequired() && this.isPublicNameReference(entry)) {
            this.eNotify((Notification)new TypeLibraryNotificationImpl(this, 3, TYPE_ENTRY_NAME_REFERENCES_FEATURE, 1, null, entry));
        }
    }

    private void handleDuplicateTypeName(TypeEntry entry) {
        if (entry.getFile() != null && entry.getFile().exists()) {
            this.duplicates.add(entry);
            this.createTypeLibraryMarker((IResource)entry.getFile(), MessageFormat.format(Messages.TypeLibrary_TypeExists, entry.getFullTypeName()));
        } else {
            FordiacLogHelper.logWarning((String)MessageFormat.format(Messages.TypeLibrary_TypeExists, entry.getFullTypeName()));
        }
    }

    public void removeTypeEntry(TypeEntry entry) {
        this.removeTypeEntryNameReference(entry);
        if (entry.getFile() != null) {
            this.fileMap.remove(entry.getFile());
        }
        entry.setTypeLibrary(null);
    }

    public void removeTypeEntryNameReference(TypeEntry entry) {
        if (entry instanceof DataTypeEntry) {
            DataTypeEntry dtEntry = (DataTypeEntry)entry;
            this.dataTypeLib.removeTypeEntry(dtEntry);
        } else {
            this.removeBlockTypeEntry(entry);
        }
        if (TypeLibrary.isProgramTypeEntry(entry)) {
            this.removeProgramTypeEntry(entry);
        }
        this.removePackageNameReference(PackageNameHelper.extractPackageName(entry.getFullTypeName()));
        this.deleteTypeLibraryMarkers((IResource)entry.getFile());
        if (this.eNotificationRequired() && this.isPublicNameReference(entry)) {
            this.eNotify((Notification)new TypeLibraryNotificationImpl(this, 4, TYPE_ENTRY_NAME_REFERENCES_FEATURE, 1, entry, null));
        }
        this.retryDuplicates();
    }

    private boolean isPublicNameReference(TypeEntry entry) {
        return entry.getTypeLibrary() == this && Boolean.parseBoolean(BuildpathUtil.findSourceFolder(this.buildpath, (IResource)entry.getFile()).map(SourceFolder::getAttributes).map(attrs -> BuildpathAttributes.getAttributeValue((List<Attribute>)attrs, "export")).orElse(null));
    }

    private void retryDuplicates() {
        this.duplicates.removeIf(this::retryDuplicate);
    }

    private boolean retryDuplicate(TypeEntry entry) {
        if (!this.exists(entry)) {
            return true;
        }
        if (entry instanceof DataTypeEntry) {
            DataTypeEntry dtEntry = (DataTypeEntry)entry;
            if (this.dataTypeLib.addTypeEntry(dtEntry)) {
                this.deleteTypeLibraryMarkers((IResource)entry.getFile());
                return true;
            }
        } else if (this.addBlockTypeEntry(entry)) {
            this.deleteTypeLibraryMarkers((IResource)entry.getFile());
            return true;
        }
        return false;
    }

    protected void addPackageNameReference(String packageName) {
        if (packageName != null && !packageName.isEmpty()) {
            this.packages.computeIfAbsent(packageName.toLowerCase(), key -> new AtomicInteger()).incrementAndGet();
        }
    }

    protected void removePackageNameReference(String packageName) {
        if (packageName != null && !packageName.isEmpty()) {
            this.packages.computeIfPresent(packageName.toLowerCase(), (key, value) -> value.decrementAndGet() > 0 ? value : null);
        }
    }

    protected boolean addProgramTypeEntry(TypeEntry entry) {
        String fullTypeName = entry.getFullTypeName().toLowerCase();
        return this.programTypes.putIfAbsent(fullTypeName, entry) == null;
    }

    protected boolean removeProgramTypeEntry(TypeEntry entry) {
        String fullTypeName = entry.getFullTypeName().toLowerCase();
        return this.programTypes.remove(fullTypeName, entry);
    }

    public void refresh() {
        this.buildpath = BuildpathUtil.loadBuildpath(this.project);
        this.checkDeletions();
        this.checkAdditions();
    }

    private void checkDeletions() {
        this.checkReferencedProjectDeletions();
        this.checkDeletionsForTypeGroup(this.adapterTypes);
        this.checkDeletionsForTypeGroup(this.attributeTypes);
        this.checkDeletionsForTypeGroup(this.deviceTypes);
        this.checkDeletionsForTypeGroup(this.fbTypes);
        this.checkDeletionsForTypeGroup(this.resourceTypes);
        this.checkDeletionsForTypeGroup(this.segmentTypes);
        this.checkDeletionsForTypeGroup(this.subAppTypes);
        this.checkDeletionsForTypeGroup(this.systems);
        this.checkDeletionsForTypeGroup(this.globalConstants);
        this.checkDeletionsForTypeGroup(this.dataTypeLib.getDerivedDataTypes());
        this.fileMap.values().removeIf(Predicate.not(this::exists));
    }

    private void checkDeletionsForTypeGroup(Map<String, ? extends TypeEntry> typeEntries) {
        this.checkDeletionsForTypeGroup(typeEntries.values().stream());
    }

    private void checkDeletionsForTypeGroup(Stream<? extends TypeEntry> typeEntries) {
        typeEntries.filter(Predicate.not(this::exists)).forEachOrdered(this::removeTypeEntry);
    }

    private boolean exists(TypeEntry entry) {
        return entry.getFile() != null && entry.getFile().exists() && BuildpathUtil.findSourceFolder(this.buildpath, (IResource)entry.getFile()).isPresent();
    }

    private void checkAdditions() {
        try {
            this.checkReferencedProjectsAdditions();
            this.checkAdditions((IContainer)this.project);
        }
        catch (CoreException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
    }

    private void checkAdditions(IContainer container) throws CoreException {
        IResource[] members;
        IResource[] iResourceArray = members = container.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFolder) {
                IFolder folder = (IFolder)resource;
                this.checkAdditions((IContainer)folder);
            }
            if (resource instanceof IFile && !this.containsType(file = (IFile)resource)) {
                this.createTypeEntry(file);
            }
            ++n2;
        }
    }

    private void checkReferencedProjectsAdditions() throws CoreException {
        IProject[] iProjectArray = this.project.getReferencedProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject referencedProject = iProjectArray[n2];
            this.addReferencedProject(referencedProject);
            ++n2;
        }
    }

    private void checkReferencedProjectDeletions() {
        HashSet<IProject> currentReferencedProjects = new HashSet<IProject>();
        try {
            currentReferencedProjects.addAll(Arrays.asList(this.project.getReferencedProjects()));
        }
        catch (CoreException e) {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)((Object)e));
        }
        for (IProject referencedProject : this.referencedProjects) {
            if (currentReferencedProjects.contains(referencedProject)) continue;
            this.removeReferencedProject(referencedProject);
        }
    }

    public boolean containsType(IFile file) {
        return this.getTypeEntry(file) != null;
    }

    public TypeEntry find(String name) {
        return this.programTypes.get(name.toLowerCase());
    }

    public List<TypeEntry> findUnqualified(String name) {
        String unqualifiedName = PackageNameHelper.extractPlainTypeName(name);
        return this.programTypes.values().stream().filter(entry -> unqualifiedName.equalsIgnoreCase(entry.getTypeName())).toList();
    }

    private boolean addBlockTypeEntry(TypeEntry entry) {
        return this.putBlockTypeEntryIfAbsent(entry) == null;
    }

    private TypeEntry putBlockTypeEntryIfAbsent(TypeEntry entry) {
        String fullTypeName = entry.getFullTypeName().toLowerCase();
        TypeEntry typeEntry = entry;
        Objects.requireNonNull(typeEntry);
        TypeEntry typeEntry2 = typeEntry;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AdapterTypeEntry.class, AttributeTypeEntry.class, DeviceTypeEntry.class, FBTypeEntry.class, ResourceTypeEntry.class, SegmentTypeEntry.class, SubAppTypeEntry.class, SystemEntry.class, GlobalConstantsEntry.class}, (Object)typeEntry2, 0)) {
            case 0 -> {
                AdapterTypeEntry adpEntry = (AdapterTypeEntry)typeEntry2;
                yield this.adapterTypes.putIfAbsent(fullTypeName, adpEntry);
            }
            case 1 -> {
                AttributeTypeEntry atpEntry = (AttributeTypeEntry)typeEntry2;
                yield this.attributeTypes.putIfAbsent(fullTypeName, atpEntry);
            }
            case 2 -> {
                DeviceTypeEntry devEntry = (DeviceTypeEntry)typeEntry2;
                yield this.deviceTypes.putIfAbsent(fullTypeName, devEntry);
            }
            case 3 -> {
                FBTypeEntry fbtEntry = (FBTypeEntry)typeEntry2;
                yield this.fbTypes.putIfAbsent(fullTypeName, fbtEntry);
            }
            case 4 -> {
                ResourceTypeEntry resEntry = (ResourceTypeEntry)typeEntry2;
                yield this.resourceTypes.putIfAbsent(fullTypeName, resEntry);
            }
            case 5 -> {
                SegmentTypeEntry segEntry = (SegmentTypeEntry)typeEntry2;
                yield this.segmentTypes.putIfAbsent(fullTypeName, segEntry);
            }
            case 6 -> {
                SubAppTypeEntry subAppEntry = (SubAppTypeEntry)typeEntry2;
                yield this.subAppTypes.putIfAbsent(fullTypeName, subAppEntry);
            }
            case 7 -> {
                SystemEntry sysEntry = (SystemEntry)typeEntry2;
                yield this.systems.putIfAbsent(fullTypeName, sysEntry);
            }
            case 8 -> {
                GlobalConstantsEntry globalConstEntry = (GlobalConstantsEntry)typeEntry2;
                yield this.globalConstants.putIfAbsent(fullTypeName, globalConstEntry);
            }
            default -> {
                FordiacLogHelper.logError((String)("Unknown type entry to be added to library: " + entry.getClass().getName()));
                yield null;
            }
        };
    }

    private boolean removeBlockTypeEntry(TypeEntry entry) {
        String fullTypeName = entry.getFullTypeName().toLowerCase();
        TypeEntry typeEntry = entry;
        Objects.requireNonNull(typeEntry);
        TypeEntry typeEntry2 = typeEntry;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AdapterTypeEntry.class, AttributeTypeEntry.class, DeviceTypeEntry.class, FBTypeEntry.class, ResourceTypeEntry.class, SegmentTypeEntry.class, SubAppTypeEntry.class, SystemEntry.class, GlobalConstantsEntry.class}, (Object)typeEntry2, 0)) {
            case 0 -> {
                AdapterTypeEntry adpEntry = (AdapterTypeEntry)typeEntry2;
                yield this.adapterTypes.remove(fullTypeName, adpEntry);
            }
            case 1 -> {
                AttributeTypeEntry atpEntry = (AttributeTypeEntry)typeEntry2;
                yield this.attributeTypes.remove(fullTypeName, atpEntry);
            }
            case 2 -> {
                DeviceTypeEntry devEntry = (DeviceTypeEntry)typeEntry2;
                yield this.deviceTypes.remove(fullTypeName, devEntry);
            }
            case 3 -> {
                FBTypeEntry fbtEntry = (FBTypeEntry)typeEntry2;
                yield this.fbTypes.remove(fullTypeName, fbtEntry);
            }
            case 4 -> {
                ResourceTypeEntry resEntry = (ResourceTypeEntry)typeEntry2;
                yield this.resourceTypes.remove(fullTypeName, resEntry);
            }
            case 5 -> {
                SegmentTypeEntry segEntry = (SegmentTypeEntry)typeEntry2;
                yield this.segmentTypes.remove(fullTypeName, segEntry);
            }
            case 6 -> {
                SubAppTypeEntry subAppEntry = (SubAppTypeEntry)typeEntry2;
                yield this.subAppTypes.remove(fullTypeName, subAppEntry);
            }
            case 7 -> {
                SystemEntry sysEntry = (SystemEntry)typeEntry2;
                yield this.systems.remove(fullTypeName, sysEntry);
            }
            case 8 -> {
                GlobalConstantsEntry globalConstEntry = (GlobalConstantsEntry)typeEntry2;
                yield this.globalConstants.remove(fullTypeName, globalConstEntry);
            }
            default -> {
                FordiacLogHelper.logError((String)("Unknown type entry to be removed from library: " + entry.getClass().getName()));
                yield true;
            }
        };
    }

    private TypeEntry getBlockTypeEntry(TypeEntry entry) {
        String fullTypeName = entry.getFullTypeName().toLowerCase();
        TypeEntry typeEntry = entry;
        Objects.requireNonNull(typeEntry);
        TypeEntry typeEntry2 = typeEntry;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AdapterTypeEntry.class, AttributeTypeEntry.class, DeviceTypeEntry.class, FBTypeEntry.class, ResourceTypeEntry.class, SegmentTypeEntry.class, SubAppTypeEntry.class, SystemEntry.class, GlobalConstantsEntry.class}, (Object)typeEntry2, 0)) {
            case 0 -> {
                AdapterTypeEntry adpEntry = (AdapterTypeEntry)typeEntry2;
                yield this.adapterTypes.get(fullTypeName);
            }
            case 1 -> {
                AttributeTypeEntry atpEntry = (AttributeTypeEntry)typeEntry2;
                yield this.attributeTypes.get(fullTypeName);
            }
            case 2 -> {
                DeviceTypeEntry devEntry = (DeviceTypeEntry)typeEntry2;
                yield this.deviceTypes.get(fullTypeName);
            }
            case 3 -> {
                FBTypeEntry fbtEntry = (FBTypeEntry)typeEntry2;
                yield this.fbTypes.get(fullTypeName);
            }
            case 4 -> {
                ResourceTypeEntry resEntry = (ResourceTypeEntry)typeEntry2;
                yield this.resourceTypes.get(fullTypeName);
            }
            case 5 -> {
                SegmentTypeEntry segEntry = (SegmentTypeEntry)typeEntry2;
                yield this.segmentTypes.get(fullTypeName);
            }
            case 6 -> {
                SubAppTypeEntry subAppEntry = (SubAppTypeEntry)typeEntry2;
                yield this.subAppTypes.get(fullTypeName);
            }
            case 7 -> {
                SystemEntry sysEntry = (SystemEntry)typeEntry2;
                yield this.systems.get(fullTypeName);
            }
            case 8 -> {
                GlobalConstantsEntry globalConstEntry = (GlobalConstantsEntry)typeEntry2;
                yield this.globalConstants.get(fullTypeName);
            }
            default -> {
                FordiacLogHelper.logError((String)("Unknown type entry to be retrieved from library: " + entry.getClass().getName()));
                yield null;
            }
        };
    }

    private boolean addReferencedProject(IProject project) {
        if (!this.referencedProjects.add(project)) {
            return false;
        }
        TypeLibrary referencedTypeLibrary = TypeLibraryManager.INSTANCE.getTypeLibrary(project);
        referencedTypeLibrary.eAdapters().add((Object)this.typeLibraryAdapter);
        referencedTypeLibrary.getAllPublicTypes().forEachOrdered(this::addTypeEntryNameReference);
        return true;
    }

    private boolean removeReferencedProject(IProject project) {
        if (!this.referencedProjects.remove(project)) {
            return false;
        }
        TypeLibrary referencedTypeLibrary = TypeLibraryManager.INSTANCE.getTypeLibrary(project);
        referencedTypeLibrary.eAdapters().remove((Object)this.typeLibraryAdapter);
        referencedTypeLibrary.getAllPublicTypes().forEachOrdered(this::removeTypeEntryNameReference);
        return true;
    }

    private Stream<TypeEntry> getAllPublicTypes() {
        return this.fileMap.values().stream().filter(this::isPublicNameReference);
    }

    private static boolean isProgramTypeEntry(TypeEntry entry) {
        return entry instanceof FBTypeEntry || entry instanceof SubAppTypeEntry || entry instanceof DataTypeEntry;
    }

    private void createTypeLibraryMarker(IResource resource, String message) {
        if (resource != null && this.project.equals((Object)resource.getProject())) {
            FordiacMarkerHelper.createMarkers(resource, List.of(ErrorMarkerBuilder.createErrorMarkerBuilder(message).setType("org.eclipse.fordiac.ide.model.typeLibrary")));
        }
    }

    private void deleteTypeLibraryMarkers(IResource resource) {
        if (resource != null && this.project.equals((Object)resource.getProject())) {
            FordiacMarkerHelper.updateMarkers(resource, "org.eclipse.fordiac.ide.model.typeLibrary", Collections.emptyList(), true);
        }
    }

    void setProject(IProject newProject) {
        this.project = newProject;
    }

    private class TypeLibraryAdapter
    extends SingletonAdapterImpl {
        private TypeLibraryAdapter() {
        }

        public void notifyChanged(Notification msg) {
            TypeLibrary typeLibrary;
            super.notifyChanged(msg);
            Object object = msg.getNotifier();
            if (object instanceof TypeLibrary && TypeLibrary.this.referencedProjects.contains((typeLibrary = (TypeLibrary)object).getProject())) {
                switch (msg.getEventType()) {
                    case 3: {
                        TypeLibrary.this.addTypeEntryNameReference((TypeEntry)msg.getNewValue());
                        break;
                    }
                    case 5: {
                        ((Collection)msg.getNewValue()).stream().map(TypeEntry.class::cast).forEachOrdered(TypeLibrary.this::addTypeEntryNameReference);
                        break;
                    }
                    case 4: {
                        TypeLibrary.this.removeTypeEntryNameReference((TypeEntry)msg.getOldValue());
                        break;
                    }
                    case 6: {
                        ((Collection)msg.getOldValue()).stream().map(TypeEntry.class::cast).forEachOrdered(TypeLibrary.this::removeTypeEntryNameReference);
                        break;
                    }
                }
            }
        }
    }

    private static class TypeLibraryNotificationImpl
    extends NotificationImpl {
        private final TypeLibrary notifier;
        private final String feature;
        private final int featureID;

        public TypeLibraryNotificationImpl(TypeLibrary notifier, int eventType, String feature, int featureID, Object oldValue, Object newValue) {
            super(eventType, oldValue, newValue, -1);
            this.notifier = notifier;
            this.feature = feature;
            this.featureID = featureID;
        }

        public TypeLibrary getNotifier() {
            return this.notifier;
        }

        public Object getFeature() {
            return this.feature;
        }

        public int getFeatureID(Class<?> expectedClass) {
            return this.featureID;
        }
    }
}

