/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.formatting2.FormatterPreferences;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormatter2;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.IPreferenceValuesProvider;
import org.eclipse.xtext.preferences.TypedPreferenceValues;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.serializer.impl.Serializer;

public class STCoreSerializer
extends Serializer {
    @Inject(optional=true)
    private Provider<IFormatter2> formatter2Provider;
    @Inject
    private Provider<FormatterRequest> formatterRequestProvider;
    @Inject(optional=true)
    @FormatterPreferences
    private IPreferenceValuesProvider preferencesProvider;

    protected void serialize(EObject obj, Appendable appendable, SaveOptions options) throws IOException {
        ITextRegionAccess regionAccess = this.serializeToRegions(obj);
        FormatterRequest request = (FormatterRequest)this.formatterRequestProvider.get();
        request.setFormatUndefinedHiddenRegionsOnly(!options.isFormatting());
        request.setTextRegionAccess(regionAccess);
        if (this.preferencesProvider != null) {
            IPreferenceValues preferenceValues = this.preferencesProvider.getPreferenceValues((Resource)regionAccess.getResource());
            request.setPreferences(TypedPreferenceValues.castOrWrap((IPreferenceValues)preferenceValues));
        }
        IFormatter2 formatter2 = (IFormatter2)this.formatter2Provider.get();
        List replacements = formatter2.format(request);
        regionAccess.getRewriter().renderToAppendable((Iterable)replacements, appendable);
    }

    protected int calculateReplaceRegionLength(ICompositeNode node, String text) {
        if (this.hiddenNodeFollows(node) && STCoreSerializer.hasTrailingWhitespace(text)) {
            return node.getTotalLength() + this.getFollowingNode(node).getTotalLength();
        }
        return node.getTotalLength();
    }

    protected static boolean hasTrailingWhitespace(String text) {
        return !text.isEmpty() && Character.isWhitespace(text.codePointBefore(text.length()));
    }
}

