/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.properties;

import java.util.List;
import org.eclipse.fordiac.ide.deployment.interactors.DeviceManagementInteractorFactory;
import org.eclipse.fordiac.ide.gef.commands.ChangeProfileCommand;
import org.eclipse.fordiac.ide.gef.properties.AbstractInterfaceSection;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.systemconfiguration.Messages;
import org.eclipse.fordiac.ide.ui.widget.ComboBoxWidgetFactory;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class DeviceSection
extends AbstractInterfaceSection {
    private static String[] profileNames;
    private CCombo profile;

    protected void performRefresh() {
        super.performRefresh();
        this.setProfile();
    }

    private void setProfile() {
        int i = 0;
        String[] stringArray = this.profile.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (p.equals(((Device)this.getType()).getProfile())) {
                this.profile.select(i);
                break;
            }
            ++i;
            ++n2;
        }
    }

    protected Device getInputType(Object input) {
        if (input instanceof EditPart) {
            EditPart ep = (EditPart)input;
            input = ep.getModel();
        }
        if (input instanceof Device) {
            Device dev = (Device)input;
            return dev;
        }
        return null;
    }

    protected void createInfoGroup(Composite container) {
        super.createInfoGroup(container);
        this.getWidgetFactory().createCLabel(container, Messages.DeviceSection_Profile + ":");
        this.profile = ComboBoxWidgetFactory.createCombo((TabbedPropertySheetWidgetFactory)this.getWidgetFactory(), (Composite)container);
        this.profile.addListener(13, event -> {
            this.removeContentAdapter();
            this.executeCommand((Command)new ChangeProfileCommand((Device)this.getType(), this.profile.getText()));
            this.refresh();
            this.addContentAdapter();
        });
        this.profile.setItems(DeviceSection.getAvailableProfileNames());
    }

    protected static String[] getAvailableProfileNames() {
        if (profileNames == null) {
            List newProfileNames = DeviceManagementInteractorFactory.INSTANCE.getAvailableProfileNames();
            profileNames = newProfileNames.toArray(new String[newProfileNames.size()]);
        }
        return profileNames;
    }
}

