/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.interpreter;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.OptionalInt;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.interpreter.IConverter;

public class DefaultConverter
implements IConverter {
    @Override
    public Optional<Boolean> toBoolean(Object rawValue) {
        String toString;
        boolean result = rawValue == null ? false : (rawValue instanceof Boolean ? (Boolean)rawValue : ("true".equalsIgnoreCase(toString = rawValue.toString()) ? true : !"false".equalsIgnoreCase(toString)));
        return Optional.of(result);
    }

    @Override
    public Optional<EObject> toEObject(Object rawValue) {
        if (rawValue instanceof EObject) {
            return Optional.of((EObject)rawValue);
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> toString(Object rawValue) {
        if (rawValue != null) {
            return Optional.of(String.valueOf(rawValue));
        }
        return Optional.empty();
    }

    @Override
    public OptionalInt toInt(Object rawValue) {
        try {
            return OptionalInt.of(Integer.parseInt(String.valueOf(rawValue)));
        }
        catch (NumberFormatException numberFormatException) {
            return OptionalInt.empty();
        }
    }

    @Override
    public Optional<Collection<EObject>> toEObjectCollection(Object rawValue) {
        Collection<Object> result = rawValue instanceof Collection ? Lists.newArrayList((Iterable)Iterables.filter((Iterable)((Collection)rawValue), EObject.class)) : (rawValue instanceof EObject ? Collections.singleton((EObject)rawValue) : (rawValue != null && rawValue.getClass().isArray() ? Lists.newArrayList((Iterable)Iterables.filter((Iterable)Lists.newArrayList((Object[])((Object[])rawValue)), EObject.class)) : Collections.emptySet()));
        return Optional.of(result);
    }
}

