/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class FileStatesPage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private static final int FAILED_VALUE = -1;
    private static final long DAY_LENGTH = 86400000L;
    private static final long MEGABYTES = 0x100000L;
    private Text longevityText;
    private Text maxStatesText;
    private Text maxStateSizeText;
    private Button applyPolicyButton;
    private Button keepDerivedStateButton;
    private final ArrayList<Control> dependentControls = new ArrayList();
    private final int FILE_STATES_MAXIMUM = 10000;
    private final long STATE_SIZE_MAXIMUM = 100L;
    private static final int INDENT = 20;

    private Text addDependentLabelAndText(String labelString, String textValue, Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(labelString);
        this.dependentControls.add((Control)label);
        Text text = new Text(parent, 18432);
        GridData data = new GridData();
        text.addListener(24, (Listener)this);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        text.setLayoutData((Object)data);
        text.setText(textValue);
        this.dependentControls.add((Control)text);
        return text;
    }

    private Button addCheckBox(String label, boolean selected, Composite parent) {
        Button button = new Button(parent, 16416);
        button.addListener(13, (Listener)this);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalIndent = -20;
        button.setLayoutData((Object)data);
        button.setText(label);
        button.setSelection(selected);
        return button;
    }

    private void checkState() {
        if (this.longevityText == null || this.maxStatesText == null || this.maxStateSizeText == null || this.applyPolicyButton == null || this.keepDerivedStateButton == null) {
            this.setValid(false);
            return;
        }
        boolean newState = this.applyPolicyButton.getSelection();
        Iterator<Control> iter = this.dependentControls.iterator();
        while (iter.hasNext()) {
            iter.next().setEnabled(newState);
        }
        if (this.validateLongTextEntry(this.longevityText, 86400000L) == -1L) {
            this.setValid(false);
            return;
        }
        if (this.validateMaxFileStates() == -1) {
            this.setValid(false);
            return;
        }
        if (this.validateMaxFileStateSize() == -1L) {
            this.setValid(false);
            return;
        }
        this.setValid(true);
        this.setErrorMessage(null);
    }

    protected Control createContents(Composite parent) {
        long megabytes;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.ide.file_states_preference_page_context");
        IWorkspaceDescription description = this.getWorkspaceDescription();
        long days = description.getFileStateLongevity() / 86400000L;
        if (days < 1L) {
            days = 1L;
        }
        if ((megabytes = description.getMaxFileStateSize() / 0x100000L) < 1L) {
            megabytes = 1L;
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginLeft = 20;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.keepDerivedStateButton = this.addCheckBox(IDEWorkbenchMessages.FileHistory_keepDerivedState, description.isKeepDerivedState(), composite);
        this.applyPolicyButton = this.addCheckBox(IDEWorkbenchMessages.FileHistory_applyPolicy, description.isApplyFileStatePolicy(), composite);
        this.longevityText = this.addDependentLabelAndText(IDEWorkbenchMessages.FileHistory_longevity, String.valueOf(days), composite);
        this.maxStatesText = this.addDependentLabelAndText(IDEWorkbenchMessages.FileHistory_entries, String.valueOf(description.getMaxFileStates()), composite);
        this.maxStateSizeText = this.addDependentLabelAndText(IDEWorkbenchMessages.FileHistory_diskSpace, String.valueOf(megabytes), composite);
        this.checkState();
        Label spacer = new Label(composite, 0);
        GridData spacerData = new GridData();
        spacerData.horizontalSpan = 2;
        spacer.setLayoutData((Object)spacerData);
        Composite noteComposite = this.createNoteComposite(parent.getFont(), composite, IDEWorkbenchMessages.Preference_note, IDEWorkbenchMessages.FileHistory_restartNote);
        GridData noteData = new GridData();
        noteData.horizontalSpan = 2;
        noteComposite.setLayoutData((Object)noteData);
        this.dependentControls.addAll(Arrays.asList(noteComposite.getChildren()));
        this.applyDialogFont(composite);
        return composite;
    }

    private IWorkspaceDescription getWorkspaceDescription() {
        return ResourcesPlugin.getWorkspace().getDescription();
    }

    public void handleEvent(Event event) {
        this.checkState();
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        Preferences prefs = ResourcesPlugin.getPlugin().getPluginPreferences();
        long days = prefs.getDefaultLong("description.filestatelongevity") / 86400000L;
        long megabytes = prefs.getDefaultLong("description.maxfilestatesize") / 0x100000L;
        this.longevityText.setText(String.valueOf(days));
        this.maxStatesText.setText(prefs.getDefaultString("description.maxfilestates"));
        this.maxStateSizeText.setText(String.valueOf(megabytes));
        this.keepDerivedStateButton.setSelection(prefs.getDefaultBoolean("description.keepDerivedState"));
        this.applyPolicyButton.setSelection(prefs.getDefaultBoolean("description.applyfilestatepolicy"));
        this.checkState();
    }

    public boolean performOk() {
        long longevityValue = this.validateLongTextEntry(this.longevityText, 86400000L);
        int maxFileStates = this.validateMaxFileStates();
        long maxStateSize = this.validateMaxFileStateSize();
        boolean keepDerivedState = this.keepDerivedStateButton.getSelection();
        boolean applyPolicy = this.applyPolicyButton.getSelection();
        if (longevityValue == -1L || maxFileStates == -1 || maxStateSize == -1L) {
            return false;
        }
        IWorkspaceDescription description = this.getWorkspaceDescription();
        description.setFileStateLongevity(longevityValue * 86400000L);
        description.setMaxFileStates(maxFileStates);
        description.setMaxFileStateSize(maxStateSize * 0x100000L);
        description.setKeepDerivedState(keepDerivedState);
        description.setApplyFileStatePolicy(applyPolicy);
        try {
            ResourcesPlugin.getWorkspace().setDescription(description);
        }
        catch (CoreException exception) {
            ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.FileHistory_exceptionSaving, (String)exception.getMessage(), (IStatus)exception.getStatus());
            return false;
        }
        return true;
    }

    private int validateIntegerTextEntry(Text text) {
        int value;
        try {
            value = Integer.parseInt(text.getText());
        }
        catch (NumberFormatException exception) {
            this.setErrorMessage(MessageFormat.format(IDEWorkbenchMessages.FileHistory_invalid, exception.getLocalizedMessage()));
            return -1;
        }
        if (value <= 0) {
            this.setErrorMessage(IDEWorkbenchMessages.FileHistory_mustBePositive);
            return -1;
        }
        return value;
    }

    private long validateLongTextEntry(Text text, long scale) {
        long value;
        try {
            String string = text.getText();
            value = Long.parseLong(string);
            if (value * scale / scale != value) {
                throw new NumberFormatException(string);
            }
        }
        catch (NumberFormatException exception) {
            this.setErrorMessage(MessageFormat.format(IDEWorkbenchMessages.FileHistory_invalid, exception.getLocalizedMessage()));
            return -1L;
        }
        if (value <= 0L) {
            this.setErrorMessage(IDEWorkbenchMessages.FileHistory_mustBePositive);
            return -1L;
        }
        return value;
    }

    private int validateMaxFileStates() {
        int maxFileStates = this.validateIntegerTextEntry(this.maxStatesText);
        if (maxFileStates == -1) {
            return maxFileStates;
        }
        if (maxFileStates > 10000) {
            this.setErrorMessage(NLS.bind((String)IDEWorkbenchMessages.FileHistory_aboveMaxEntries, (Object)String.valueOf(10000)));
            return -1;
        }
        return maxFileStates;
    }

    private long validateMaxFileStateSize() {
        long maxFileStateSize = this.validateLongTextEntry(this.maxStateSizeText, 0x100000L);
        if (maxFileStateSize == -1L) {
            return maxFileStateSize;
        }
        if (maxFileStateSize > 100L) {
            this.setErrorMessage(NLS.bind((String)IDEWorkbenchMessages.FileHistory_aboveMaxFileSize, (Object)String.valueOf(100L)));
            return -1L;
        }
        return maxFileStateSize;
    }
}

