/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.evaluation;

import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.VisibilityKind;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluator;
import org.eclipse.acceleo.query.AQLUtils;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.impl.NullValue;
import org.eclipse.acceleo.query.runtime.impl.namespace.AbstractQualifiedNameService;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameLookupEngine;

public abstract class AbstractModuleElementService<O extends ModuleElement>
extends AbstractQualifiedNameService<O> {
    private final IService.Visibility visibility;
    private final AcceleoEvaluator evaluator;
    private final String shortSignature;

    public AbstractModuleElementService(O moduleElement, AcceleoEvaluator evaluator, IQualifiedNameLookupEngine lookupEngine, String contextQualifiedName) {
        super(moduleElement, lookupEngine, contextQualifiedName);
        this.visibility = this.getVisibility(moduleElement);
        this.evaluator = evaluator;
        if (lookupEngine != null) {
            List parameterTypes = this.getParameterTypes((IReadOnlyQueryEnvironment)lookupEngine.getQueryEnvironment());
            Object[] argumentTypes = parameterTypes.toArray(new Object[parameterTypes.size()]);
            this.shortSignature = this.serviceShortSignature(argumentTypes);
        } else {
            this.shortSignature = "";
        }
    }

    protected IService.Visibility getVisibility(VisibilityKind visibilityKind) {
        return switch (visibilityKind) {
            case VisibilityKind.PRIVATE -> IService.Visibility.PRIVATE;
            case VisibilityKind.PROTECTED -> IService.Visibility.PROTECTED;
            case VisibilityKind.PUBLIC -> IService.Visibility.PUBLIC;
            default -> IService.Visibility.PUBLIC;
        };
    }

    protected AcceleoEvaluator getEvaluator() {
        return this.evaluator;
    }

    protected abstract IService.Visibility getVisibility(O var1);

    public IService.Visibility getVisibility() {
        return this.visibility;
    }

    public String getShortSignature() {
        return this.shortSignature;
    }

    public String getLongSignature() {
        String namespace = this.getContextQualifiedName();
        if (namespace != null) {
            return namespace + "::" + this.getShortSignature();
        }
        return this.getShortSignature();
    }

    public int getPriority() {
        return 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof AbstractModuleElementService && this.getOrigin() == ((AbstractModuleElementService)((Object)obj)).getOrigin();
    }

    public int hashCode() {
        return ((ModuleElement)this.getOrigin()).hashCode();
    }

    protected Object getArgumentValue(Variable variable, Object value) {
        Object res;
        if (value == null) {
            Set types = AQLUtils.getTypes((IReadOnlyQueryEnvironment)this.getLookupEngine().getQueryEnvironment(), (TypeLiteral)((TypeLiteral)variable.getTypeAql()));
            res = new NullValue(types);
        } else {
            res = value;
        }
        return res;
    }
}

