/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.debug.util;

import org.eclipse.acceleo.debug.IDSLDebugger;
import org.eclipse.emf.ecore.EObject;

public class ThreadController {
    private final IDSLDebugger debugger;
    private final Long threadID;
    private int lastSuspendedInstructionDepth;
    private boolean suspended;
    private boolean terminated;
    private IDSLDebugger.Stepping stepping = IDSLDebugger.Stepping.NONE;
    private boolean wasSignalled;

    public ThreadController(IDSLDebugger debugger, Long threadID) {
        this.debugger = debugger;
        this.threadID = threadID;
    }

    public void suspend() {
        this.suspended = true;
        this.stepping = IDSLDebugger.Stepping.NONE;
    }

    public synchronized void resume() {
        this.suspended = false;
        this.stepping = IDSLDebugger.Stepping.NONE;
        this.wakeUp();
    }

    public synchronized void terminate() {
        this.terminated = true;
        this.suspended = false;
        this.stepping = IDSLDebugger.Stepping.NONE;
        this.wakeUp();
    }

    public synchronized void stepInto() {
        this.suspended = false;
        this.stepping = IDSLDebugger.Stepping.STEP_INTO;
        this.wakeUp();
    }

    public synchronized void stepOver() {
        this.suspended = false;
        this.stepping = IDSLDebugger.Stepping.STEP_OVER;
        this.wakeUp();
    }

    public synchronized void stepReturn() {
        this.suspended = false;
        this.stepping = IDSLDebugger.Stepping.STEP_RETURN;
        this.wakeUp();
    }

    public synchronized void wakeUp() {
        this.wasSignalled = true;
        this.notify();
    }

    public synchronized void putAsleep() {
        while (!this.wasSignalled) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.wasSignalled = false;
    }

    public synchronized boolean control(EObject instruction) {
        boolean res;
        boolean bl = res = !this.debugger.isTerminated() && !this.terminated;
        if (res) {
            if (this.suspended) {
                this.debugger.suspended(this.threadID);
                this.putAsleep();
                if (!this.debugger.isTerminated() && !this.terminated) {
                    this.resuming(instruction);
                }
            } else if (this.debugger.shouldBreak(instruction)) {
                this.debugger.breaked(this.threadID);
                this.putAsleep();
                if (!this.debugger.isTerminated() && !this.terminated) {
                    this.resuming(instruction);
                }
            } else if (this.stepping != IDSLDebugger.Stepping.NONE && this.shouldStep()) {
                this.debugger.stepped(this.threadID);
                this.putAsleep();
                if (!this.debugger.isTerminated() && !this.terminated) {
                    this.resuming(instruction);
                }
            }
        }
        return res;
    }

    private boolean shouldStep() {
        int currentInstructionDepth = this.debugger.getStackFrame(this.threadID).size();
        return switch (this.stepping) {
            case IDSLDebugger.Stepping.STEP_INTO -> true;
            case IDSLDebugger.Stepping.STEP_OVER -> currentInstructionDepth <= this.lastSuspendedInstructionDepth;
            case IDSLDebugger.Stepping.STEP_RETURN -> currentInstructionDepth < this.lastSuspendedInstructionDepth;
            default -> false;
        };
    }

    private void resuming(EObject instruction) {
        this.lastSuspendedInstructionDepth = this.debugger.getStackFrame(this.threadID).size();
        switch (this.stepping) {
            case STEP_INTO: {
                this.debugger.steppingInto(this.threadID);
                break;
            }
            case STEP_OVER: {
                this.debugger.steppingOver(this.threadID);
                break;
            }
            case STEP_RETURN: {
                this.debugger.steppingReturn(this.threadID);
                break;
            }
            default: {
                if (!this.terminated) {
                    this.debugger.resuming(this.threadID);
                    break;
                }
                this.debugger.terminated(this.threadID);
            }
        }
    }
}

