/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.model.common.command;

import java.util.Collection;
import java.util.Collections;
import org.apache.axis.model.common.CommonPlugin;
import org.apache.axis.model.common.command.AbstractCommand;
import org.apache.axis.model.common.command.Command;

public class CommandWrapper
extends AbstractCommand {
    protected Command command;

    public CommandWrapper(Command command) {
        super(command.getLabel(), command.getDescription());
        this.command = command;
    }

    protected CommandWrapper(String label, Command command) {
        super(label, command.getDescription());
        this.command = command;
    }

    public CommandWrapper(String label, String description, Command command) {
        super(label, description);
        this.command = command;
    }

    protected CommandWrapper() {
    }

    protected CommandWrapper(String label) {
        super(label);
    }

    protected CommandWrapper(String label, String description) {
        super(label, description);
    }

    public Command getCommand() {
        return this.command;
    }

    protected Command createCommand() {
        return null;
    }

    protected boolean prepare() {
        if (this.command == null) {
            this.command = this.createCommand();
        }
        boolean result = this.command.canExecute();
        return result;
    }

    public void execute() {
        if (this.command != null) {
            this.command.execute();
        }
    }

    public boolean canUndo() {
        return this.command == null || this.command.canUndo();
    }

    public void undo() {
        if (this.command != null) {
            this.command.undo();
        }
    }

    public void redo() {
        if (this.command != null) {
            this.command.redo();
        }
    }

    public Collection getResult() {
        return this.command == null ? Collections.EMPTY_LIST : this.command.getResult();
    }

    public Collection getAffectedObjects() {
        return this.command == null ? Collections.EMPTY_LIST : this.command.getAffectedObjects();
    }

    public String getLabel() {
        return this.label == null ? (this.command == null ? CommonPlugin.INSTANCE.getString("_UI_CommandWrapper_label") : this.command.getLabel()) : this.label;
    }

    public String getDescription() {
        return this.description == null ? (this.command == null ? CommonPlugin.INSTANCE.getString("_UI_CommandWrapper_description") : this.command.getDescription()) : this.description;
    }

    public void dispose() {
        if (this.command != null) {
            this.command.dispose();
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (command: " + this.command + ")");
        return result.toString();
    }
}

