/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.catalog.XPLAINScanPropsDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.util.ArrayUtil;

public class RealHashTableStatistics
extends RealNoPutResultSetStatistics {
    public int hashtableSize;
    public int[] hashKeyColumns;
    public String isolationLevel;
    public String nextQualifiers;
    public FormatableProperties scanProperties;
    public ResultSetStatistics childResultSetStatistics;
    public ResultSetStatistics[] subqueryTrackingArray;

    public RealHashTableStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, int hashtableSize, int[] hashKeyColumns, String nextQualifiers, Properties scanProperties, double optimizerEstimatedRowCount, double optimizerEstimatedCost, ResultSetStatistics[] subqueryTrackingArray, ResultSetStatistics childResultSetStatistics) {
        super(numOpens, rowsSeen, rowsFiltered, constructorTime, openTime, nextTime, closeTime, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.hashtableSize = hashtableSize;
        this.hashKeyColumns = ArrayUtil.copy(hashKeyColumns);
        this.nextQualifiers = nextQualifiers;
        this.scanProperties = new FormatableProperties();
        if (scanProperties != null) {
            Enumeration<Object> e = scanProperties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.scanProperties.put(key, scanProperties.get(key));
            }
        }
        this.subqueryTrackingArray = ArrayUtil.copy(subqueryTrackingArray);
        this.childResultSetStatistics = childResultSetStatistics;
    }

    @Override
    public String getStatementExecutionPlanText(int depth) {
        String hashKeyColumnString;
        int index;
        Object subqueryInfo = "";
        this.initFormatInfo(depth);
        if (this.subqueryTrackingArray != null) {
            boolean foundAttached = false;
            for (index = 0; index < this.subqueryTrackingArray.length; ++index) {
                if (this.subqueryTrackingArray[index] == null) continue;
                if (!foundAttached) {
                    subqueryInfo = this.indent + MessageService.getTextMessage("43X56.U", new Object[0]) + ":\n";
                    foundAttached = true;
                }
                subqueryInfo = (String)subqueryInfo + this.subqueryTrackingArray[index].getStatementExecutionPlanText(this.sourceDepth);
            }
        }
        this.initFormatInfo(depth);
        if (this.hashKeyColumns.length == 1) {
            hashKeyColumnString = MessageService.getTextMessage("43X53.U", new Object[0]) + " " + this.hashKeyColumns[0];
        } else {
            hashKeyColumnString = MessageService.getTextMessage("43X54.U", new Object[0]) + " (" + this.hashKeyColumns[0];
            for (index = 1; index < this.hashKeyColumns.length; ++index) {
                hashKeyColumnString = hashKeyColumnString + "," + this.hashKeyColumns[index];
            }
            hashKeyColumnString = hashKeyColumnString + ")";
        }
        return this.indent + MessageService.getTextMessage("43X57.U", new Object[0]) + " (" + this.resultSetNumber + "):\n" + this.indent + MessageService.getTextMessage("43X03.U", new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X31.U", new Object[0]) + " = " + this.hashtableSize + "\n" + this.indent + hashKeyColumnString + "\n" + this.indent + MessageService.getTextMessage("43X04.U", new Object[0]) + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage("43X32.U", new Object[0]) + " = " + this.rowsFiltered + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + (String)(this.rowsSeen > 0 ? this.subIndent + MessageService.getTextMessage("43X33.U", new Object[0]) + " = " + this.nextTime / (long)this.rowsSeen + "\n" : "") + "\n" + this.subIndent + MessageService.getTextMessage("43X37.U", new Object[0]) + ":\n" + this.nextQualifiers + "\n" + this.indent + MessageService.getTextMessage("43X05.U", new Object[0]) + ":\n" + this.childResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth);
    }

    @Override
    public String getScanStatisticsText(String tableName, int depth) {
        if (tableName == null) {
            return this.getStatementExecutionPlanText(depth);
        }
        return null;
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public String getNodeOn() {
        return "";
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage("43X58.U", new Object[0]);
    }

    @Override
    public void accept(XPLAINVisitor visitor) {
        int noChildren = 0;
        if (this.childResultSetStatistics != null) {
            ++noChildren;
        }
        if (this.subqueryTrackingArray != null) {
            noChildren += this.subqueryTrackingArray.length;
        }
        visitor.setNumberOfChildren(noChildren);
        visitor.visit(this);
        if (this.childResultSetStatistics != null) {
            this.childResultSetStatistics.accept(visitor);
        }
        if (this.subqueryTrackingArray != null) {
            boolean foundAttached = false;
            for (int index = 0; index < this.subqueryTrackingArray.length; ++index) {
                if (this.subqueryTrackingArray[index] == null) continue;
                this.subqueryTrackingArray[index].accept(visitor);
            }
        }
    }

    @Override
    public String getRSXplainType() {
        return "HASHTABLE";
    }

    @Override
    public String getRSXplainDetails() {
        return "(" + this.resultSetNumber + ")";
    }

    @Override
    public Object getScanPropsDescriptor(Object scanPropsID) {
        FormatableProperties props = this.scanProperties;
        String isoLevel = XPLAINUtil.getIsolationLevelCode(this.isolationLevel);
        String hashkey_columns = XPLAINUtil.getHashKeyColumnNumberString(this.hashKeyColumns);
        XPLAINScanPropsDescriptor scanRSDescriptor = new XPLAINScanPropsDescriptor((UUID)scanPropsID, "Temporary HashTable", null, null, isoLevel, null, null, null, null, null, null, null, null, null, null, null, this.nextQualifiers, hashkey_columns, this.hashtableSize);
        return XPLAINUtil.extractScanProps(scanRSDescriptor, props);
    }
}

