/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.command;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.ChildrenToCopyProvider;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.CreateCopyCommand;
import org.eclipse.emf.mapping.MappedObjectState;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.emf.mapping.domain.MappingDomain;

public class CreateCopyOverrideCommand
extends AbstractCommand
implements ChildrenToCopyProvider {
    protected MappingDomain mappingDomain;
    protected EObject owner;
    protected EObject copy;
    protected CopyCommand.Helper copyHelper;

    public CreateCopyOverrideCommand(MappingDomain domain, CreateCopyCommand createCommand) {
        super(createCommand.doGetLabel(), createCommand.doGetDescription());
        this.mappingDomain = domain;
        this.owner = createCommand.getOwner();
        this.copyHelper = createCommand.getCopyHelper();
    }

    protected boolean prepare() {
        return true;
    }

    public void execute() {
        EClass outputType = (EClass)this.mappingDomain.getOutputMetaObject((EObject)this.owner.eClass());
        if (outputType != null) {
            MappedObjectState mappedObjectState;
            this.copy = outputType.getEPackage().getEFactoryInstance().create(outputType);
            this.copyHelper.put(this.owner, this.copy);
            MappingRoot mappingRoot = this.mappingDomain.getMappingRoot();
            if (mappingRoot.isInputObject(this.owner) && (mappedObjectState = mappingRoot.getMappedObjectState(this.copy)) != null) {
                mappedObjectState.setOriginatingInput(this.owner);
            }
        }
    }

    public void undo() {
        this.copyHelper.remove((Object)this.owner);
    }

    public void redo() {
        this.copyHelper.put(this.owner, this.copy);
    }

    public Collection<?> getResult() {
        return Collections.singleton(this.copy);
    }

    public Collection<?> getChildrenToCopy() {
        return this.mappingDomain.getChildren(this.owner);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (mappingDomain: " + this.mappingDomain + ")");
        result.append(" (owner: " + this.owner + ")");
        result.append(" (copy: " + this.copy + ")");
        result.append(" (copyHelper: " + this.copyHelper + ")");
        return result.toString();
    }
}

