/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.WrapperConfigFile;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.impl.LUWDatabaseImpl;

public class ServerKindsConfig {
    private Hashtable libnameToWrapperid = null;
    private Hashtable wrapperidToName = null;
    private Hashtable nameToWrapperid = null;
    private Hashtable nameToDescription = null;
    private Hashtable nameToLibname = null;
    private Hashtable allWCFiles = null;

    public void init(LUWDatabaseImpl aDatabase) throws Exception {
        Hashtable wcFiles;
        this.allWCFiles = wcFiles = WrapperConfigFile.initAllFiles(aDatabase);
        Set keys = wcFiles.keySet();
        Iterator iterKeys = keys.iterator();
        this.libnameToWrapperid = new Hashtable();
        this.wrapperidToName = new Hashtable();
        this.nameToWrapperid = new Hashtable();
        this.nameToDescription = new Hashtable();
        this.nameToLibname = new Hashtable();
        while (iterKeys.hasNext()) {
            String wrapperid = (String)iterKeys.next();
            WrapperConfigFile wcf = (WrapperConfigFile)wcFiles.get(wrapperid);
            String libname = wcf.getLibname();
            if (libname.length() <= 0) continue;
            this.libnameToWrapperid.put(libname, wrapperid);
            Hashtable sk = wcf.getServerKinds();
            if (sk.isEmpty()) continue;
            for (String skName : sk.keySet()) {
                String description = (String)sk.get(skName);
                this.nameToDescription.put(skName, description);
                this.wrapperidToName.put(wrapperid, skName);
                this.nameToWrapperid.put(skName, wrapperid);
                this.nameToLibname.put(skName, libname);
            }
        }
    }

    public Enumeration getServerKinds() throws Exception {
        return this.nameToDescription.keys();
    }

    public String getWrapperID(String libName) throws Exception {
        return (String)this.libnameToWrapperid.get(libName);
    }

    public String getLibname(String serverKindName) throws Exception {
        return (String)this.nameToLibname.get(serverKindName);
    }

    public String getServerKindName(String wrapperID) throws Exception {
        return (String)this.wrapperidToName.get(wrapperID);
    }

    public String getDescription(String serverKindName) throws Exception {
        return (String)this.nameToDescription.get(serverKindName);
    }

    public Hashtable getAllWCF() {
        return this.allWCFiles;
    }

    public Enumeration getAllWrapperIDs() throws Exception {
        return this.wrapperidToName.keys();
    }
}

