/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.text.html;

import java.util.Map;
import java.util.Properties;
import org.openpdf.text.DocListener;
import org.openpdf.text.DocumentException;
import org.openpdf.text.Element;
import org.openpdf.text.ExceptionConverter;
import org.openpdf.text.html.HtmlPeer;
import org.openpdf.text.html.HtmlTagMap;
import org.openpdf.text.pdf.BaseFont;
import org.openpdf.text.xml.SAXiTextHandler;
import org.xml.sax.Attributes;

@Deprecated(since="2.1.0")
public class SAXmyHtmlHandler
extends SAXiTextHandler<HtmlPeer> {
    private final Properties bodyAttributes = new Properties();
    private boolean tableBorder = false;

    public SAXmyHtmlHandler(DocListener document) {
        this(document, new HtmlTagMap());
    }

    public SAXmyHtmlHandler(DocListener document, HtmlTagMap htmlTags) {
        this(document, htmlTags, (BaseFont)null);
    }

    public SAXmyHtmlHandler(DocListener document, HtmlTagMap htmlTags, BaseFont bf) {
        super(document, htmlTags, bf);
    }

    public SAXmyHtmlHandler(DocListener document, BaseFont bf) {
        this(document, new HtmlTagMap(), bf);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attrs) {
        String lowerCaseName = name.toLowerCase();
        if (HtmlTagMap.isHtml(lowerCaseName)) {
            return;
        }
        if (HtmlTagMap.isHead(lowerCaseName)) {
            return;
        }
        if (HtmlTagMap.isTitle(lowerCaseName)) {
            return;
        }
        if (HtmlTagMap.isMeta(lowerCaseName)) {
            String meta = null;
            String content = null;
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String attribute = attrs.getQName(i);
                    if (attribute.equalsIgnoreCase("content")) {
                        content = attrs.getValue(i);
                        continue;
                    }
                    if (!attribute.equalsIgnoreCase("name")) continue;
                    meta = attrs.getValue(i);
                }
            }
            if (meta != null && content != null) {
                this.bodyAttributes.put(meta, content);
            }
            return;
        }
        if (HtmlTagMap.isLink(lowerCaseName)) {
            return;
        }
        if (HtmlTagMap.isBody(lowerCaseName)) {
            HtmlPeer peer = new HtmlPeer("itext", lowerCaseName);
            peer.addAlias("top", "topmargin");
            peer.addAlias("bottom", "bottommargin");
            peer.addAlias("right", "rightmargin");
            peer.addAlias("left", "leftmargin");
            this.bodyAttributes.putAll((Map<?, ?>)peer.getAttributes(attrs));
            this.handleStartingTags(peer.getTag(), this.bodyAttributes);
            return;
        }
        if (this.myTags.containsKey(lowerCaseName)) {
            HtmlPeer peer = (HtmlPeer)this.myTags.get(lowerCaseName);
            if ("table".equals(peer.getTag()) || "cell".equals(peer.getTag())) {
                String value;
                Properties p = peer.getAttributes(attrs);
                if ("table".equals(peer.getTag()) && (value = p.getProperty("borderwidth")) != null && Float.parseFloat(value + "f") > 0.0f) {
                    this.tableBorder = true;
                }
                if (this.tableBorder) {
                    p.put("left", String.valueOf(true));
                    p.put("right", String.valueOf(true));
                    p.put("top", String.valueOf(true));
                    p.put("bottom", String.valueOf(true));
                }
                this.handleStartingTags(peer.getTag(), p);
                return;
            }
            this.handleStartingTags(peer.getTag(), peer.getAttributes(attrs));
            return;
        }
        Properties attributes = new Properties();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attribute = attrs.getQName(i).toLowerCase();
                attributes.setProperty(attribute, attrs.getValue(i).toLowerCase());
            }
        }
        this.handleStartingTags(lowerCaseName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String name) {
        String lowerCaseName = name.toLowerCase();
        if ("paragraph".equals(lowerCaseName)) {
            try {
                this.document.add((Element)this.stack.pop());
                return;
            }
            catch (DocumentException e) {
                throw new ExceptionConverter(e);
            }
        }
        if (HtmlTagMap.isHead(lowerCaseName)) {
            return;
        }
        if (HtmlTagMap.isTitle(lowerCaseName)) {
            if (this.currentChunk != null) {
                this.bodyAttributes.put("title", this.currentChunk.getContent());
                this.currentChunk = null;
            }
            return;
        }
        if (HtmlTagMap.isMeta(lowerCaseName)) {
            return;
        }
        if (HtmlTagMap.isLink(lowerCaseName)) {
            return;
        }
        if (HtmlTagMap.isBody(lowerCaseName)) {
            return;
        }
        if (this.myTags.containsKey(lowerCaseName)) {
            HtmlPeer peer = (HtmlPeer)this.myTags.get(lowerCaseName);
            if ("table".equals(peer.getTag())) {
                this.tableBorder = false;
            }
            super.handleEndingTags(peer.getTag());
            return;
        }
        this.handleEndingTags(lowerCaseName);
    }
}

