/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.data.providers;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.core.mediator.IMediatorRequest;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.processor.ElementProcessorFactory;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractElementAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ParameterDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ParameterGroupDialog;
import org.eclipse.birt.report.designer.ui.dialogs.VariableDialog;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class VariablesNodeProvider
extends DefaultNodeProvider {
    public Object[] getChildren(Object model) {
        if (model instanceof PropertyHandle) {
            return ((PropertyHandle)model).getListValue().toArray();
        }
        return super.getChildren(model);
    }

    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        menu.add((IAction)new AddVariableAction(object));
        super.createContextMenu(sourceViewer, object, menu);
    }

    public String getNodeDisplayName(Object object) {
        return Messages.getString((String)"VariablesNodeProvider.NodeName");
    }

    protected DesignElementHandle createElement(String type) throws Exception {
        DesignElementHandle handle = super.createElement(type);
        ParameterGroupDialog dialog = null;
        if ("ParameterGroup".equals(type)) {
            dialog = new ParameterGroupDialog(Display.getCurrent().getActiveShell(), Messages.getString((String)"ParametersNodeProvider.dialogue.title.group"));
            dialog.setInput((Object)handle);
        } else if ("ScalarParameter".equals(type)) {
            dialog = new ParameterDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ParametersNodeProvider.dialogue.title.parameter"));
            ((ParameterDialog)dialog).setInput((Object)handle);
        }
        if (dialog == null || dialog.open() == 1) {
            return null;
        }
        return (DesignElementHandle)dialog.getResult();
    }

    public String getIconName(Object model) {
        return "Variables";
    }

    public static class AddVariableAction
    extends AbstractElementAction {
        private boolean isDone;
        private Object createElement;

        public AddVariableAction(Object selectedObject) {
            super(selectedObject, Messages.getString((String)"VariablesNodeProvider.NewActionName"));
        }

        protected boolean doAction() throws Exception {
            this.isDone = false;
            ReportDesignHandle designHandle = (ReportDesignHandle)SessionHandleAdapter.getInstance().getReportDesignHandle();
            VariableElementHandle variable = (VariableElementHandle)ElementProcessorFactory.createProcessor((String)"VariableElement").createElement(null);
            VariableDialog dialog = new VariableDialog(Messages.getString((String)"VariablesNodeProvider.Dialog.Title"), designHandle, variable);
            if (dialog.open() == 0) {
                designHandle.getPropertyHandle("pageVariables").add((DesignElementHandle)variable);
            }
            this.isDone = true;
            this.createElement = variable;
            return true;
        }

        protected void postDoAction() {
            super.postDoAction();
            if (this.isDone && this.createElement != null) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(this.createElement);
                ReportRequest r = new ReportRequest();
                r.setType((Object)"create element");
                r.setSelectionObject(list);
                SessionHandleAdapter.getInstance().getMediator().notifyRequest((IMediatorRequest)r);
            }
            this.isDone = false;
            this.createElement = null;
        }
    }
}

