/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.DataPointComponent;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.GroupingUnitType;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.JavaDateFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.MultiURLValues;
import org.eclipse.birt.chart.model.attribute.StyledComponent;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.attribute.VerticalAlignment;
import org.eclipse.birt.chart.model.attribute.impl.JavaDateFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.StringFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.URLValueImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.ChartStyleProcessorProxy;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.reportitem.api.ChartReportItemHelper;
import org.eclipse.birt.chart.style.BaseStyleProcessor;
import org.eclipse.birt.chart.style.SimpleStyle;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.RGBColorValue;
import org.eclipse.birt.report.engine.css.engine.value.StringValue;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.ColorHandle;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FormatValueHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.emf.common.util.EList;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class ChartReportStyleProcessor
extends BaseStyleProcessor {
    protected static final String[][] fontSizes = new String[][]{{"xx-small", "7"}, {"x-small", "8"}, {"small", "10"}, {"medium", "12"}, {"large", "14"}, {"x-large", "17"}, {"xx-large", "20"}};
    protected DesignElementHandle handle;
    protected boolean useCache;
    protected final IStyle dstyle;
    protected final int dpi;
    protected SimpleStyle cache = null;
    protected ChartStyleProcessorProxy styleProcessorProxy = null;
    private ULocale uLocale;
    protected static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");
    protected static final IGObjectFactory goFactory = GObjectFactory.instance();
    private static final Pattern ptnWrappingQuotes = Pattern.compile("\".*\"");

    public ChartReportStyleProcessor(DesignElementHandle handle) {
        this(handle, false, null);
    }

    public ChartReportStyleProcessor(DesignElementHandle handle, IStyle style) {
        this(handle, false, style);
    }

    public ChartReportStyleProcessor(DesignElementHandle handle, boolean useCache) {
        this(handle, useCache, null);
    }

    public ChartReportStyleProcessor(DesignElementHandle handle, boolean useCache, IStyle dstyle) {
        this(handle, useCache, dstyle, 96);
    }

    public ChartReportStyleProcessor(DesignElementHandle handle, boolean useCache, IStyle dstyle, int dpi) {
        this.handle = handle;
        this.useCache = useCache;
        this.dstyle = dstyle;
        this.dpi = dpi;
        this.setStyleProcessorProxy(ChartReportStyleProcessor.getChartStyleProcessorProxy(this));
    }

    public ChartReportStyleProcessor(DesignElementHandle handle, boolean useCache, IStyle dstyle, int dpi, ULocale uLocale) {
        this.handle = handle;
        this.useCache = useCache;
        this.dstyle = dstyle;
        this.dpi = dpi;
        this.uLocale = uLocale;
        this.setStyleProcessorProxy(ChartReportStyleProcessor.getChartStyleProcessorProxy(this));
    }

    protected String removeQuotes(String fontName) {
        if (ptnWrappingQuotes.matcher(fontName).matches()) {
            return fontName.substring(1, fontName.length() - 1);
        }
        return fontName;
    }

    public org.eclipse.birt.chart.style.IStyle getStyle(Chart model, StyledComponent name) {
        if (this.cache != null && this.useCache) {
            return this.cache.copy();
        }
        SimpleStyle ss = null;
        if (this.cache == null || !this.useCache) {
            StyleHandle style = this.handle.getPrivateStyle();
            ss = this.computeStyles(style);
        }
        if (this.useCache) {
            this.cache = ss;
        }
        return ss;
    }

    protected SimpleStyle computeStyles(StyleHandle style) {
        ColorDefinition cd;
        int rgbValue;
        SimpleStyle ss = new SimpleStyle();
        String fname = this.removeQuotes(style.getFontFamilyHandle().getStringValue());
        int fsize = ChartReportStyleProcessor.getFontSizeIntValue(this.handle);
        boolean fbold = ChartReportStyleProcessor.getFontWeight(style.getFontWeight()) >= 700;
        boolean fitalic = "italic".equals(style.getFontStyle()) || this.isItalicFont(style.getFontStyle());
        boolean funder = "underline".equals(style.getTextUnderline());
        boolean fstrike = "line-through".equals(style.getTextLineThrough());
        if (this.dstyle != null) {
            CSSValueList valueList = (CSSValueList)this.dstyle.getProperty(69);
            if (valueList.getLength() > 0) {
                fname = valueList.item(0).getCssText();
            }
            fsize = this.getSize(this.dstyle.getProperty(54));
            fbold = this.isBoldFont(this.dstyle.getProperty(47));
            fitalic = this.isItalicFont(this.dstyle.getFontStyle());
            funder = "underline".equals(this.dstyle.getTextUnderline());
            fstrike = "line-through".equals(this.dstyle.getTextLineThrough());
        }
        HorizontalAlignment ha = HorizontalAlignment.LEFT_LITERAL;
        if ("center".equals(style.getTextAlign())) {
            ha = HorizontalAlignment.CENTER_LITERAL;
        } else if ("right".equals(style.getTextAlign())) {
            ha = HorizontalAlignment.RIGHT_LITERAL;
        }
        VerticalAlignment va = VerticalAlignment.TOP_LITERAL;
        if ("middle".equals(style.getVerticalAlign())) {
            va = VerticalAlignment.CENTER_LITERAL;
        } else if ("bottom".equals(style.getVerticalAlign())) {
            va = VerticalAlignment.BOTTOM_LITERAL;
        }
        TextAlignment ta = goFactory.createTextAlignment();
        ta.setHorizontalAlignment(ha);
        ta.setVerticalAlignment(va);
        FontDefinition fd = goFactory.createFontDefinition(fname, (float)fsize, fbold, fitalic, funder, fstrike, true, 0.0, ta);
        ss.setFont(fd);
        ColorHandle ch = style.getColor();
        if (this.dstyle != null) {
            ss.setColor(this.getColor(this.dstyle.getProperty(66)));
        } else if (ch != null && ch.getRGB() != -1) {
            rgbValue = ch.getRGB();
            cd = goFactory.createColorDefinition(rgbValue >> 16 & 0xFF, rgbValue >> 8 & 0xFF, rgbValue & 0xFF);
            ss.setColor(cd);
        } else {
            ss.setColor(goFactory.BLACK());
        }
        ch = style.getBackgroundColor();
        if (this.dstyle != null) {
            ss.setBackgroundColor(this.getColor(this.dstyle.getProperty(41)));
        } else if (ch != null && ch.getRGB() != -1) {
            rgbValue = ch.getRGB();
            cd = goFactory.createColorDefinition(rgbValue >> 16 & 0xFF, rgbValue >> 8 & 0xFF, rgbValue & 0xFF);
            ss.setBackgroundColor(cd);
        }
        double pt = ChartReportStyleProcessor.convertToPixel(style.getPaddingTop());
        double pb = ChartReportStyleProcessor.convertToPixel(style.getPaddingBottom());
        double pl = ChartReportStyleProcessor.convertToPixel(style.getPaddingLeft());
        double pr = ChartReportStyleProcessor.convertToPixel(style.getPaddingRight());
        ss.setPadding(goFactory.createInsets(pt, pl, pb, pr));
        String dateTimeFormat = null;
        String stringFormat = null;
        String numberFormat = null;
        if (this.dstyle != null) {
            dateTimeFormat = this.dstyle.getDateTimeFormat();
            stringFormat = this.dstyle.getStringFormat();
            numberFormat = this.dstyle.getNumberFormat();
        } else {
            dateTimeFormat = style.getDateTimeFormat();
            stringFormat = style.getStringFormat();
            numberFormat = style.getNumberFormat();
        }
        if (dateTimeFormat != null) {
            ss.setDateTimeFormat((FormatSpecifier)JavaDateFormatSpecifierImpl.create((String)new DateFormatter(dateTimeFormat).getFormatCode()));
        }
        if (stringFormat != null) {
            ss.setStringFormat((FormatSpecifier)StringFormatSpecifierImpl.create((String)stringFormat));
        }
        if (numberFormat != null) {
            ss.setNumberFormat((FormatSpecifier)JavaNumberFormatSpecifierImpl.create((String)new NumberFormatter(numberFormat).getFormatCode()));
        }
        return ss;
    }

    protected static int getFontWeight(String fontWeight) {
        int weight = 400;
        if (fontWeight.equals("100")) {
            weight = 100;
        } else if (fontWeight.equals("200")) {
            weight = 200;
        } else if (fontWeight.equals("300")) {
            weight = 300;
        } else if (fontWeight.equals("400")) {
            weight = 400;
        } else if (fontWeight.equals("500")) {
            weight = 500;
        } else if (fontWeight.equals("600")) {
            weight = 600;
        } else if (fontWeight.equals("700")) {
            weight = 700;
        } else if (fontWeight.equals("800")) {
            weight = 800;
        } else if (fontWeight.equals("900")) {
            weight = 900;
        } else if (fontWeight.equals("normal")) {
            weight = 400;
        } else if (fontWeight.equals("bold")) {
            weight = 700;
        }
        return weight;
    }

    protected static int getFontSizeIntValue(DesignElementHandle handle) {
        StyleHandle style;
        if (handle == null) {
            return 10;
        }
        if (!(handle instanceof ReportItemHandle)) {
            if (handle instanceof ModuleHandle) {
                return 10;
            }
            if (handle instanceof GroupHandle) {
                handle = handle.getContainer();
            }
        }
        if ((style = handle.getPrivateStyle()) != null) {
            Object fontSizeValue = style.getFontSize().getValue();
            if (fontSizeValue instanceof DimensionValue) {
                int size = ChartReportStyleProcessor.getFontSizeIntValue(handle.getContainer());
                return (int)ChartReportStyleProcessor.convertToPoint(fontSizeValue, size);
            }
            if (fontSizeValue instanceof String) {
                String fontSize = (String)fontSizeValue;
                if (fontSize.equals("larger")) {
                    return ChartReportStyleProcessor.getLargerFontSizeIntValue(handle.getContainer());
                }
                if (fontSize.equals("smaller")) {
                    return ChartReportStyleProcessor.getSmallerFontSizeIntValue(handle.getContainer());
                }
                int i = 0;
                while (i < fontSizes.length) {
                    if (fontSizes[i][0].equals(fontSize)) {
                        return Integer.parseInt(fontSizes[i][1]);
                    }
                    ++i;
                }
            }
        }
        return 10;
    }

    private static int getLargerFontSizeIntValue(DesignElementHandle handle) {
        Object fontSizeValue;
        if (handle == null || handle.getPrivateStyle() == null) {
            return 11;
        }
        if (!(handle instanceof ReportItemHandle)) {
            if (handle instanceof ModuleHandle) {
                return 11;
            }
            if (handle instanceof GroupHandle) {
                handle = handle.getContainer();
            }
        }
        if ((fontSizeValue = handle.getPrivateStyle().getFontSize().getValue()) instanceof DimensionValue) {
            int size = ChartReportStyleProcessor.getFontSizeIntValue(handle.getContainer());
            return (int)ChartReportStyleProcessor.convertToPoint(fontSizeValue, size) + 1;
        }
        if (fontSizeValue instanceof String) {
            String fontSize = (String)fontSizeValue;
            if (fontSize.equals("larger")) {
                return ChartReportStyleProcessor.getLargerFontSizeIntValue(handle.getContainer());
            }
            if (fontSize.equals("smaller")) {
                return ChartReportStyleProcessor.getSmallerFontSizeIntValue(handle.getContainer());
            }
            int i = 0;
            while (i < fontSizes.length - 1) {
                if (fontSize.equals(fontSizes[i][0])) {
                    return Integer.parseInt(fontSizes[i + 1][1]);
                }
                ++i;
            }
            return Integer.parseInt(fontSizes[fontSizes.length - 1][1]);
        }
        return 11;
    }

    private static int getSmallerFontSizeIntValue(DesignElementHandle handle) {
        Object fontSizeValue;
        if (handle == null || handle.getPrivateStyle() == null) {
            return 9;
        }
        if (!(handle instanceof ReportItemHandle)) {
            if (handle instanceof ModuleHandle) {
                return 9;
            }
            if (handle instanceof GroupHandle) {
                handle = handle.getContainer();
            }
        }
        if ((fontSizeValue = handle.getPrivateStyle().getFontSize().getValue()) instanceof DimensionValue) {
            int gParentFontSize = ChartReportStyleProcessor.getFontSizeIntValue(handle.getContainer());
            int size = (int)ChartReportStyleProcessor.convertToPoint(fontSizeValue, gParentFontSize) - 1;
            if (size < 1) {
                return 1;
            }
            return size;
        }
        if (fontSizeValue instanceof String) {
            String fontSize = (String)fontSizeValue;
            if (fontSize.equals("larger")) {
                return ChartReportStyleProcessor.getLargerFontSizeIntValue(handle.getContainer());
            }
            if (fontSize.equals("smaller")) {
                return ChartReportStyleProcessor.getSmallerFontSizeIntValue(handle.getContainer());
            }
            int i = fontSizes.length - 1;
            while (i > 0) {
                if (fontSize.equals(fontSizes[i][0])) {
                    return Integer.parseInt(fontSizes[i - 1][1]);
                }
                --i;
            }
            return Integer.parseInt(fontSizes[0][1]);
        }
        return 9;
    }

    private static double convertToPoint(Object object, int baseSize) {
        return ChartReportStyleProcessor.convertToInch(object, baseSize) * 72.0;
    }

    private static double convertToPixel(Object object) {
        return ChartReportStyleProcessor.convertToInch(object, 0) * 72.0;
    }

    private static double convertToInch(Object object, int baseSize) {
        double inchValue = 0.0;
        double measure = 0.0;
        String units = "";
        if (object instanceof DimensionValue) {
            DimensionValue dimension = (DimensionValue)object;
            measure = dimension.getMeasure();
            units = dimension.getUnits();
        } else if (object instanceof org.eclipse.birt.report.model.api.DimensionHandle) {
            org.eclipse.birt.report.model.api.DimensionHandle dimension = (org.eclipse.birt.report.model.api.DimensionHandle)object;
            measure = dimension.getMeasure();
            units = dimension.getUnits();
        }
        if ("".equalsIgnoreCase(units)) {
            units = "in";
        }
        if ("in".equals(units)) {
            return measure;
        }
        if (baseSize == 0) {
            baseSize = 10;
        }
        inchValue = "em".equals(units) ? DimensionUtil.convertTo((double)(measure * (double)baseSize), (String)"pt", (String)"in").getMeasure() : ("ex".equals(units) ? DimensionUtil.convertTo((double)(measure * (double)baseSize / 3.0), (String)"pt", (String)"in").getMeasure() : ("%".equals(units) ? DimensionUtil.convertTo((double)(measure * (double)baseSize / 100.0), (String)"pt", (String)"in").getMeasure() : ("px".equals(units) ? measure / 72.0 : DimensionUtil.convertTo((double)measure, (String)units, (String)"in").getMeasure())));
        return inchValue;
    }

    private ColorDefinition getColor(CSSValue value) {
        if (value instanceof RGBColorValue) {
            RGBColorValue color = (RGBColorValue)value;
            try {
                return goFactory.createColorDefinition(Math.round(color.getRed().getFloatValue((short)1)), Math.round(color.getGreen().getFloatValue((short)1)), Math.round(color.getBlue().getFloatValue((short)1)));
            }
            catch (RuntimeException ex) {
                logger.log(Level.WARNING.intValue(), "invalid color: {0}" + value.toString());
            }
        }
        return null;
    }

    private int getSize(CSSValue value) {
        if (value != null && value instanceof FloatValue) {
            FloatValue fv = (FloatValue)value;
            float v = fv.getFloatValue();
            switch (fv.getPrimitiveType()) {
                case 6: {
                    return (int)((double)(v * 72.0f) / 2.54);
                }
                case 8: {
                    return (int)(v * 72.0f);
                }
                case 7: {
                    return (int)((double)v * 7.2 / 2.54);
                }
                case 10: {
                    return (int)(v * 12.0f);
                }
                case 5: {
                    return (int)(v / (float)this.dpi * 72.0f);
                }
                case 9: {
                    return (int)v;
                }
                case 1: {
                    return (int)(v / 1000.0f);
                }
            }
        }
        return 0;
    }

    private boolean isBoldFont(CSSValue value) {
        String weight;
        return value instanceof StringValue && ("bold".equals((weight = ((StringValue)value).getStringValue()).toLowerCase()) || "bolder".equals(weight.toLowerCase()) || "600".equals(weight) || "700".equals(weight) || "800".equals(weight) || "900".equals(weight));
    }

    protected boolean isItalicFont(String italic) {
        return "oblique".equals(italic) || "italic".equals(italic);
    }

    public void processStyle(Chart cm) {
        DataSetHandle dataset = ChartReportItemHelper.instance().getBindingDataSetHandle((ReportItemHandle)this.handle);
        if (dataset != null) {
            this.processDataSetStyle(cm);
            return;
        }
        CubeHandle cube = ChartReportItemHelper.instance().getBindingCubeHandle((ReportItemHandle)this.handle);
        if (cube == null) {
            return;
        }
        ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
        EList bsQuery = ((SeriesDefinition)ChartUtil.getBaseSeriesDefinitions((Chart)cm).get(0)).getDesignTimeSeries().getDataDefinition();
        List vsds = ChartUtil.getAllOrthogonalSeriesDefinitions((Chart)cm);
        SeriesDefinition vsd = vsds.isEmpty() ? null : (SeriesDefinition)vsds.get(0);
        LevelHandle category = bsQuery.size() == 0 ? null : this.findLevelHandle(cube, exprCodec, (Query)bsQuery.get(0));
        LevelHandle yoption = vsd == null ? null : this.findLevelHandle(cube, exprCodec, vsd.getQuery());
        Query query = null;
        if (vsd != null && vsd.getDesignTimeSeries().getDataDefinition().size() > 0) {
            query = (Query)vsd.getDesignTimeSeries().getDataDefinition().get(0);
        }
        MeasureHandle measure = this.findMeasureHandle(cube, exprCodec, query);
        if (category != null || measure != null || yoption != null) {
            this.processCubeStyle(cm, category, measure, yoption);
        }
    }

    protected void processDataSetStyle(Chart cm) {
        this.styleProcessorProxy.processDataSetStyle(cm);
    }

    public void applyDefaultHyperlink(Chart chart) {
        ActionHandle actionHandle;
        String category = ((Query)((SeriesDefinition)ChartUtil.getBaseSeriesDefinitions((Chart)chart).get(0)).getDesignTimeSeries().getDataDefinition().get(0)).getDefinition();
        Trigger categorytrigger = this.getDefaultHyperlink((ExtendedItemHandle)this.handle, category);
        if (chart instanceof ChartWithAxes) {
            this.addHyperlink((List<Trigger>)((Axis)((ChartWithAxes)chart).getAxes().get(0)).getTriggers(), categorytrigger);
            for (Axis axis : ((Axis)((ChartWithAxes)chart).getAxes().get(0)).getAssociatedAxes()) {
                String value = ((Query)((SeriesDefinition)axis.getSeriesDefinitions().get(0)).getDesignTimeSeries().getDataDefinition().get(0)).getDefinition();
                Trigger valuetrigger = this.getDefaultHyperlink((ExtendedItemHandle)this.handle, value);
                this.addHyperlink((List<Trigger>)axis.getTriggers(), valuetrigger);
            }
        }
        if ((actionHandle = ChartReportStyleProcessor.getDefaultAction((ExtendedItemHandle)this.handle, category)) != null && ("drill-through".equals(actionHandle.getLinkType()) || "hyperlink".equals(actionHandle.getLinkType()))) {
            try {
                String baseURI = ModuleUtil.serializeAction((ActionHandle)actionHandle);
                URLValue uv = URLValueImpl.create((String)baseURI, (String)"", (String)"", (String)"", (String)"");
                Trigger trigger = TriggerImpl.create((TriggerCondition)TriggerCondition.ONCLICK_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.URL_REDIRECT_LITERAL, (ActionValue)uv));
                for (SeriesDefinition sd : ChartUtil.getAllOrthogonalSeriesDefinitions((Chart)chart)) {
                    Series series = sd.getDesignTimeSeries();
                    this.addHyperlink((List<Trigger>)series.getTriggers(), trigger.copyInstance());
                }
            }
            catch (IOException baseURI) {
                // empty catch block
            }
        }
        if (chart.getLegend().getItemType() == LegendItemType.CATEGORIES_LITERAL) {
            if (categorytrigger != null) {
                this.addHyperlink((List<Trigger>)chart.getLegend().getTriggers(), categorytrigger.copyInstance());
            }
        } else {
            String[] optional = ChartUtil.getYOptoinalExpressions((Chart)chart);
            if (optional.length > 0) {
                Trigger optionaltrigger = this.getDefaultHyperlink((ExtendedItemHandle)this.handle, optional[0]);
                this.addHyperlink((List<Trigger>)chart.getLegend().getTriggers(), optionaltrigger);
            }
        }
    }

    protected void addHyperlink(List<Trigger> triggers, Trigger trig) {
        if (trig != null) {
            MultiURLValues mu;
            Trigger old = null;
            for (Trigger t : triggers) {
                if (trig.getCondition() != t.getCondition()) continue;
                old = t;
                break;
            }
            if (old == null) {
                triggers.add(trig);
            } else if (old.getAction().getValue() instanceof MultiURLValues && (mu = (MultiURLValues)old.getAction().getValue()).getURLValues().size() == 0) {
                mu.getURLValues().add((Object)((URLValue)trig.getAction().getValue()));
            }
        }
    }

    protected void processCubeStyle(Chart cm, LevelHandle category, MeasureHandle measure, LevelHandle yoption) {
        String[] categoryExprs = ChartUtil.getCategoryExpressions((Chart)cm);
        String categoryExpr = null;
        if (categoryExprs != null && categoryExprs.length > 0) {
            categoryExpr = categoryExprs[0];
        }
        List orthSDs = ChartUtil.getAllOrthogonalSeriesDefinitions((Chart)cm);
        String optionalYExpr = null;
        if (orthSDs != null && orthSDs.size() > 0 && ((SeriesDefinition)orthSDs.get(0)).getQuery() != null) {
            optionalYExpr = ((SeriesDefinition)orthSDs.get(0)).getQuery().getDefinition();
        }
        GroupingUnitType dateGut = this.computeLevelHandleGroupUnit(optionalYExpr, yoption);
        for (SeriesDefinition sd : ChartUtil.getAllOrthogonalSeriesDefinitions((Chart)cm)) {
            if (dateGut != null && sd.getQuery().getGrouping() != null && !sd.getQuery().getGrouping().isSetEnabled()) {
                sd.getQuery().getGrouping().setEnabled(true);
                sd.getQuery().getGrouping().setGroupType(DataType.DATE_TIME_LITERAL);
                sd.getQuery().getGrouping().setGroupingUnit(dateGut);
            }
            for (Series series : sd.getRunTimeSeries()) {
                if (!series.getLabel().isVisible()) continue;
                for (DataPointComponent dpc : series.getDataPoint().getComponents()) {
                    if (dpc.getType().getValue() == 0) {
                        if (dpc.getFormatSpecifier() != null) continue;
                        dpc.setFormatSpecifier(this.createFormatSpecifier(category, categoryExpr));
                        continue;
                    }
                    if (dpc.getType().getValue() == 1) {
                        if (dpc.getFormatSpecifier() != null) continue;
                        dpc.setFormatSpecifier(this.createFormatSpecifier(measure));
                        continue;
                    }
                    if (dpc.getType().getValue() != 2 || dpc.getFormatSpecifier() != null) continue;
                    dpc.setFormatSpecifier(this.createFormatSpecifier(yoption, optionalYExpr));
                }
            }
        }
        if (cm.getLegend().getFormatSpecifier() == null) {
            cm.getLegend().setFormatSpecifier(this.createFormatSpecifier(yoption, optionalYExpr));
        }
        dateGut = null;
        if (categoryExpr != null) {
            dateGut = this.computeLevelHandleGroupUnit(categoryExpr, category);
        }
        if (cm instanceof ChartWithAxes) {
            cwa = (ChartWithAxes)cm;
            Axis xAxis = (Axis)cwa.getAxes().get(0);
            if (dateGut != null) {
                for (SeriesDefinition sd : xAxis.getSeriesDefinitions()) {
                    if (sd.getGrouping() == null) continue;
                    sd.getGrouping().setEnabled(true);
                    sd.getGrouping().setGroupType(DataType.DATE_TIME_LITERAL);
                    sd.getGrouping().setGroupingUnit(dateGut);
                }
            }
            if (xAxis.getLabel().isVisible() && xAxis.getFormatSpecifier() == null) {
                xAxis.setFormatSpecifier(this.createFormatSpecifier(category, categoryExpr));
            }
            for (Axis yAxis : xAxis.getAssociatedAxes()) {
                if (!yAxis.getLabel().isVisible() || yAxis.getFormatSpecifier() != null) continue;
                yAxis.setFormatSpecifier(this.createFormatSpecifier(measure));
            }
        } else {
            SeriesDefinition sd;
            cwa = (ChartWithoutAxes)cm;
            if (dateGut != null && (sd = (SeriesDefinition)cwa.getSeriesDefinitions().get(0)).getGrouping() != null && !sd.getGrouping().isSetEnabled()) {
                sd.getGrouping().setEnabled(true);
                sd.getGrouping().setGroupType(DataType.DATE_TIME_LITERAL);
                sd.getGrouping().setGroupingUnit(dateGut);
            }
            if (((SeriesDefinition)cwa.getSeriesDefinitions().get(0)).getFormatSpecifier() == null) {
                ((SeriesDefinition)cwa.getSeriesDefinitions().get(0)).setFormatSpecifier(this.createFormatSpecifier(category, categoryExpr));
            }
        }
    }

    private GroupingUnitType computeLevelHandleGroupUnit(String chartBindExpr, LevelHandle levelHandle) {
        GroupingUnitType gut = null;
        if (levelHandle != null) {
            String dtLevelType = levelHandle.getDateTimeLevelType();
            if (dtLevelType == null) {
                return null;
            }
            if ("year".equals(dtLevelType)) {
                gut = GroupingUnitType.YEARS_LITERAL;
            } else if ("quarter".equals(dtLevelType)) {
                gut = GroupingUnitType.QUARTERS_LITERAL;
            } else if ("month".equals(dtLevelType)) {
                gut = GroupingUnitType.MONTHS_LITERAL;
            } else if ("week-of-month".equals(dtLevelType)) {
                gut = GroupingUnitType.WEEK_OF_MONTH_LITERAL;
            } else if ("week-of-year".equals(dtLevelType)) {
                gut = GroupingUnitType.WEEK_OF_YEAR_LITERAL;
            } else if ("day-of-year".equals(dtLevelType)) {
                gut = GroupingUnitType.DAY_OF_YEAR_LITERAL;
            } else if ("day-of-month".equals(dtLevelType)) {
                gut = GroupingUnitType.DAY_OF_MONTH_LITERAL;
            } else if ("day-of-week".equals(dtLevelType)) {
                gut = GroupingUnitType.DAY_OF_WEEK_LITERAL;
            } else if ("hour".equals(dtLevelType)) {
                gut = GroupingUnitType.HOURS_LITERAL;
            } else if ("minute".equals(dtLevelType)) {
                gut = GroupingUnitType.MINUTES_LITERAL;
            } else if ("second".equals(dtLevelType)) {
                gut = GroupingUnitType.SECONDS_LITERAL;
            }
        }
        if (gut != null) {
            ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
            String bindingName = exprCodec.getBindingName(chartBindExpr);
            Iterator<ComputedColumnHandle> bindings = ChartItemUtil.getAllColumnBindingsIterator((ReportItemHandle)this.handle);
            while (bindings.hasNext()) {
                ComputedColumnHandle cc = bindings.next();
                if (!cc.getName().equals(bindingName)) continue;
                String dateType = cc.getDataType();
                if ("date".equals(dateType) || "time".equals(dateType) || "date-time".equals(dateType)) break;
                gut = null;
                break;
            }
        }
        return gut;
    }

    private boolean isDateTimeBinding(String chartBindExpr) {
        ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
        String bindingName = exprCodec.getBindingName(chartBindExpr);
        Iterator<ComputedColumnHandle> bindings = ChartItemUtil.getAllColumnBindingsIterator((ReportItemHandle)this.handle);
        while (bindings.hasNext()) {
            ComputedColumnHandle cc = bindings.next();
            if (!cc.getName().equals(bindingName)) continue;
            String dateType = cc.getDataType();
            return "date".equals(dateType) || "time".equals(dateType) || "date-time".equals(dateType);
        }
        return false;
    }

    private final LevelHandle findLevelHandle(CubeHandle cube, ChartExpressionUtil.ExpressionCodec exprCodec, Query query) {
        if (query != null && query.isDefined() && exprCodec.isCubeBinding(query.getDefinition(), true)) {
            String bindingName = exprCodec.getBindingName();
            Iterator<ComputedColumnHandle> bindings = ChartItemUtil.getAllColumnBindingsIterator((ReportItemHandle)this.handle);
            while (bindings.hasNext()) {
                String[] levels;
                ComputedColumnHandle cc = bindings.next();
                if (!cc.getName().equals(bindingName)) continue;
                ChartItemUtil.loadExpression(exprCodec, cc);
                if (!exprCodec.isDimensionExpresion() || cube.getDimension((levels = exprCodec.getLevelNames())[0]) == null) break;
                return cube.getDimension(levels[0]).getDefaultHierarchy().getLevel(levels[1]);
            }
        }
        return null;
    }

    private final MeasureHandle findMeasureHandle(CubeHandle cube, ChartExpressionUtil.ExpressionCodec exprCodec, Query query) {
        if (query != null && query.isDefined() && exprCodec.isCubeBinding(query.getDefinition(), true)) {
            String bindingName = exprCodec.getBindingName();
            Iterator<ComputedColumnHandle> bindings = ChartItemUtil.getAllColumnBindingsIterator((ReportItemHandle)this.handle);
            while (bindings.hasNext()) {
                ComputedColumnHandle cc = bindings.next();
                if (!cc.getName().equals(bindingName)) continue;
                ChartItemUtil.loadExpression(exprCodec, cc);
                if (!exprCodec.isMeasureExpresion()) break;
                return cube.getMeasure(exprCodec.getMeasureName());
            }
        }
        return null;
    }

    protected FormatSpecifier createFormatSpecifier(LevelHandle levelHandle, String chartBindExpr) {
        if (chartBindExpr == null) {
            return null;
        }
        Object fs = null;
        if (levelHandle != null && (fs = levelHandle.getFormat() == null && ((DimensionHandle)levelHandle.getContainer().getContainer()).isTimeType() && levelHandle.getDateTimeFormat() != null ? JavaDateFormatSpecifierImpl.create((String)new DateFormatter(levelHandle.getDateTimeFormat()).getFormatCode()) : this.convertToFormatSpecifier(levelHandle.getFormat(), levelHandle.getDataType())) instanceof JavaDateFormatSpecifier && !this.isDateTimeBinding(chartBindExpr)) {
            fs = null;
        }
        return fs;
    }

    protected FormatSpecifier createFormatSpecifier(MeasureHandle measureHandle) {
        if (measureHandle != null) {
            return this.convertToFormatSpecifier(measureHandle.getFormat(), measureHandle.getDataType());
        }
        return null;
    }

    protected FormatSpecifier convertToFormatSpecifier(FormatValueHandle format, String dataType) {
        if (format != null && format.getPattern() != null) {
            if ("integer".equals(dataType) || "decimal".equals(dataType) || "float".equals(dataType)) {
                if ("General Number".equals(format.getCategory())) {
                    return null;
                }
                return JavaNumberFormatSpecifierImpl.create((String)new NumberFormatter(format.getPattern()).getFormatCode());
            }
            if ("date-time".equals(dataType) || "date".equals(dataType) || "time".equals(dataType)) {
                return JavaDateFormatSpecifierImpl.create((String)new DateFormatter(format.getPattern()).getFormatCode());
            }
            return StringFormatSpecifierImpl.create((String)format.getPattern());
        }
        return null;
    }

    private Trigger getDefaultHyperlink(ExtendedItemHandle handle, String expression) {
        Trigger trigger = null;
        ActionHandle actionHandle = ChartReportStyleProcessor.getDefaultAction(handle, expression);
        if (actionHandle != null && "hyperlink".equals(actionHandle.getLinkType())) {
            try {
                String baseURI = ModuleUtil.serializeAction((ActionHandle)actionHandle);
                URLValue uv = URLValueImpl.create((String)baseURI, (String)"", (String)"", (String)"", (String)"");
                trigger = TriggerImpl.create((TriggerCondition)TriggerCondition.ONCLICK_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.URL_REDIRECT_LITERAL, (ActionValue)uv));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return trigger;
    }

    public static ActionHandle getDefaultAction(ExtendedItemHandle handle, String expression) {
        block7: {
            DataSetHandle dataset;
            String bindingname;
            block6: {
                ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
                bindingname = exprCodec.getBindingName(expression);
                if (bindingname == null) {
                    return null;
                }
                CubeHandle cube = handle.getCube();
                dataset = handle.getDataSet();
                if (cube == null || ChartReportItemHelper.instance().getBindingCubeHandle((ReportItemHandle)handle) == null) break block6;
                for (LevelHandle lh : ChartCubeUtil.getAllLevels(cube)) {
                    if (bindingname.equals(ChartCubeUtil.createLevelBindingName(lh))) {
                        return lh.getActionHandle();
                    }
                    Iterator iter = lh.attributesIterator();
                    while (iter.hasNext()) {
                        LevelAttributeHandle laHandle = (LevelAttributeHandle)iter.next();
                        if (!bindingname.equals(ChartCubeUtil.createLevelAttrBindingName(lh, laHandle))) continue;
                        return lh.getActionHandle();
                    }
                }
                for (MeasureHandle mh : ChartCubeUtil.getAllMeasures(cube)) {
                    if (!bindingname.equals(ChartCubeUtil.createMeasureBindingName(mh))) continue;
                    return mh.getActionHandle();
                }
                break block7;
            }
            if (dataset == null || ChartReportItemHelper.instance().getBindingDataSetHandle((ReportItemHandle)handle) == null) break block7;
            for (ColumnHintHandle element : dataset.getPropertyHandle("columnHints")) {
                if (!element.getColumnName().equals(bindingname) && !bindingname.equals(element.getAlias())) continue;
                return element.getActionHandle();
            }
        }
        return null;
    }

    protected void setStyleProcessorProxy(ChartStyleProcessorProxy proxy) {
        this.styleProcessorProxy = proxy;
        this.styleProcessorProxy.setHandle(this.handle);
    }

    public ChartStyleProcessorProxy getStyleProcessorProxy() {
        return this.styleProcessorProxy;
    }

    private static ChartStyleProcessorProxy getChartStyleProcessorProxy(ChartReportStyleProcessor processor) {
        ChartStyleProcessorProxy factory = ChartReportItemUtil.getAdapter((Object)processor, ChartStyleProcessorProxy.class);
        if (factory == null) {
            factory = new ChartStyleProcessorProxy();
        }
        factory.setULocale(processor.uLocale);
        return factory;
    }

    public boolean updateChart(Chart model, Object obj) {
        if (this.styleProcessorProxy != null) {
            this.styleProcessorProxy.updateChart(model, false);
            return true;
        }
        return false;
    }

    public boolean needInheritingStyles() {
        if (this.styleProcessorProxy != null) {
            return this.styleProcessorProxy.needInheritingStyles();
        }
        return super.needInheritingStyles();
    }
}

