/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import java.io.IOException;
import org.eclipse.birt.report.designer.internal.ui.views.ReportResourceChangeEvent;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.views.IReportResourceSynchronizer;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.ImageHandle;

public class ReloadImageAction
extends AbstractViewAction {
    public ReloadImageAction(Object element) {
        super(element, Messages.getString((String)"ReloadImageAction.Text"));
    }

    public void run() {
        ImageHandle image;
        ExpressionHandle uri;
        IReportResourceSynchronizer synchronizer = ReportPlugin.getDefault().getResourceSynchronizerService();
        if (synchronizer != null && (uri = (image = (ImageHandle)this.getSelection()).getExpressionProperty("uri")) != null) {
            String imageUri = (String)uri.getExpression();
            if ("javascript".equals(uri.getType()) && imageUri != null) {
                imageUri = DEUtil.removeQuote((String)imageUri);
            }
            if ("file".equals(image.getSource())) {
                try {
                    ImageManager.getInstance().rloadImage(image.getModuleHandle(), imageUri);
                }
                catch (IOException iOException) {}
            } else if ("url".equals(image.getSource())) {
                ImageManager.getInstance().reloadURIImage(image.getModuleHandle(), imageUri);
            }
            synchronizer.notifyResourceChanged(new ReportResourceChangeEvent((Object)this, imageUri, 4));
        }
    }
}

