/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractDatasetSortingFormHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.SortingFormPropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DataSetColumnBindingsFormDescriptor
extends SortingFormPropertyDescriptor {
    private AbstractDatasetSortingFormHandleProvider provider;
    protected Button btnRefresh;
    protected Button btnClear;

    public DataSetColumnBindingsFormDescriptor(boolean formStyle) {
        super(formStyle);
        super.setStyle(3);
        super.setButtonWithDialog(false);
    }

    @Override
    public void setDescriptorProvider(IDescriptorProvider provider) {
        super.setDescriptorProvider(provider);
        if (provider instanceof AbstractDatasetSortingFormHandleProvider) {
            this.provider = (AbstractDatasetSortingFormHandleProvider)provider;
        }
    }

    @Override
    public Control createControl(Composite parent) {
        Control control = super.createControl(parent);
        this.provider.setTableViewer(this.getTableViewer());
        this.btnClear = this.isFormStyle() ? FormWidgetFactory.getInstance().createButton((Composite)control, "", 8) : new Button((Composite)control, 8);
        this.btnClear.setText(Messages.getString((String)"FormPage.Button.Binding.Clear"));
        this.btnClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetColumnBindingsFormDescriptor.this.handleClearSelectEvent();
            }
        });
        this.btnClear.setEnabled(true);
        this.btnRefresh = this.isFormStyle() ? FormWidgetFactory.getInstance().createButton((Composite)control, "", 8) : new Button((Composite)control, 8);
        this.btnRefresh.setText(Messages.getString((String)"FormPage.Button.Binding.Refresh"));
        this.btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetColumnBindingsFormDescriptor.this.handleRefreshSelectEvent();
            }
        });
        this.btnRefresh.setEnabled(true);
        if (this.getStyle() == 4) {
            this.fullLayoutHorizontal();
        } else {
            this.fullLayout();
        }
        return control;
    }

    protected void handleRefreshSelectEvent() {
        this.provider.generateAllBindingColumns();
    }

    protected void handleClearSelectEvent() {
        this.provider.clearAllBindingColumns();
    }

    @Override
    protected void fullLayoutHorizontal() {
        FormData data;
        super.fullLayoutHorizontal();
        Button rightButton = null;
        if (this.btnRefresh != null) {
            data = new FormData();
            data.right = new FormAttachment(100);
            data.width = Math.max(this.btnWidth, this.btnRefresh.computeSize((int)-1, (int)-1, (boolean)true).x);
            this.btnRefresh.setLayoutData((Object)data);
            rightButton = this.btnRefresh;
        }
        if (this.btnClear != null) {
            if (this.btnRefresh == null) {
                data = new FormData();
                data.right = new FormAttachment(100);
                data.width = Math.max(this.btnWidth, this.btnClear.computeSize((int)-1, (int)-1, (boolean)true).x);
                this.btnClear.setLayoutData((Object)data);
            } else {
                data = new FormData();
                data.right = new FormAttachment((Control)this.btnRefresh, 0, 16384);
                data.width = Math.max(this.btnWidth, this.btnClear.computeSize((int)-1, (int)-1, (boolean)true).x);
                this.btnClear.setLayoutData((Object)data);
            }
            rightButton = this.btnClear;
        }
        if (rightButton != null) {
            data = new FormData();
            data.right = new FormAttachment(rightButton, 0, 16384);
            data.width = Math.max(this.btnWidth, this.btnEdit.computeSize((int)-1, (int)-1, (boolean)true).x);
            this.btnEdit.setLayoutData((Object)data);
        }
    }

    @Override
    protected void fullLayout() {
        super.fullLayout();
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.btnEdit, 0, 1024);
        data.left = new FormAttachment((Control)this.btnEdit, 0, 16384);
        data.width = Math.max(60, this.btnDel.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnDel.setLayoutData((Object)data);
        if (this.btnClear != null) {
            data = new FormData();
            data.top = new FormAttachment((Control)this.btnDel, 0, 1024);
            data.left = new FormAttachment((Control)this.btnDel, 0, 16384);
            data.width = Math.max(60, this.btnClear.computeSize((int)-1, (int)-1, (boolean)true).x);
            this.btnClear.setLayoutData((Object)data);
        }
        if (this.btnRefresh != null) {
            data = new FormData();
            data.top = new FormAttachment((Control)this.btnClear, 0, 1024);
            data.left = new FormAttachment((Control)this.btnClear, 0, 16384);
            data.width = Math.max(60, this.btnRefresh.computeSize((int)-1, (int)-1, (boolean)true).x);
            this.btnRefresh.setLayoutData((Object)data);
        }
    }

    @Override
    protected void updateArraw() {
        super.updateArraw();
        if (this.provider.isEnable() && this.provider.isEditable()) {
            if (this.table.getItemCount() > 0) {
                this.btnClear.setEnabled(this.provider.isClearEnable());
            } else {
                this.btnClear.setEnabled(false);
            }
        } else {
            this.btnClear.setEnabled(false);
        }
    }

    @Override
    public void setInput(Object object) {
        super.setInput(object);
        if (DEUtil.getInputSize((Object)object) > 0 && DEUtil.getInputFirstElement((Object)object) instanceof DesignElementHandle) {
            Object element = DEUtil.getInputFirstElement((Object)object);
            this.setBindingObject((DesignElementHandle)element);
        }
        if (this.provider.isEnable() && this.provider.isEditable()) {
            this.btnRefresh.setEnabled(true);
        } else {
            this.btnRefresh.setEnabled(false);
        }
    }

    private void setBindingObject(DesignElementHandle bindingObject) {
        this.provider.setBindingObject(bindingObject);
    }
}

