/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.outline;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.mediator.IMediator;
import org.eclipse.birt.report.designer.core.mediator.IMediatorColleague;
import org.eclipse.birt.report.designer.core.mediator.IMediatorRequest;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.request.IRequestConverter;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.editors.EditorUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.IReportPageBookViewPage;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportEventRunnable;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedElementUIPoint;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.EditpartExtensionManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.PaletteEntryExtension;
import org.eclipse.birt.report.designer.internal.ui.views.DesignerOutlineEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.views.NonGEFSynchronizerWithTreeView;
import org.eclipse.birt.report.designer.internal.ui.views.RenameListener;
import org.eclipse.birt.report.designer.internal.ui.views.ViewContextMenuProvider;
import org.eclipse.birt.report.designer.internal.ui.views.ViewsTreeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.GlobalActionFactory;
import org.eclipse.birt.report.designer.internal.ui.views.actions.ImportLibraryAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.SearchAction;
import org.eclipse.birt.report.designer.internal.ui.views.outline.ItemSorter;
import org.eclipse.birt.report.designer.internal.ui.views.outline.dnd.DesignerDragListener;
import org.eclipse.birt.report.designer.internal.ui.views.outline.dnd.DesignerDropListener;
import org.eclipse.birt.report.designer.internal.ui.views.outline.dnd.IDropConstraint;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.INodeProvider;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.birt.report.designer.ui.widget.ITreeViewerBackup;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.CssSharedStyleHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.api.validators.ValidationEvent;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class DesignerOutlinePage
extends ContentOutlinePage
implements IValidationListener,
AbstractModelEventProcessor.IModelEventFactory,
IReportPageBookViewPage {
    private ModuleHandle model;
    private NonGEFSynchronizerWithTreeView synchronizer;
    private ITreeViewerBackup backup;

    public DesignerOutlinePage(ModuleHandle model) {
        this.model = model;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.createContextMenu();
        ViewsTreeProvider provider = new ViewsTreeProvider();
        this.getTreeViewer().setContentProvider((IContentProvider)provider);
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)provider);
        this.getSelectionSynchronizer().setTreeViewer((AbstractTreeViewer)this.getTreeViewer());
        new RenameListener(this.getTreeViewer()).apply();
        this.getTreeViewer().setSorter((ViewerSorter)new ItemSorter());
        this.addDragAndDropListener();
        this.init(this.model);
        this.getTreeViewer().expandToLevel(2);
        final Tree tree = this.getTreeViewer().getTree();
        tree.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                if (event.item.getData() instanceof CssStyleSheetHandle || event.item.getData() instanceof CssSharedStyleHandle) {
                    Color gray = Display.getCurrent().getSystemColor(16);
                    if (!item.getForeground().equals((Object)gray)) {
                        item.setForeground(gray);
                    }
                } else {
                    INodeProvider provider = null;
                    if (event.item != null && event.item.getData() != null) {
                        provider = ProviderFactory.createProvider((Object)event.item.getData());
                    }
                    if (provider != null && provider.isReadOnly(event.item.getData())) {
                        Color gray = Display.getCurrent().getSystemColor(16);
                        if (!item.getForeground().equals((Object)gray)) {
                            item.setForeground(gray);
                        }
                    } else {
                        Color black = ReportColorConstants.ReportForeground;
                        if (!item.getForeground().equals((Object)black)) {
                            item.setForeground(black);
                        }
                    }
                }
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if ((e.stateMask & 0x40000) != 0 || (e.stateMask & 0x20000) != 0) {
                    this.setSingleSelection(e);
                }
            }

            private void setSingleSelection(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)DesignerOutlinePage.this.getSelection();
                if (!selection.isEmpty() && selection.size() > 1) {
                    boolean includeCell = false;
                    for (Object obj : selection) {
                        if (!(obj instanceof CellHandle)) continue;
                        if (includeCell) {
                            TreeItem item = DesignerOutlinePage.this.getTreeViewer().getTree().getItem(new Point(e.x, e.y));
                            if (item == null) break;
                            DesignerOutlinePage.this.getTreeViewer().getTree().setSelection(new TreeItem[]{item});
                            break;
                        }
                        includeCell = true;
                    }
                }
            }
        });
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (DesignerOutlinePage.this.getSelection() instanceof StructuredSelection) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    Object selectedObject = ((StructuredSelection)DesignerOutlinePage.this.getSelection()).getFirstElement();
                    list.add(selectedObject);
                    ReportRequest r = new ReportRequest();
                    r.setType((Object)"open editor");
                    r.setRequestConverter(new IRequestConverter(){

                        public List convertSelectionToModelLisr(List list) {
                            ArrayList lst = new ArrayList();
                            for (Object obj : list) {
                                lst.add(obj);
                            }
                            return lst;
                        }
                    });
                    r.setSelectionObject(list);
                    SessionHandleAdapter.getInstance().getMediator(DesignerOutlinePage.this.model).notifyRequest((IMediatorRequest)r);
                    if (selectedObject instanceof LibraryHandle && selectedObject != DesignerOutlinePage.this.getRoot()) {
                        try {
                            final File file = EditorUtil.convertToFile(new URL(((LibraryHandle)selectedObject).getFileName()));
                            if (file != null && file.exists() && file.isFile()) {
                                Display.getCurrent().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            EditorUtil.openEditor(DesignerOutlinePage.this, file, "org.eclipse.birt.report.designer.ui.editors.LibraryEditor");
                                        }
                                        catch (PartInitException e) {
                                            ExceptionUtil.handle((Throwable)e);
                                        }
                                    }
                                });
                            }
                        }
                        catch (IOException file) {
                            // empty catch block
                        }
                    }
                    try {
                        Tree tree = (Tree)e.getSource();
                        TreeItem[] selectedItems = tree.getSelection();
                        if (selectedItems.length > 0) {
                            if (selectedItems[0].getExpanded()) {
                                selectedItems[0].setExpanded(false);
                            } else {
                                DesignerOutlinePage.this.getTreeViewer().expandToLevel(selectedObject, selectedItems[0].getExpanded() ? 0 : 1);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        tree.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                Widget widget = event.widget;
                if (widget == tree) {
                    Point pt = new Point(event.x, event.y);
                    TreeItem item = tree.getItem(pt);
                    if (item == null || item.getData() == null) {
                        tree.setToolTipText(null);
                    } else {
                        tree.setToolTipText(DesignerOutlinePage.this.getTooltip(item.getData()));
                    }
                }
            }
        });
        SessionHandleAdapter.getInstance().getMediator(this.model).addColleague((IMediatorColleague)this.getSelectionSynchronizer());
        if (this.backup != null) {
            this.backup.restoreBackup(this.getTreeViewer());
            this.getTreeViewer().getTree().addTreeListener(new TreeListener(){

                public void treeCollapsed(TreeEvent e) {
                    Item item = (Item)e.item;
                    DesignerOutlinePage.this.backup.updateCollapsedStatus(DesignerOutlinePage.this.getTreeViewer(), item.getData());
                }

                public void treeExpanded(TreeEvent e) {
                    Item item = (Item)e.item;
                    DesignerOutlinePage.this.backup.updateExpandedStatus(DesignerOutlinePage.this.getTreeViewer(), item.getData());
                }
            });
        }
    }

    protected void addDragAndDropListener() {
        int ops = 3;
        Transfer[] transfers = new Transfer[]{TemplateTransfer.getInstance()};
        this.getTreeViewer().addDragSupport(ops, transfers, (DragSourceListener)new DesignerDragListener((StructuredViewer)this.getTreeViewer()));
        transfers = new Transfer[]{TemplateTransfer.getInstance()};
        DesignerDropListener dropListener = new DesignerDropListener(this.getTreeViewer());
        dropListener.addDropConstraint(CascadingParameterGroupHandle.class, new IDropConstraint(){

            public int validate(Object transfer, Object target) {
                return -1;
            }
        });
        dropListener.addDropConstraint(ScalarParameterHandle.class, new IDropConstraint(){

            public int validate(Object transfer, Object target) {
                ScalarParameterHandle targetParameter;
                if (target instanceof ScalarParameterHandle && (targetParameter = (ScalarParameterHandle)target).getContainer() instanceof CascadingParameterGroupHandle) {
                    return -1;
                }
                return 0;
            }
        });
        IDropConstraint cascadingParameterGroupChildrenConstraint = new IDropConstraint(){

            public int validate(Object transfer, Object target) {
                ScalarParameterHandle transferParameter;
                if (transfer instanceof Object[] && ((Object[])transfer).length > 0 && ((Object[])transfer)[0] instanceof ScalarParameterHandle && (transferParameter = (ScalarParameterHandle)((Object[])transfer)[0]).getContainer() instanceof CascadingParameterGroupHandle) {
                    return -1;
                }
                return 0;
            }
        };
        dropListener.addDropConstraint(ScalarParameterHandle.class, cascadingParameterGroupChildrenConstraint);
        dropListener.addDropConstraint(ParameterGroupHandle.class, cascadingParameterGroupChildrenConstraint);
        dropListener.addDropConstraint(SlotHandle.class, cascadingParameterGroupChildrenConstraint);
        this.getTreeViewer().addDropSupport(ops, transfers, (DropTargetListener)dropListener);
    }

    public void dispose() {
        this.model.removeValidationListener((IValidationListener)this);
        IMediator mediator = SessionHandleAdapter.getInstance().getMediator(this.model, false);
        if (mediator != null) {
            mediator.removeColleague((IMediatorColleague)this.getSelectionSynchronizer());
        }
    }

    protected void createContextMenu() {
        ViewContextMenuProvider menuManager = new ViewContextMenuProvider((ISelectionProvider)this.getTreeViewer());
        Menu menu = menuManager.createContextMenu(this.getTreeViewer().getControl());
        this.getTreeViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu("outlinemenu", (MenuManager)menuManager, this.getSite().getSelectionProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.getTreeViewer());
        this.getTreeViewer().getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && e.keyCode == 102) {
                    new SearchAction(DesignerOutlinePage.this.getTreeViewer()).run();
                }
            }
        });
    }

    public ModuleHandle getRoot() {
        return this.model;
    }

    private void init(ModuleHandle reportHandle) {
        this.setTreeInput(reportHandle);
        reportHandle.addValidationListener((IValidationListener)this);
        this.handleGlobalAction();
    }

    private void setTreeInput(ModuleHandle reportHandle) {
        this.getTreeViewer().setInput((Object)new Object[]{reportHandle});
    }

    public NonGEFSynchronizerWithTreeView getSelectionSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = this.createNonGEFSynchronizerWithTreeView();
            this.synchronizer.setSource((Object)this);
        }
        return this.synchronizer;
    }

    protected NonGEFSynchronizerWithTreeView createNonGEFSynchronizerWithTreeView() {
        return new NonGEFSynchronizerWithTreeView();
    }

    protected void handleGlobalAction() {
        String id;
        String id2;
        int i = 0;
        while (i < GlobalActionFactory.GLOBAL_SELECTION_ACTIONS.length) {
            id2 = GlobalActionFactory.GLOBAL_SELECTION_ACTIONS[i];
            this.getSite().getActionBars().setGlobalActionHandler(id2, GlobalActionFactory.createSelectionAction((String)id2, (ISelectionProvider)this));
            ++i;
        }
        i = 0;
        while (i < GlobalActionFactory.GLOBAL_INSERT_ACTIONS.length) {
            id2 = GlobalActionFactory.GLOBAL_INSERT_ACTIONS[i];
            this.getSite().getActionBars().setGlobalActionHandler(id2, GlobalActionFactory.createSelectionAction((String)id2, (ISelectionProvider)this));
            ++i;
        }
        i = 0;
        while (i < GlobalActionFactory.GLOBAL_ELEMENT_ACTIONS.length) {
            id2 = GlobalActionFactory.GLOBAL_ELEMENT_ACTIONS[i];
            this.getSite().getActionBars().setGlobalActionHandler(id2, GlobalActionFactory.createSelectionAction((String)id2, (ISelectionProvider)this));
            ++i;
        }
        List list = ExtensionPointManager.getInstance().getExtendedElementPoints();
        for (ExtendedElementUIPoint point : list) {
            id = point.getExtensionName();
            this.getSite().getActionBars().setGlobalActionHandler(id, GlobalActionFactory.createSelectionAction((String)id, (ISelectionProvider)this));
        }
        PaletteEntryExtension[] entries = EditpartExtensionManager.getPaletteEntries();
        int i2 = 0;
        while (i2 < entries.length) {
            this.getSite().getActionBars().setGlobalActionHandler(entries[i2].getItemName(), GlobalActionFactory.createSelectionAction((String)entries[i2].getItemName(), (ISelectionProvider)this));
            ++i2;
        }
        this.getSite().getActionBars().setGlobalActionHandler("UseLibraryAction", (IAction)new RetargetAction("UseLibraryAction", ImportLibraryAction.ACTION_TEXT));
        i2 = 0;
        while (i2 < GlobalActionFactory.GLOBAL_STACK_ACTIONS.length) {
            id = GlobalActionFactory.GLOBAL_STACK_ACTIONS[i2];
            this.getSite().getActionBars().setGlobalActionHandler(id, GlobalActionFactory.createStackAction((String)id, (CommandStack)this.getRoot().getCommandStack()));
            ++i2;
        }
        this.getSite().getActionBars().updateActionBars();
    }

    public void elementValidated(DesignElementHandle targetElement, ValidationEvent ev) {
        this.getTreeViewer().refresh();
    }

    private String getTooltip(Object element) {
        return ProviderFactory.createProvider((Object)element).getNodeTooltip(element);
    }

    public IModelEventProcessor getModelProcessor() {
        return new DesignerOutlineEventProcessor(this){

            public void clear() {
                super.clear();
                if (DesignerOutlinePage.this.isDispose()) {
                    return;
                }
                DesignerOutlinePage.this.getTreeViewer().refresh();
            }
        };
    }

    public Runnable createModelEventRunnable(Object focus, int type, Map args) {
        switch (type) {
            case 0: {
                return new ReportEventRunnable(focus, type, args){

                    public void run() {
                        if (DesignerOutlinePage.this.isDispose()) {
                            return;
                        }
                        DesignerOutlinePage.this.getTreeViewer().refresh();
                        Object obj = this.getArgs().get("Event Content");
                        DesignerOutlinePage.this.expandNodeAfterCreation(obj);
                    }
                };
            }
        }
        return new ReportEventRunnable(focus, type, args){

            public void run() {
                if (DesignerOutlinePage.this.isDispose()) {
                    return;
                }
                DesignerOutlinePage.this.getTreeViewer().refresh();
            }
        };
    }

    protected void expandNodeAfterCreation(Object obj) {
        if (obj instanceof IDesignElement) {
            IDesignElement element = (IDesignElement)obj;
            this.getTreeViewer().expandToLevel((Object)element.getHandle(this.getRoot().getModule()), 0);
            if (this.backup != null) {
                this.backup.updateStatus(this.getTreeViewer());
            }
        }
    }

    public boolean isDispose() {
        if (this.getTreeViewer() == null || this.getTreeViewer().getTree() == null) {
            return true;
        }
        return this.getTreeViewer().getTree().isDisposed();
    }

    public void setBackupState(ITreeViewerBackup backup) {
        this.backup = backup;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.getTreeViewer();
    }
}

