/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.function;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.eclipse.birt.data.engine.api.timefunction.ReferenceDate;
import org.eclipse.birt.data.engine.api.timefunction.TimeMember;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.WeekToDateFunciton;
import org.junit.Test;
import testutil.BaseTestCase;

public class WeekToDateTest
extends BaseTestCase {
    @Test
    public void testWTD1() throws IOException {
        int[] values = new int[]{2011, 3, 9, 4, 39, 5, 22, 265};
        String[] types = new String[]{"year", "quarter", "month", "week-of-month", "week-of-year", "day-of-week", "day-of-month", "day-of-year"};
        TimeMember timeMember = new TimeMember(values, types);
        ReferenceDate referenceDate = new ReferenceDate(new Date(2011, 8, 22));
        WeekToDateFunciton weekToDate = new WeekToDateFunciton();
        weekToDate.setReferenceDate(referenceDate);
        List timeMembers = weekToDate.getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testWTD2() throws IOException {
        int[] values = new int[]{2011, 20, 5};
        String[] types = new String[]{"year", "week-of-year", "day-of-week"};
        ReferenceDate referenceDate = new ReferenceDate(new Date(2011, 4, 19));
        WeekToDateFunciton weekToDate = new WeekToDateFunciton();
        weekToDate.setReferenceDate(referenceDate);
        TimeMember timeMember = new TimeMember(values, types);
        List timeMembers = weekToDate.getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testWTD3() throws IOException {
        int[] values = new int[]{2002, 1, 2, 1, 7};
        String[] types = new String[]{"year", "quarter", "month", "week-of-month", "day-of-week"};
        ReferenceDate referenceDate = new ReferenceDate(new Date(2002, 1, 9));
        WeekToDateFunciton weekToDate = new WeekToDateFunciton();
        weekToDate.setReferenceDate(referenceDate);
        TimeMember timeMember = new TimeMember(values, types);
        List timeMembers = weekToDate.getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testWTD4() throws IOException {
        int[] values = new int[]{2011, 1, 2, 1};
        String[] types = new String[]{"year", "quarter", "month", "week-of-month"};
        ReferenceDate referenceDate = new ReferenceDate(new Date(2011, 1, 5));
        WeekToDateFunciton weekToDate = new WeekToDateFunciton();
        weekToDate.setReferenceDate(referenceDate);
        TimeMember timeMember = new TimeMember(values, types);
        List timeMembers = weekToDate.getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    private void printMembers(List<TimeMember> timeMembers) {
        for (TimeMember timeMember : timeMembers) {
            String[] levelTypes = timeMember.getLevelType();
            int[] memberValues = timeMember.getMemberValue();
            int i = 0;
            while (i < levelTypes.length) {
                this.testPrint(levelTypes[i] + " ");
                ++i;
            }
            this.testPrintln("");
            i = 0;
            while (i < memberValues.length) {
                this.testPrint(memberValues[i] + " ");
                ++i;
            }
            this.testPrintln("");
        }
    }
}

