/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.interactivity;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IUpdateNotifier;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.report.tests.chart.interactivity.PrimitiveCharts;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class SWTShowTooltipViewer
extends Composite
implements PaintListener,
IUpdateNotifier,
SelectionListener {
    private IDeviceRenderer idr = null;
    private Chart cm = null;
    private static Combo cbType = null;
    private static Button btn = null;
    private GeneratedChartState gcs = null;
    private boolean bNeedsGeneration = true;
    private Map contextMap = new HashMap();

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        shell.setSize(600, 400);
        shell.setLayout((Layout)new GridLayout());
        SWTShowTooltipViewer siv = new SWTShowTooltipViewer((Composite)shell, 262144);
        siv.setLayoutData(new GridData(1808));
        siv.addPaintListener(siv);
        Composite cBottom = new Composite((Composite)shell, 0);
        cBottom.setLayoutData((Object)new GridData(768));
        cBottom.setLayout((Layout)new RowLayout());
        Label la = new Label(cBottom, 0);
        la.setText("Choose: ");
        cbType = new Combo(cBottom, 12);
        cbType.add("Area Chart");
        cbType.add("Bar Chart");
        cbType.add("Line Chart");
        cbType.add("Meter Chart");
        cbType.add("Pie Chart");
        cbType.add("Scatter Chart");
        cbType.add("Stock Chart");
        cbType.select(0);
        btn = new Button(cBottom, 0);
        btn.setText("Update");
        btn.addSelectionListener((SelectionListener)siv);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    SWTShowTooltipViewer(Composite parent, int style) {
        super(parent, style);
        PluginSettings ps = PluginSettings.instance();
        try {
            this.idr = ps.getDevice("dv.SWT");
            this.idr.setProperty("device.component", (Object)this);
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = PrimitiveCharts.showTooltip_AreaChart();
    }

    public void paintControl(PaintEvent e) {
        Rectangle d = this.getClientArea();
        Image imgChart = new Image((Device)this.getDisplay(), d);
        GC gcImage = new GC((Drawable)imgChart);
        this.idr.setProperty("device.output.context", (Object)gcImage);
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)d.width, (double)d.height);
        bo.scale(72.0 / (double)this.idr.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        if (this.bNeedsGeneration) {
            this.bNeedsGeneration = false;
            try {
                this.gcs = gr.build(this.idr.getDisplayServer(), this.cm, bo, null, null, null);
            }
            catch (ChartException ce) {
                ce.printStackTrace();
            }
        }
        try {
            gr.render(this.idr, this.gcs);
            GC gc = e.gc;
            gc.drawImage(imgChart, d.x, d.y);
        }
        catch (ChartException ce) {
            ce.printStackTrace();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget.equals(btn)) {
            int iSelection = cbType.getSelectionIndex();
            switch (iSelection) {
                case 0: {
                    this.cm = PrimitiveCharts.showTooltip_AreaChart();
                    break;
                }
                case 1: {
                    this.cm = PrimitiveCharts.showTooltip_BarChart();
                    break;
                }
                case 2: {
                    this.cm = PrimitiveCharts.showTooltip_LineChart();
                    break;
                }
                case 3: {
                    this.cm = PrimitiveCharts.showTooltip_MeterChart();
                    break;
                }
                case 4: {
                    this.cm = PrimitiveCharts.showTooltip_PieChart();
                    break;
                }
                case 5: {
                    this.cm = PrimitiveCharts.showTooltip_ScatterChart();
                    break;
                }
                case 6: {
                    this.cm = PrimitiveCharts.showTooltip_StockChart();
                }
            }
            this.bNeedsGeneration = true;
            this.redraw();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public Chart getDesignTimeModel() {
        return this.cm;
    }

    public Chart getRunTimeModel() {
        return this.gcs.getChartModel();
    }

    public Object peerInstance() {
        return this;
    }

    public void regenerateChart() {
        this.bNeedsGeneration = true;
        this.redraw();
    }

    public void repaintChart() {
        this.redraw();
    }

    public Object getContext(Object key) {
        return this.contextMap.get(key);
    }

    public Object putContext(Object key, Object value) {
        return this.contextMap.put(key, value);
    }

    public Object removeContext(Object key) {
        return this.contextMap.remove(key);
    }
}

