/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import org.eclipse.birt.data.engine.olap.data.util.BufferedPrimitiveDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.Bytes;
import org.junit.Assert;
import org.junit.Test;

public class BufferedPrimitiveDiskArrayTest {
    @Test
    public void testInteger() throws IOException {
        int objectNumber = 1001;
        BufferedPrimitiveDiskArray list = new BufferedPrimitiveDiskArray(1);
        try {
            list.get(0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            list.get(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        int i = 0;
        while (i < objectNumber) {
            list.add((Object)new Integer(i));
            ++i;
        }
        Assert.assertEquals((long)list.size(), (long)objectNumber);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)list.get(i), (Object)new Integer(i));
            ++i;
        }
        try {
            list.get(objectNumber);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        list.clear();
        list.close();
    }

    @Test
    public void testSpecial() throws IOException {
        int objectNumber = 801;
        BufferedPrimitiveDiskArray list = new BufferedPrimitiveDiskArray(800);
        int i = 0;
        while (i < objectNumber) {
            list.add((Object)new Integer(i));
            try {
                list.get(i + 1);
                Assert.fail();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++i;
        }
        Assert.assertEquals((long)list.size(), (long)objectNumber);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)list.get(i), (Object)new Integer(i));
            ++i;
        }
        try {
            list.get(objectNumber);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        list.clear();
        list.close();
    }

    @Test
    public void testStress() throws IOException {
        int objectNumber = 10000;
        BufferedPrimitiveDiskArray list = new BufferedPrimitiveDiskArray(40000);
        int i = 0;
        while (i < objectNumber) {
            list.add((Object)new Integer(i));
            ++i;
        }
        Assert.assertEquals((long)list.size(), (long)objectNumber);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)list.get(i), (Object)new Integer(i));
            ++i;
        }
        list.clear();
        list.close();
    }

    @Test
    public void testDouble() throws IOException {
        int objectNumber = 1001;
        BufferedPrimitiveDiskArray list = new BufferedPrimitiveDiskArray(700);
        int i = 0;
        while (i < objectNumber) {
            list.add((Object)new Double(i));
            ++i;
        }
        Assert.assertEquals((long)list.size(), (long)objectNumber);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)list.get(i), (Object)new Double(i));
            ++i;
        }
        list.close();
    }

    @Test
    public void testBoolean() throws IOException {
        int objectNumber = 1001;
        BufferedPrimitiveDiskArray list = new BufferedPrimitiveDiskArray(500);
        int i = 0;
        while (i < objectNumber) {
            if (i % 2 == 0) {
                list.add((Object)new Boolean(false));
            } else {
                list.add((Object)new Boolean(true));
            }
            ++i;
        }
        Assert.assertEquals((long)list.size(), (long)objectNumber);
        i = 0;
        while (i < objectNumber) {
            if (i % 2 == 0) {
                Assert.assertEquals((Object)list.get(i), (Object)new Boolean(false));
            } else {
                Assert.assertEquals((Object)list.get(i), (Object)new Boolean(true));
            }
            ++i;
        }
        list.close();
    }

    @Test
    public void testString() throws IOException {
        int objectNumber = 200;
        BufferedPrimitiveDiskArray list = new BufferedPrimitiveDiskArray(300);
        int i = 0;
        while (i < objectNumber) {
            list.add((Object)("string" + i));
            ++i;
        }
        Assert.assertEquals((long)list.size(), (long)objectNumber);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)list.get(i), (Object)("string" + i));
            ++i;
        }
        list.close();
    }

    @Test
    public void testBytes() throws IOException {
        int objectNumber = 100;
        byte[] b = null;
        BufferedPrimitiveDiskArray list = new BufferedPrimitiveDiskArray(300);
        int i = 0;
        while (i < objectNumber) {
            b = new byte[]{(byte)i, (byte)(i + 1), (byte)(i + 2)};
            list.add((Object)new Bytes(b));
            ++i;
        }
        Assert.assertEquals((long)list.size(), (long)objectNumber);
        i = 0;
        while (i < objectNumber) {
            b = ((Bytes)list.get(i)).bytesValue();
            Assert.assertEquals((long)b[0], (long)i);
            Assert.assertEquals((long)b[1], (long)(i + 1));
            Assert.assertEquals((long)b[2], (long)(i + 2));
            ++i;
        }
        list.close();
    }

    @Test
    public void testBigDecimal() throws IOException {
        int objectNumber = 3000;
        BufferedPrimitiveDiskArray list = new BufferedPrimitiveDiskArray(300);
        int i = 0;
        while (i < objectNumber) {
            list.add((Object)new BigDecimal("1010101010101010101010" + i));
            ++i;
        }
        Assert.assertEquals((long)list.size(), (long)objectNumber);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)new BigDecimal("1010101010101010101010" + i), (Object)list.get(i));
            ++i;
        }
        list.close();
    }

    @Test
    public void testDate() throws IOException {
        int objectNumber = 4101;
        BufferedPrimitiveDiskArray list = new BufferedPrimitiveDiskArray(500);
        int i = 0;
        while (i < objectNumber) {
            list.add((Object)new Date(1900100000 + i * 1000));
            ++i;
        }
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)list.get(i), (Object)new Date(1900100000 + i * 1000));
            ++i;
        }
        list.close();
    }
}

