/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.util.ArrayList;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

class OdaResultSet
implements IDataSetPopulator {
    private ResultSet resultSet;
    private int status;
    private static final int UNKNOWN = -1;
    private static final int ODA_DATA = 0;
    private static final int ODA_PARAM = 1;

    OdaResultSet(ResultSet rs) {
        this.resultSet = rs;
        this.status = -1;
    }

    @Override
    public IResultObject next() throws DataException {
        if (this.status == -1) {
            IResultObject resultObj = this.resultSet.fetch();
            if (resultObj != null) {
                this.status = 0;
                return resultObj;
            }
            this.status = 1;
            return new DummyResultObject();
        }
        if (this.status == 0) {
            return this.resultSet.fetch();
        }
        return null;
    }

    static class DummyResultObject
    implements IResultObject {
        DummyResultObject() {
        }

        @Override
        public Object getFieldValue(String fieldName) throws DataException {
            return null;
        }

        @Override
        public Object getFieldValue(int fieldIndex) throws DataException {
            return null;
        }

        @Override
        public IResultClass getResultClass() {
            try {
                return new ResultClass(new ArrayList<ResultFieldMetadata>());
            }
            catch (DataException e) {
                assert (false);
                return null;
            }
        }

        @Override
        public void setCustomFieldValue(String fieldName, Object value) throws DataException {
        }

        @Override
        public void setCustomFieldValue(int fieldIndex, Object value) throws DataException {
        }
    }
}

