/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTagElement;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExportsDirective;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.OpensDirective;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ProvidesDirective;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.RequiresDirective;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UsesDirective;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.indexing.SourceIndexer;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;

class DOMToIndexVisitor
extends ASTVisitor {
    private SourceIndexer sourceIndexer;
    private char[] packageName;
    private List<AbstractTypeDeclaration> enclosingTypes = new LinkedList<AbstractTypeDeclaration>();

    public DOMToIndexVisitor(SourceIndexer sourceIndexer) {
        super(true);
        this.sourceIndexer = sourceIndexer;
    }

    private AbstractTypeDeclaration currentType() {
        return this.enclosingTypes.get(this.enclosingTypes.size() - 1);
    }

    @Override
    public boolean visit(PackageDeclaration packageDeclaration) {
        this.packageName = packageDeclaration.getName().getFullyQualifiedName().toCharArray();
        return false;
    }

    @Override
    public boolean visit(TypeDeclaration type) {
        char[][] enclosing = type.isLocalTypeDeclaration() ? IIndexConstants.ONE_ZERO_CHAR : (char[][])this.enclosingTypes.stream().map(AbstractTypeDeclaration::getName).map(SimpleName::getIdentifier).map(String::toCharArray).toArray(n -> new char[n][]);
        char[][] parameterTypeSignatures = (char[][])type.typeParameters().stream().map(TypeParameter::getName).map(ASTNode::toString).map(name -> Signature.createTypeSignature(name, false)).map(String::toCharArray).toArray(n -> new char[n][]);
        if (type.isInterface()) {
            this.sourceIndexer.addInterfaceDeclaration(type.getModifiers() | this.maybeDeprecated(type), this.packageName, DOMToIndexVisitor.simpleName(type.getName()), enclosing, (char[][])type.superInterfaceTypes().stream().map(this::name).toArray(n -> new char[n][]), parameterTypeSignatures, this.isSecondary(type));
        } else {
            this.sourceIndexer.addClassDeclaration(type.getModifiers() | this.maybeDeprecated(type), this.packageName, DOMToIndexVisitor.simpleName(type.getName()), enclosing, type.getSuperclassType() == null ? null : this.name(type.getSuperclassType()), (char[][])type.superInterfaceTypes().stream().map(this::name).toArray(n -> new char[n][]), parameterTypeSignatures, this.isSecondary(type));
            if (type.bodyDeclarations().stream().noneMatch(member -> {
                MethodDeclaration method;
                return member instanceof MethodDeclaration && (method = (MethodDeclaration)member).isConstructor();
            })) {
                this.sourceIndexer.addDefaultConstructorDeclaration(type.getName().getIdentifier().toCharArray(), this.packageName, type.getModifiers() | this.maybeDeprecated(type), 0);
            }
            if (type.getSuperclassType() != null) {
                this.sourceIndexer.addConstructorReference(this.name(type.getSuperclassType()), 0);
            }
        }
        this.enclosingTypes.add(type);
        return true;
    }

    @Override
    public void endVisit(TypeDeclaration type) {
        this.enclosingTypes.remove(type);
    }

    @Override
    public boolean visit(EnumDeclaration type) {
        char[][] enclosing = (char[][])this.enclosingTypes.stream().map(AbstractTypeDeclaration::getName).map(SimpleName::getIdentifier).map(String::toCharArray).toArray(n -> new char[n][]);
        this.sourceIndexer.addEnumDeclaration(type.getModifiers() | this.maybeDeprecated(type), this.packageName, type.getName().getIdentifier().toCharArray(), enclosing, Enum.class.getName().toCharArray(), (char[][])type.superInterfaceTypes().stream().map(this::name).toArray(n -> new char[n][]), this.isSecondary(type));
        this.enclosingTypes.add(type);
        return true;
    }

    @Override
    public void endVisit(EnumDeclaration type) {
        this.enclosingTypes.remove(type);
    }

    @Override
    public boolean visit(EnumConstantDeclaration enumConstant) {
        this.sourceIndexer.addFieldDeclaration(this.currentType().getName().getIdentifier().toCharArray(), enumConstant.getName().getIdentifier().toCharArray());
        this.sourceIndexer.addConstructorReference(this.currentType().getName().getIdentifier().toCharArray(), enumConstant.arguments().size());
        return true;
    }

    @Override
    public boolean visit(AnnotationTypeDeclaration type) {
        char[][] enclosing = (char[][])this.enclosingTypes.stream().map(AbstractTypeDeclaration::getName).map(SimpleName::getIdentifier).map(String::toCharArray).toArray(n -> new char[n][]);
        this.sourceIndexer.addAnnotationTypeDeclaration(type.getModifiers() | this.maybeDeprecated(type), this.packageName, type.getName().getIdentifier().toCharArray(), enclosing, this.isSecondary(type));
        this.enclosingTypes.add(type);
        return true;
    }

    @Override
    public void endVisit(AnnotationTypeDeclaration type) {
        this.enclosingTypes.remove(type);
    }

    private boolean isSecondary(AbstractTypeDeclaration type) {
        return type.getParent() instanceof CompilationUnit && !Objects.equals(type.getName().getIdentifier() + ".java", Path.of(this.sourceIndexer.document.getPath(), new String[0]).getFileName().toString());
    }

    @Override
    public boolean visit(RecordDeclaration recordDecl) {
        this.enclosingTypes.add(recordDecl);
        this.sourceIndexer.addClassDeclaration(recordDecl.getModifiers() | this.maybeDeprecated(recordDecl), this.packageName, recordDecl.getName().getIdentifier().toCharArray(), null, null, (char[][])recordDecl.superInterfaceTypes().stream().map(this::name).toArray(n -> new char[n][]), null, false);
        return true;
    }

    @Override
    public void endVisit(RecordDeclaration type) {
        this.enclosingTypes.remove(type);
    }

    @Override
    public boolean visit(MethodDeclaration method) {
        char[] methodName = method.getName().getIdentifier().toCharArray();
        char[][] parameterTypes = (char[][])method.parameters().stream().filter(SingleVariableDeclaration.class::isInstance).map(SingleVariableDeclaration.class::cast).map(SingleVariableDeclaration::getType).map(ASTNode::toString).map(String::toCharArray).toArray(n -> new char[n][]);
        char[] returnType = method.getReturnType2() == null ? null : method.getReturnType2().toString().toCharArray();
        char[][] exceptionTypes = (char[][])method.thrownExceptionTypes().stream().map(ASTNode::toString).map(String::toCharArray).toArray(n -> new char[n][]);
        char[][] parameterNames = (char[][])method.parameters().stream().map(VariableDeclaration::getName).map(SimpleName::getIdentifier).map(String::toCharArray).toArray(n -> new char[n][]);
        if (!method.isConstructor()) {
            this.sourceIndexer.addMethodDeclaration(methodName, parameterTypes, returnType, exceptionTypes);
            if (!this.enclosingTypes.isEmpty()) {
                this.sourceIndexer.addMethodDeclaration(this.enclosingTypes.get(this.enclosingTypes.size() - 1).getName().getIdentifier().toCharArray(), null, methodName, parameterTypes.length, null, parameterTypes, parameterNames, returnType, method.getModifiers() | this.maybeDeprecated(method), this.packageName, 0, exceptionTypes, 0);
            }
        } else {
            this.sourceIndexer.addConstructorDeclaration(method.getName().getFullyQualifiedName().toCharArray(), method.parameters().size(), null, parameterTypes, parameterNames, method.getModifiers() | this.maybeDeprecated(method), this.packageName, this.currentType().getModifiers(), exceptionTypes, 0);
        }
        return true;
    }

    @Override
    public boolean visit(ImportDeclaration node) {
        if (node.isStatic() && !node.isOnDemand()) {
            this.sourceIndexer.addMethodReference(DOMToIndexVisitor.simpleName(node.getName()), 0);
        } else if (Modifier.isModule(node.getModifiers())) {
            this.sourceIndexer.addModuleReference(node.getName().getFullyQualifiedName().toCharArray());
        }
        if (!node.isOnDemand()) {
            this.sourceIndexer.addTypeReference(node.getName().getFullyQualifiedName().toCharArray());
        }
        return true;
    }

    @Override
    public boolean visit(FieldDeclaration field) {
        char[] typeName = field.getType() == null ? null : field.getType().toString().toCharArray();
        for (VariableDeclarationFragment fragment : field.fragments()) {
            this.sourceIndexer.addFieldDeclaration(typeName, fragment.getName().getIdentifier().toCharArray());
        }
        return true;
    }

    @Override
    public boolean visit(MethodInvocation methodInvocation) {
        this.sourceIndexer.addMethodReference(methodInvocation.getName().getIdentifier().toCharArray(), methodInvocation.arguments().size());
        return true;
    }

    @Override
    public boolean visit(ExpressionMethodReference methodInvocation) {
        IMethodBinding binding;
        int argsCount = 0;
        if (this.sourceIndexer.document.shouldIndexResolvedDocument() && (binding = methodInvocation.resolveMethodBinding()) != null) {
            argsCount = binding.getParameterTypes().length;
        }
        this.sourceIndexer.addMethodReference(methodInvocation.getName().getIdentifier().toCharArray(), argsCount);
        return true;
    }

    @Override
    public boolean visit(TypeMethodReference methodInvocation) {
        IMethodBinding binding;
        int argsCount = 0;
        if (this.sourceIndexer.document.shouldIndexResolvedDocument() && (binding = methodInvocation.resolveMethodBinding()) != null) {
            argsCount = binding.getParameterTypes().length;
        }
        this.sourceIndexer.addMethodReference(methodInvocation.getName().getIdentifier().toCharArray(), argsCount);
        return true;
    }

    @Override
    public boolean visit(SuperMethodInvocation methodInvocation) {
        this.sourceIndexer.addMethodReference(methodInvocation.getName().getIdentifier().toCharArray(), methodInvocation.arguments().size());
        return true;
    }

    @Override
    public boolean visit(SuperMethodReference methodInvocation) {
        IMethodBinding binding;
        int argsCount = 0;
        if (this.sourceIndexer.document.shouldIndexResolvedDocument() && (binding = methodInvocation.resolveMethodBinding()) != null) {
            argsCount = binding.getParameterTypes().length;
        }
        this.sourceIndexer.addMethodReference(methodInvocation.getName().getIdentifier().toCharArray(), argsCount);
        return true;
    }

    @Override
    public boolean visit(ClassInstanceCreation methodInvocation) {
        this.sourceIndexer.addConstructorReference(this.name(methodInvocation.getType()), methodInvocation.arguments().size());
        if (methodInvocation.getAnonymousClassDeclaration() != null) {
            this.sourceIndexer.addClassDeclaration(0, this.packageName, new char[0], IIndexConstants.ONE_ZERO_CHAR, this.name(methodInvocation.getType()), null, null, false);
            this.sourceIndexer.addTypeReference(this.name(methodInvocation.getType()));
        }
        return true;
    }

    @Override
    public boolean visit(CreationReference methodInvocation) {
        IMethodBinding binding;
        int argsCount = 0;
        if (this.sourceIndexer.document.shouldIndexResolvedDocument() && (binding = methodInvocation.resolveMethodBinding()) != null) {
            argsCount = binding.getParameterTypes().length;
        }
        this.sourceIndexer.addConstructorReference(this.name(methodInvocation.getType()), argsCount);
        return true;
    }

    @Override
    public boolean visit(SuperConstructorInvocation node) {
        TypeDeclaration decl;
        char[] superClassName = Object.class.getName().toCharArray();
        AbstractTypeDeclaration abstractTypeDeclaration = this.currentType();
        if (abstractTypeDeclaration instanceof TypeDeclaration && (decl = (TypeDeclaration)abstractTypeDeclaration).getSuperclassType() != null) {
            superClassName = this.name(decl.getSuperclassType());
        }
        this.sourceIndexer.addConstructorReference(superClassName, node.arguments().size());
        return true;
    }

    private char[] name(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof PrimitiveType) {
            PrimitiveType primitive = (PrimitiveType)type;
            return primitive.toString().toCharArray();
        }
        if (type instanceof SimpleType) {
            SimpleType simpleType = (SimpleType)type;
            return DOMToIndexVisitor.simpleName(simpleType.getName());
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)type;
            return this.name(parameterized.getType());
        }
        return type.toString().toCharArray();
    }

    @Override
    public boolean visit(NormalAnnotation annotation) {
        this.sourceIndexer.addAnnotationTypeReference(DOMToIndexVisitor.simpleName(annotation.getTypeName()));
        return true;
    }

    @Override
    public boolean visit(MarkerAnnotation annotation) {
        this.sourceIndexer.addAnnotationTypeReference(DOMToIndexVisitor.simpleName(annotation.getTypeName()));
        return true;
    }

    @Override
    public boolean visit(SingleMemberAnnotation annotation) {
        this.sourceIndexer.addAnnotationTypeReference(DOMToIndexVisitor.simpleName(annotation.getTypeName()));
        return true;
    }

    @Override
    public boolean visit(SimpleType type) {
        this.sourceIndexer.addTypeReference(this.name(type));
        return true;
    }

    @Override
    public boolean visit(QualifiedType type) {
        this.sourceIndexer.addTypeReference(this.name(type));
        return true;
    }

    @Override
    public boolean visit(SimpleName name) {
        char[] id = name.getIdentifier().toCharArray();
        this.sourceIndexer.addNameReference(id);
        this.sourceIndexer.addIndexMetaQualification(id, false);
        return true;
    }

    @Override
    public boolean visit(MethodRef methodRef) {
        this.sourceIndexer.addMethodReference(methodRef.getName().getIdentifier().toCharArray(), methodRef.parameters().size());
        this.sourceIndexer.addConstructorReference(methodRef.getName().getIdentifier().toCharArray(), methodRef.parameters().size());
        return true;
    }

    @Override
    public boolean visit(MemberRef memberRef) {
        this.sourceIndexer.addFieldReference(memberRef.getName().getIdentifier().toCharArray());
        this.sourceIndexer.addTypeReference(memberRef.getName().getIdentifier().toCharArray());
        return true;
    }

    @Override
    public boolean visit(LambdaExpression node) {
        IMethodBinding binding = node.resolveMethodBinding();
        if (binding != null) {
            this.sourceIndexer.addIndexEntry(IIndexConstants.METHOD_DECL, MethodPattern.createIndexKey(binding.getName().toCharArray(), binding.getParameterTypes().length));
            this.sourceIndexer.addClassDeclaration(0, CharOperation.NO_CHAR, IIndexConstants.ONE_ZERO, IIndexConstants.ONE_ZERO_CHAR, CharOperation.NO_CHAR, new char[][]{binding.getDeclaringClass().getQualifiedName().toCharArray()}, CharOperation.NO_CHAR_CHAR, true);
        }
        return true;
    }

    private static char[] simpleName(Name name) {
        if (name instanceof SimpleName) {
            SimpleName simple = (SimpleName)name;
            return simple.getIdentifier().toCharArray();
        }
        if (name instanceof QualifiedName) {
            QualifiedName qualified = (QualifiedName)name;
            return DOMToIndexVisitor.simpleName(qualified.getName());
        }
        return null;
    }

    @Override
    public boolean visit(ModuleDeclaration node) {
        this.sourceIndexer.addModuleDeclaration(node.getName().getFullyQualifiedName().toCharArray());
        return true;
    }

    @Override
    public boolean visit(RequiresDirective node) {
        this.sourceIndexer.addModuleReference(node.getName().getFullyQualifiedName().toCharArray());
        return true;
    }

    @Override
    public boolean visit(ExportsDirective node) {
        this.sourceIndexer.addModuleExportedPackages(node.getName().getFullyQualifiedName().toCharArray());
        for (Name moduleName : node.modules()) {
            this.sourceIndexer.addModuleReference(moduleName.getFullyQualifiedName().toCharArray());
        }
        return true;
    }

    @Override
    public boolean visit(ProvidesDirective node) {
        this.sourceIndexer.addTypeReference(node.getName().getFullyQualifiedName().toCharArray());
        for (Name n : node.implementations()) {
            this.sourceIndexer.addTypeReference(n.getFullyQualifiedName().toCharArray());
        }
        return true;
    }

    @Override
    public boolean visit(UsesDirective node) {
        this.sourceIndexer.addTypeReference(node.getName().toString().toCharArray());
        return true;
    }

    @Override
    public boolean visit(OpensDirective node) {
        this.sourceIndexer.addModuleExportedPackages(node.getName().getFullyQualifiedName().toCharArray());
        for (Name moduleName : node.modules()) {
            this.sourceIndexer.addModuleReference(moduleName.getFullyQualifiedName().toCharArray());
        }
        return true;
    }

    private int maybeDeprecated(BodyDeclaration declaration) {
        return this.hasDeprecated(declaration.modifiers()) || this.hasDeprecated(declaration.getJavadoc()) ? 0x100000 : 0;
    }

    private boolean hasDeprecated(List<?> modifiers) {
        if (modifiers == null) {
            return false;
        }
        return modifiers.stream().filter(Annotation.class::isInstance).map(Annotation.class::cast).map(Annotation::getTypeName).map(Name::getFullyQualifiedName).anyMatch(Deprecated.class.getSimpleName()::equals);
    }

    private boolean hasDeprecated(Javadoc javadoc) {
        if (javadoc == null) {
            return false;
        }
        return javadoc.tags().stream().filter(TagElement.class::isInstance).map(TagElement.class::cast).map(AbstractTagElement::getTagName).anyMatch("@deprecated"::equals);
    }
}

