/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.common.statemachine.validation;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.vp.ms.AndOperation;
import org.polarsys.capella.vp.ms.BooleanExpression;
import org.polarsys.capella.vp.ms.NotOperation;
import org.polarsys.capella.vp.ms.OrOperation;
import org.polarsys.capella.vp.ms.Situation;

public class MDCHK_MSVAL_SituationInternalConsistency
extends AbstractModelConstraint {
    Collection<IStatus> objectsIrregularList = new ArrayList<IStatus>();

    public IStatus validate(IValidationContext ctx) {
        this.objectsIrregularList.clear();
        EObject eObj = ctx.getTarget();
        if (eObj instanceof Situation) {
            this.checkOrAnd(((Situation)eObj).getExpression(), ctx);
            this.checkNot(((Situation)eObj).getExpression(), ctx);
        }
        if (this.objectsIrregularList.size() > 0) {
            return ConstraintStatus.createMultiStatus((IValidationContext)ctx, this.objectsIrregularList);
        }
        return ctx.createSuccessStatus();
    }

    private void checkOrAnd(BooleanExpression be, IValidationContext ctx) {
        String error = "'AND' / 'OR' operator must have minimum 2 operands";
        if (be.eContents().size() < 2 && (be instanceof OrOperation || be instanceof AndOperation)) {
            this.objectsIrregularList.add(ctx.createFailureStatus(new Object[]{error}));
        } else {
            for (EObject obj : be.eContents()) {
                if (!((BooleanExpression)obj instanceof OrOperation) && !((BooleanExpression)obj instanceof AndOperation)) continue;
                this.checkOrAnd((BooleanExpression)obj, ctx);
            }
        }
    }

    private void checkNot(BooleanExpression be, IValidationContext ctx) {
        String error = "'NOT' operator must have exactly one operand";
        if (be.eContents().size() > 1 && be instanceof NotOperation) {
            this.objectsIrregularList.add(ctx.createFailureStatus(new Object[]{error}));
        } else {
            for (EObject obj : be.eContents()) {
                if (!((BooleanExpression)obj instanceof NotOperation)) continue;
                this.checkNot((BooleanExpression)obj, ctx);
            }
        }
    }
}

