/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.ms.impl;

import java.util.ArrayDeque;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.polarsys.capella.common.data.activity.ActivityEdge;
import org.polarsys.capella.common.data.activity.InputPin;
import org.polarsys.capella.common.data.activity.OutputPin;
import org.polarsys.capella.common.data.modellingcore.AbstractInformationFlow;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.capellacore.impl.NamedElementImpl;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.vp.ms.CSConfiguration;
import org.polarsys.capella.vp.ms.MsPackage;
import org.polarsys.capella.vp.ms.Situation;
import org.polarsys.capella.vp.ms.access_Type;
import org.polarsys.capella.vp.ms.kind_Type;

public class CSConfigurationImpl
extends NamedElementImpl
implements CSConfiguration {
    protected EList<AbstractState> supportedModes;
    protected EList<ModelElement> included;
    protected EList<ModelElement> excluded;
    protected EList<CSConfiguration> childConfigurations;
    protected static final kind_Type KIND_EDEFAULT = kind_Type.ATOMIC;
    protected kind_Type kind = KIND_EDEFAULT;
    protected static final access_Type ACCESS_EDEFAULT = access_Type.FULL;
    protected access_Type access = ACCESS_EDEFAULT;
    protected EList<Situation> context;
    protected EList<CSConfiguration> compareTo;

    protected CSConfigurationImpl() {
    }

    protected EClass eStaticClass() {
        return MsPackage.Literals.CS_CONFIGURATION;
    }

    @Override
    public EList<AbstractState> getSupportedModes() {
        if (this.supportedModes == null) {
            this.supportedModes = new EObjectResolvingEList(AbstractState.class, (InternalEObject)this, 22);
        }
        return this.supportedModes;
    }

    @Override
    public EList<ModelElement> getIncluded() {
        if (this.included == null) {
            this.included = new EObjectResolvingEList(ModelElement.class, (InternalEObject)this, 23);
        }
        return this.included;
    }

    @Override
    public EList<ModelElement> getExcluded() {
        if (this.excluded == null) {
            this.excluded = new EObjectResolvingEList(ModelElement.class, (InternalEObject)this, 24);
        }
        return this.excluded;
    }

    @Override
    public EList<CSConfiguration> getChildConfigurations() {
        if (this.childConfigurations == null) {
            this.childConfigurations = new EObjectResolvingEList(CSConfiguration.class, (InternalEObject)this, 25);
        }
        return this.childConfigurations;
    }

    @Override
    public kind_Type getKind() {
        return this.kind;
    }

    @Override
    public void setKind(kind_Type newKind) {
        kind_Type oldKind = this.kind;
        kind_Type kind_Type2 = this.kind = newKind == null ? KIND_EDEFAULT : newKind;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 26, (Object)oldKind, (Object)this.kind));
        }
    }

    @Override
    public access_Type getAccess() {
        return this.access;
    }

    @Override
    public void setAccess(access_Type newAccess) {
        access_Type oldAccess = this.access;
        access_Type access_Type2 = this.access = newAccess == null ? ACCESS_EDEFAULT : newAccess;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 27, (Object)oldAccess, (Object)this.access));
        }
    }

    @Override
    public EList<Situation> getContext() {
        if (this.context == null) {
            this.context = new EObjectResolvingEList(Situation.class, (InternalEObject)this, 28);
        }
        return this.context;
    }

    @Override
    public EList<CSConfiguration> getCompareTo() {
        if (this.compareTo == null) {
            this.compareTo = new EObjectResolvingEList(CSConfiguration.class, (InternalEObject)this, 29);
        }
        return this.compareTo;
    }

    @Override
    public EList<ModelElement> getScope() {
        UniqueEList result = new UniqueEList();
        if (this.eContainer() instanceof Component) {
            Component parent = (Component)this.eContainer();
            this.addComboBoxElements((Collection<ModelElement>)result, parent);
        } else if (this.eContainer() instanceof ComponentPkg) {
            TreeIterator it = this.eContainer().eAllContents();
            while (it.hasNext()) {
                EObject next = (EObject)it.next();
                if (!(next instanceof Component)) continue;
                it.prune();
                this.addComboBoxElements((Collection<ModelElement>)result, (Component)next);
                result.add((Object)((ModelElement)next));
            }
        }
        return result;
    }

    @Override
    public <T extends ModelElement> EList<T> getScope(Class<T> type) {
        BasicEList result = new BasicEList();
        for (ModelElement e : this.getScope()) {
            if (!type.isInstance(e)) continue;
            result.add((Object)e);
        }
        return result;
    }

    private void handlePart(Collection<ModelElement> result, Part part) {
        AbstractType type = part.getAbstractType();
        result.add((ModelElement)type);
        if (type instanceof Component && this.getAccess() == access_Type.FULL || this.getAccess() == access_Type.SUBCOMPONENTS) {
            this.addComboBoxElements(result, (Component)type);
        }
    }

    private void addComboBoxElements(Collection<ModelElement> result, Component parent) {
        for (Feature f : parent.getOwnedFeatures()) {
            if (!(f instanceof Part) || !((Part)f).getDeployingParts().isEmpty()) continue;
            this.handlePart(result, (Part)f);
        }
        ArrayDeque toVisit = new ArrayDeque();
        if (parent instanceof PhysicalComponent) {
            toVisit.addAll(((PhysicalComponent)parent).getOwnedPhysicalComponentPkgs());
        } else if (parent instanceof LogicalComponent) {
            toVisit.addAll(((LogicalComponent)parent).getOwnedLogicalComponentPkgs());
        }
        while (!toVisit.isEmpty()) {
            ComponentPkg pkg = (ComponentPkg)toVisit.pop();
            for (Part p : pkg.getOwnedParts()) {
                this.handlePart(result, p);
            }
            if (pkg instanceof PhysicalComponentPkg) {
                toVisit.addAll(((PhysicalComponentPkg)pkg).getOwnedPhysicalComponentPkgs());
                continue;
            }
            if (!(pkg instanceof LogicalComponentPkg)) continue;
            toVisit.addAll(((LogicalComponentPkg)pkg).getOwnedLogicalComponentPkgs());
        }
        for (Part representingPart : parent.getRepresentingParts()) {
            for (InstanceRole ir : representingPart.getRepresentingInstanceRoles()) {
                if (!(ir.eContainer() instanceof Scenario)) continue;
                result.add((ModelElement)((Scenario)ir.eContainer()));
            }
            if (this.getAccess() != access_Type.FULL) continue;
            for (Part deployed : representingPart.getDeployedParts()) {
                this.handlePart(result, deployed);
            }
        }
        for (AbstractFunction allocated : parent.getAllocatedFunctions()) {
            result.add((ModelElement)allocated);
            for (InstanceRole ir : allocated.getRepresentingInstanceRoles()) {
                if (!(ir.eContainer() instanceof Scenario)) continue;
                result.add((ModelElement)((Scenario)ir.eContainer()));
            }
            for (InputPin in : allocated.getInputs()) {
                if (!(in instanceof FunctionInputPort)) continue;
                result.add((ModelElement)in);
            }
            for (OutputPin out : allocated.getOutputs()) {
                if (!(out instanceof FunctionOutputPort)) continue;
                result.add((ModelElement)out);
            }
            for (ActivityEdge edge : allocated.getIncoming()) {
                if (!result.contains(edge.getSource())) continue;
                result.add((ModelElement)edge);
            }
            for (ActivityEdge edge : allocated.getOutgoing()) {
                if (!result.contains(edge.getTarget())) continue;
                result.add((ModelElement)edge);
            }
            for (FunctionalChain chain : allocated.getInvolvingFunctionalChains()) {
                result.add((ModelElement)chain);
            }
        }
        for (ComponentPort cp : parent.getContainedComponentPorts()) {
            result.add((ModelElement)cp);
            for (ComponentExchange e : cp.getComponentExchanges()) {
                if (cp == e.getSourcePort()) {
                    if (!result.contains(e.getTargetPort())) continue;
                    result.add((ModelElement)e);
                    continue;
                }
                if (cp != e.getTargetPort() || !result.contains(e.getSourcePort())) continue;
                result.add((ModelElement)e);
            }
        }
        for (PhysicalPort pp : parent.getContainedPhysicalPorts()) {
            result.add((ModelElement)pp);
            for (PhysicalLink l : pp.getInvolvedLinks()) {
                if (pp == l.getSourcePhysicalPort()) {
                    if (!result.contains(l.getTargetPhysicalPort())) continue;
                    result.add((ModelElement)l);
                    continue;
                }
                if (pp != l.getTargetPhysicalPort() || !result.contains(l.getSourcePhysicalPort())) continue;
                result.add((ModelElement)l);
            }
        }
        if (parent instanceof InformationsExchanger) {
            for (AbstractInformationFlow f : ((InformationsExchanger)parent).getOutgoingInformationFlows()) {
                if (!(f instanceof CommunicationMean) || !result.contains(((CommunicationMean)f).getTarget())) continue;
                result.add((ModelElement)f);
            }
            for (AbstractInformationFlow f : ((InformationsExchanger)parent).getIncomingInformationFlows()) {
                if (!(f instanceof CommunicationMean) || !result.contains(((CommunicationMean)f).getSource())) continue;
                result.add((ModelElement)f);
            }
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 22: {
                return this.getSupportedModes();
            }
            case 23: {
                return this.getIncluded();
            }
            case 24: {
                return this.getExcluded();
            }
            case 25: {
                return this.getChildConfigurations();
            }
            case 26: {
                return this.getKind();
            }
            case 27: {
                return this.getAccess();
            }
            case 28: {
                return this.getContext();
            }
            case 29: {
                return this.getCompareTo();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 22: {
                this.getSupportedModes().clear();
                this.getSupportedModes().addAll((Collection)newValue);
                return;
            }
            case 23: {
                this.getIncluded().clear();
                this.getIncluded().addAll((Collection)newValue);
                return;
            }
            case 24: {
                this.getExcluded().clear();
                this.getExcluded().addAll((Collection)newValue);
                return;
            }
            case 25: {
                this.getChildConfigurations().clear();
                this.getChildConfigurations().addAll((Collection)newValue);
                return;
            }
            case 26: {
                this.setKind((kind_Type)((Object)newValue));
                return;
            }
            case 27: {
                this.setAccess((access_Type)((Object)newValue));
                return;
            }
            case 28: {
                this.getContext().clear();
                this.getContext().addAll((Collection)newValue);
                return;
            }
            case 29: {
                this.getCompareTo().clear();
                this.getCompareTo().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 22: {
                this.getSupportedModes().clear();
                return;
            }
            case 23: {
                this.getIncluded().clear();
                return;
            }
            case 24: {
                this.getExcluded().clear();
                return;
            }
            case 25: {
                this.getChildConfigurations().clear();
                return;
            }
            case 26: {
                this.setKind(KIND_EDEFAULT);
                return;
            }
            case 27: {
                this.setAccess(ACCESS_EDEFAULT);
                return;
            }
            case 28: {
                this.getContext().clear();
                return;
            }
            case 29: {
                this.getCompareTo().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 22: {
                return this.supportedModes != null && !this.supportedModes.isEmpty();
            }
            case 23: {
                return this.included != null && !this.included.isEmpty();
            }
            case 24: {
                return this.excluded != null && !this.excluded.isEmpty();
            }
            case 25: {
                return this.childConfigurations != null && !this.childConfigurations.isEmpty();
            }
            case 26: {
                return this.kind != KIND_EDEFAULT;
            }
            case 27: {
                return this.access != ACCESS_EDEFAULT;
            }
            case 28: {
                return this.context != null && !this.context.isEmpty();
            }
            case 29: {
                return this.compareTo != null && !this.compareTo.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (kind: ");
        result.append((Object)this.kind);
        result.append(", access: ");
        result.append((Object)this.access);
        result.append(')');
        return result.toString();
    }
}

