/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.ms.ui.css.dom;

import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.e4.ui.css.core.dom.ElementAdapter;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.vp.ms.ui.css.CSSAdapter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EObjectElement
extends ElementAdapter
implements NodeList {
    public EObjectElement(EObject nativeWidget, CSSEngine engine) {
        super((Object)nativeWidget, engine);
    }

    public Node getParentNode() {
        return this.engine.getElement((Object)((EObject)this.getNativeWidget()).eContainer());
    }

    public NodeList getChildNodes() {
        return this;
    }

    public String getNamespaceURI() {
        return ((EObject)this.getNativeWidget()).eClass().getEPackage().getNsURI();
    }

    public String getCSSId() {
        return EcoreUtil.getID((EObject)((EObject)this.getNativeWidget()));
    }

    public String getCSSClass() {
        CSSAdapter eObjectCss = (CSSAdapter)EcoreUtil.getExistingAdapter((Notifier)((EObject)this.getNativeWidget()), CSSAdapter.class);
        return eObjectCss == null ? null : eObjectCss.getCSSClass();
    }

    public String getCSSStyle() {
        CSSAdapter eObjectCss = (CSSAdapter)EcoreUtil.getExistingAdapter((Notifier)((EObject)this.getNativeWidget()), CSSAdapter.class);
        return eObjectCss == null ? null : eObjectCss.getCSSStyle();
    }

    public String getLocalName() {
        return ((EObject)this.getNativeWidget()).eClass().getName();
    }

    public String getAttribute(String attr) {
        if ("class".equals(attr)) {
            return this.getCSSClass();
        }
        EObject widget = (EObject)this.getNativeWidget();
        for (EAttribute ea : widget.eClass().getEAllAttributes()) {
            if (!attr.equals(ea.getName())) continue;
            return EcoreUtil.convertToString((EDataType)ea.getEAttributeType(), (Object)widget.eGet((EStructuralFeature)ea));
        }
        for (EReference ref : widget.eClass().getEAllReferences()) {
            if (!ref.getName().equals(attr) || !widget.eIsSet((EStructuralFeature)ref)) continue;
            if (ref.isMany()) {
                Collection c = (Collection)widget.eGet((EStructuralFeature)ref);
                return c.stream().map(EObjectLabelProviderHelper::getText).collect(Collectors.joining(","));
            }
            return EObjectLabelProviderHelper.getText((Object)widget.eGet((EStructuralFeature)ref));
        }
        return null;
    }

    public final boolean hasAttribute(String attr) {
        return this.getAttribute(attr) != null;
    }

    @Override
    public int getLength() {
        return ((EObject)this.getNativeWidget()).eContents().size();
    }

    @Override
    public Node item(int index) {
        return this.getElement(((EObject)this.getNativeWidget()).eContents().get(index));
    }
}

