/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CleanUpRequirementsCore;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.fix.PotentialProgrammingProblemsFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFixCore;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class PotentialProgrammingProblemsCleanUpCore
extends AbstractMultiFixCore {
    public PotentialProgrammingProblemsCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public PotentialProgrammingProblemsCleanUpCore() {
    }

    @Override
    public CleanUpRequirementsCore getRequirementsCore() {
        boolean requireAST = this.requireAST();
        Map<String, String> requiredOptions = requireAST ? this.getRequiredOptions() : null;
        return new CleanUpRequirementsCore(requireAST, false, false, requiredOptions);
    }

    private boolean requireAST() {
        boolean addSUID = this.isEnabled("cleanup.add_serial_version_id");
        if (!addSUID) {
            return false;
        }
        return this.isEnabled("cleanup.add_generated_serial_version_id") || this.isEnabled("cleanup.add_default_serial_version_id");
    }

    @Override
    public ICleanUpFixCore createFix(CompilationUnit compilationUnit) throws CoreException {
        boolean addSUID = this.isEnabled("cleanup.add_serial_version_id");
        if (!addSUID) {
            return null;
        }
        return PotentialProgrammingProblemsFixCore.createCleanUp(compilationUnit, this.isEnabled("cleanup.add_generated_serial_version_id") || this.isEnabled("cleanup.add_default_serial_version_id"));
    }

    @Override
    public ICleanUpFixCore createFix(CompilationUnit compilationUnit, IProblemLocationCore[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return PotentialProgrammingProblemsFixCore.createCleanUp(compilationUnit, problems, this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_generated_serial_version_id") || this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_default_serial_version_id"));
    }

    private Map<String, String> getRequiredOptions() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_generated_serial_version_id") || this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_default_serial_version_id")) {
            result.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "warning");
        }
        return result;
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_generated_serial_version_id")) {
            result.add(MultiFixMessages.SerialVersionCleanUp_Generated_description);
        }
        if (this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_default_serial_version_id")) {
            result.add(MultiFixMessages.CodeStyleCleanUp_addDefaultSerialVersionId_description);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getPreview() {
        StringBuilder bld = new StringBuilder();
        bld.append("class E implements java.io.Serializable {\n");
        if (this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_generated_serial_version_id")) {
            bld.append("    private static final long serialVersionUID = -391484377137870342L;\n");
            bld.append("}\n");
        } else if (this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_default_serial_version_id")) {
            bld.append("    private static final long serialVersionUID = 1L;\n");
            bld.append("}\n");
        } else {
            bld.append("}\n\n");
        }
        return bld.toString();
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocationCore problem) {
        if (problem.getProblemId() == 0x20000060) {
            return this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_generated_serial_version_id") || this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_default_serial_version_id");
        }
        return false;
    }

    @Override
    public RefactoringStatus checkPreConditions(IJavaProject project, ICompilationUnit[] compilationUnits, IProgressMonitor monitor) throws CoreException {
        RefactoringStatus superStatus = super.checkPreConditions(project, compilationUnits, monitor);
        if (superStatus.hasFatalError()) {
            return superStatus;
        }
        return PotentialProgrammingProblemsFixCore.checkPreConditions(project, compilationUnits, monitor, this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_generated_serial_version_id"), this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_default_serial_version_id"), false);
    }

    @Override
    public RefactoringStatus checkPostConditions(IProgressMonitor monitor) throws CoreException {
        return PotentialProgrammingProblemsFixCore.checkPostConditions(monitor);
    }

    @Override
    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        if (this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_generated_serial_version_id") || this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_default_serial_version_id")) {
            return PotentialProgrammingProblemsCleanUpCore.getNumberOfProblems(compilationUnit.getProblems(), 0x20000060);
        }
        return 0;
    }
}

