/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.launching.launchConfigurations;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.internal.launching.AntLaunching;
import org.eclipse.ant.internal.launching.AntLaunchingUtil;
import org.eclipse.ant.internal.launching.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.launching.AbstractRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ContributedClasspathEntriesEntry
extends AbstractRuntimeClasspathEntry {
    public static final String TYPE_ID = "org.eclipse.ant.ui.classpathentry.extraClasspathEntries";
    public static List<IRuntimeClasspathEntry> fgSWTEntries = null;

    protected void buildMemento(Document document, Element memento) throws CoreException {
    }

    public void initializeFrom(Element memento) throws CoreException {
    }

    public String getTypeId() {
        return TYPE_ID;
    }

    public IRuntimeClasspathEntry[] getRuntimeClasspathEntries(ILaunchConfiguration configuration) throws CoreException {
        IAntClasspathEntry entry;
        boolean separateVM = AntLaunchingUtil.isSeparateJREAntBuild(configuration);
        boolean setInputHandler = configuration.getAttribute("org.eclipse.ant.uiSET_INPUTHANDLER", true);
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        IAntClasspathEntry[] antClasspathEntries = prefs.getContributedClasspathEntries();
        IAntClasspathEntry[] userEntries = prefs.getAdditionalClasspathEntries();
        ArrayList<IRuntimeClasspathEntry> rtes = new ArrayList<IRuntimeClasspathEntry>(antClasspathEntries.length + userEntries.length);
        IAntClasspathEntry[] iAntClasspathEntryArray = antClasspathEntries;
        int n = antClasspathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IAntClasspathEntry antClasspathEntry;
            entry = antClasspathEntry = iAntClasspathEntryArray[n2];
            if (!separateVM || separateVM && !entry.isEclipseRuntimeRequired()) {
                rtes.add(JavaRuntime.newStringVariableClasspathEntry((String)entry.getLabel()));
            }
            ++n2;
        }
        boolean haveToolsEntry = false;
        IAntClasspathEntry[] iAntClasspathEntryArray2 = userEntries;
        int n3 = userEntries.length;
        int n4 = 0;
        while (n4 < n3) {
            IAntClasspathEntry userEntry = iAntClasspathEntryArray2[n4];
            entry = userEntry;
            String path = entry.getLabel();
            Path toolsPath = new Path(path);
            if (toolsPath.lastSegment().equals("tools.jar")) {
                haveToolsEntry = true;
                this.addToolsJar(configuration, rtes, path);
            } else {
                rtes.add(JavaRuntime.newStringVariableClasspathEntry((String)path));
            }
            ++n4;
        }
        if (!haveToolsEntry) {
            this.addToolsJar(configuration, rtes, null);
        }
        if (setInputHandler && separateVM) {
            this.addSWTJars(rtes);
        }
        return rtes.toArray(new IRuntimeClasspathEntry[rtes.size()]);
    }

    private void addToolsJar(ILaunchConfiguration configuration, List<IRuntimeClasspathEntry> rtes, String path) {
        IRuntimeClasspathEntry tools = this.getToolsJar(configuration);
        if (tools == null) {
            if (path != null) {
                rtes.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(path)));
            } else {
                IAntClasspathEntry entry;
                IVMInstall install = JavaRuntime.getDefaultVMInstall();
                if (install != null && (entry = AntCorePlugin.getPlugin().getPreferences().getToolsJarEntry((IPath)new Path(install.getInstallLocation().getAbsolutePath()))) != null) {
                    try {
                        URL entryURL = entry.getEntryURL();
                        String pathString = this.resolveFileFromUrl(entryURL.getFile());
                        if (!pathString.isEmpty()) {
                            rtes.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(pathString)));
                        }
                    }
                    catch (MalformedURLException e) {
                        AntLaunching.log(e);
                    }
                }
            }
        } else {
            rtes.add(tools);
        }
    }

    private void addSWTJars(List<IRuntimeClasspathEntry> rtes) {
        if (fgSWTEntries == null) {
            fgSWTEntries = new ArrayList<IRuntimeClasspathEntry>();
            Bundle bundle = Platform.getBundle((String)"org.eclipse.swt");
            BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            List fragmentWires = wiring == null ? Collections.emptyList() : wiring.getProvidedWires("osgi.wiring.host");
            for (BundleWire fragmentWire : fragmentWires) {
                String[] names;
                URL bundleURL;
                Bundle fragmentBundle = fragmentWire.getRequirer().getBundle();
                try {
                    bundleURL = FileLocator.resolve((URL)fragmentBundle.getEntry("/"));
                }
                catch (IOException e) {
                    AntLaunching.log(e);
                    continue;
                }
                String urlFileName = bundleURL.getFile();
                try {
                    urlFileName = this.resolveFileFromUrl(urlFileName);
                }
                catch (MalformedURLException e) {
                    AntLaunching.log(e);
                    continue;
                }
                Path fragmentPath = new Path(urlFileName);
                if (fragmentPath.getFileExtension() != null) {
                    fgSWTEntries.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)fragmentPath));
                    continue;
                }
                File bundleFolder = fragmentPath.toFile();
                if (!bundleFolder.isDirectory()) continue;
                String[] stringArray = names = bundleFolder.list((dir, name) -> name.endsWith(".jar"));
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String jarName = stringArray[n2];
                    fgSWTEntries.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)fragmentPath.append(jarName)));
                    ++n2;
                }
            }
        }
        rtes.addAll(fgSWTEntries);
    }

    private String resolveFileFromUrl(String urlFileName) throws MalformedURLException {
        if (!urlFileName.startsWith("file:")) {
            return urlFileName;
        }
        try {
            URI uri = URIUtil.toURI((URL)new URL(urlFileName));
            urlFileName = URIUtil.toFile((URI)uri).getAbsolutePath();
        }
        catch (URISyntaxException e) {
            AntLaunching.log(e);
        }
        if (urlFileName.endsWith("!/") || urlFileName.endsWith("!\\")) {
            urlFileName = urlFileName.substring(0, urlFileName.length() - 2);
        }
        if (urlFileName.endsWith("!")) {
            urlFileName = urlFileName.substring(0, urlFileName.length() - 1);
        }
        return urlFileName;
    }

    private IRuntimeClasspathEntry getToolsJar(ILaunchConfiguration configuration) {
        try {
            IAntClasspathEntry entry;
            IVMInstall install = JavaRuntime.computeVMInstall((ILaunchConfiguration)configuration);
            if (install != null && (entry = AntCorePlugin.getPlugin().getPreferences().getToolsJarEntry((IPath)new Path(install.getInstallLocation().getAbsolutePath()))) != null) {
                return JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(entry.getEntryURL().getPath()));
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public String getName() {
        return AntLaunchConfigurationMessages.ContributedClasspathEntriesEntry_1;
    }

    public int getType() {
        return 5;
    }

    public boolean isComposite() {
        return true;
    }

    public boolean equals(Object obj) {
        return obj instanceof ContributedClasspathEntriesEntry;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

